( function ( $ ) {
	'use strict';

	var urTransliteration = {
		id: 'ur-transliteration',
		name: 'Urdu Transliteration',
		description: 'Urdu Transliteration based on RTS',
		date: '2012-10-16',
		URL: 'http://github.com/wikimedia/jquery.ime',
		author: 'Mohammed Imran Tabani',
		license: '',
		version: '1.0',
		patterns: [
			['x', 'ف'],
			['_', '_'],
			['D', 'ڑ'],
			['E', 'ذ'],
			['F', 'ں'],
			['R', 'ڈ'],
			['G', 'ۂ'],
			['T', 'ث'],
			['\\+', '+'],
			['S', 'ز'],
			['W', 'ض'],
			['A', 'ژ'],
			['Q', 'ظ'],
			['k', 'ک'],
			['K', 'گ'],
			['i', 'ب'],
			['I', 'ـ'],
			['U', 'ۃ'],
			/* Arabic semicolon */ ['\\;', '؛'],
			['\\:', ':'],
			['p', 'ح'],
			['P', 'خ'],
			['\\}', '{'],
			['\'', '\''],
			['\"', '\"'],
			['\\[', ']'],
			['\\{', '{'],
			['C', 'ۓ'],
			['l', 'ی'],
			['L', 'ي'],
			['o', 'ج'],
			['O', 'چ'],
			['v', 'س'],
			['h', 'ہ'],
			['H', 'ء'],
			['y', 'پ'],
			['Y', '\u0651\u00AD'],
			['c', 'ے'],
			/* Arabic question mark */ ['\\?','؟'],
			['j', 'ا'],
			['n', 'غ'],
			['N', 'ئ'],
			['b', 'ش'],
			['\\<', '','>'],
			['m', 'ع'],
			['u', 'ت'],
			['\\]', '','['],
			['e', 'ھ'],
			['f', 'ن'],
			['r', 'د'],
			['g', 'ل'],
			['t', 'ٹ'],
			['\\=', '','='],
			['\\\\', '\\'],
			['s', 'و'],
			['w', 'ص'],
			['a', 'م'],
			['q', 'ط'],
			['d', 'ر'],
			['\\|', '|'],
			['/', '/'],
			['\\>', '<'],
			['0', '0'],
			['1', '1'],
			['2', '2'],
			['3', '3'],
			['4', '4'],
			['5', '5'],
			['6', '6'],
			['7', '7'],
			['8', '8'],
			['9', '9'],
			['\\@', '@'],
			['\\#', '','#'],
			['\\$', '','$'],
			['\\%', '','٪'],
			['\\^', '','^'],
			['\\&', 'ۖ'],
			/* Arabic star */ ['\\*', '٭'],
			['\\(', '('],
			['\\)', ')']]
	};

	$.ime.register( urTransliteration );
}( jQuery ) );
