<?php
/**
 * Copyright 2011 Gasol Wu. PIXNET Digital Media Corporation.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this listof conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDER AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the copyright holder.
 *
 * @copyright Copyright 2011 Gasol Wu <gasol.wu@gmail.com>
 * @license http://github.com/basdenooijer/solarium/raw/master/COPYING
 * @link http://www.solarium-project.org/
 *
 * @package Solarium
 * @subpackage Client
 */

/**
 * Parse MoreLikeThis response data
 *
 * @package Solarium
 * @subpackage Client
 */
class Solarium_Client_ResponseParser_MoreLikeThis extends Solarium_Client_ResponseParser_Select
{

    /**
     * Get result data for the response
     *
     * @param Solarium_Result_MoreLikeThis $result
     * @return array
     */
    public function parse($result)
    {
        $data = $result->getData();
        $query = $result->getQuery();

        $parseResult = parent::parse($result);
        if (isset($data['interestingTerms']) && 'none' != $query->getInterestingTerms()) {
            $terms = $data['interestingTerms'];
            if ('details' == $query->getInterestingTerms()) {
                $tempTerms = array();
                for ($i = 0; $i < count($terms); $i += 2) {
                    $tempTerms[$terms[$i]] = $terms[$i + 1];
                }
                $terms = $tempTerms;
            }
            $parseResult['interestingTerms'] = $terms;
        }

        if (isset($data['match']['docs'][0]) && true == $query->getMatchInclude()) {
            $matchData = $data['match']['docs'][0];

            $documentClass = $query->getOption('documentclass');
            $fields = (array)$matchData;
            $parseResult['match'] = new $documentClass($fields);
        }

        return $parseResult;
    }

}
