<?php
/**
 * Internationalisation file for Babel extension.
 *
 * @file
 * @ingroup Extensions
 */

$magicWords = array();

/** English (English) */
$magicWords['en'] = array(
	'babel' => array( 0, 'babel' ),
);

/** Arabic (العربية) */
$magicWords['ar'] = array(
	'babel' => array( 0, 'بابل' ),
);

/** Aramaic (ܐܪܡܝܐ) */
$magicWords['arc'] = array(
	'babel' => array( 0, 'ܒܒܠ' ),
);

/** Egyptian Spoken Arabic (مصرى) */
$magicWords['arz'] = array(
	'babel' => array( 0, 'بابل' ),
);

/** Chechen (нохчийн) */
$magicWords['ce'] = array(
	'babel' => array( 0, 'вавилон' ),
);

/** Zazaki (Zazaki) */
$magicWords['diq'] = array(
	'babel' => array( 0, 'babil' ),
);

/** Esperanto (Esperanto) */
$magicWords['eo'] = array(
	'babel' => array( 0, 'babelo' ),
);

/** Spanish (español) */
$magicWords['es'] = array(
	'babel' => array( 0, 'babel' ),
);

/** Estonian (eesti) */
$magicWords['et'] = array(
	'babel' => array( 0, 'paabel' ),
);

/** Persian (فارسی) */
$magicWords['fa'] = array(
	'babel' => array( 0, 'بابل' ),
);

/** French (français) */
$magicWords['fr'] = array(
	'babel' => array( 0, 'Babel' ),
);

/** Franco-Provençal (arpetan) */
$magicWords['frp'] = array(
	'babel' => array( 0, 'babél' ),
);

/** Hawaiian (Hawai`i) */
$magicWords['haw'] = array(
	'babel' => array( 0, 'babela' ),
);

/** Hebrew (עברית) */
$magicWords['he'] = array(
	'babel' => array( 0, 'בבל' ),
);

/** Hindi (हिन्दी) */
$magicWords['hi'] = array(
	'babel' => array( 0, 'बेबल' ),
);

/** Japanese (日本語) */
$magicWords['ja'] = array(
	'babel' => array( 0, 'バベル' ),
);

/** Georgian (ქართული) */
$magicWords['ka'] = array(
	'babel' => array( 0, 'ბაბილონი' ),
);

/** Korean (한국어) */
$magicWords['ko'] = array(
	'babel' => array( 0, '바벨' ),
);

/** Minangkabau (Baso Minangkabau) */
$magicWords['min'] = array(
	'babel' => array( 0, 'bhs' ),
);

/** Macedonian (македонски) */
$magicWords['mk'] = array(
	'babel' => array( 0, 'вавилон' ),
);

/** Malayalam (മലയാളം) */
$magicWords['ml'] = array(
	'babel' => array( 0, 'ബാബേൽ' ),
);

/** Marathi (मराठी) */
$magicWords['mr'] = array(
	'babel' => array( 0, 'बॅबेल' ),
);

/** Pashto (پښتو) */
$magicWords['ps'] = array(
	'babel' => array( 0, 'بابېل', 'babel' ),
);

/** Russian (русский) */
$magicWords['ru'] = array(
	'babel' => array( 0, 'вавилон' ),
);

/** Sinhala (සිංහල) */
$magicWords['si'] = array(
	'babel' => array( 0, 'බාබෙල්', 'babel' ),
);

/** Slovak (slovenčina) */
$magicWords['sk'] = array(
	'babel' => array( 0, 'babylon' ),
);

/** Serbian (Cyrillic script) (српски (ћирилица)‎) */
$magicWords['sr-ec'] = array(
	'babel' => array( 0, 'бабел' ),
);

/** Serbian (Latin script) (srpski (latinica)‎) */
$magicWords['sr-el'] = array(
	'babel' => array( 0, 'babel' ),
);

/** Turkish (Türkçe) */
$magicWords['tr'] = array(
	'babel' => array( 0, 'babil' ),
);

/** Tuvinian (тыва дыл) */
$magicWords['tyv'] = array(
	'babel' => array( 0, 'вавилон' ),
);

/** Ukrainian (українська) */
$magicWords['uk'] = array(
	'babel' => array( 0, 'вавилон', 'вавілон' ),
);

/** Urdu (اردو) */
$magicWords['ur'] = array(
	'babel' => array( 0, 'بابل' ),
);

/** Simplified Chinese (中文（简体）‎) */
$magicWords['zh-hans'] = array(
	'babel' => array( 0, '巴别' ),
);

/** Traditional Chinese (中文（繁體）‎) */
$magicWords['zh-hant'] = array(
	'babel' => array( 0, '巴別' ),
);