/* Generated by GOB (v2.0.15)   (do not edit directly) */

/* End world hunger, donate to the World Food Programme, http://www.wfp.org */

#define GOB_VERSION_MAJOR 2
#define GOB_VERSION_MINOR 0
#define GOB_VERSION_PATCHLEVEL 15

#define selfp (self->_priv)

#include <string.h> /* memset() */

#include "gtk-typer.h"

#include "gtk-typer-private.h"

#ifdef G_LIKELY
#define ___GOB_LIKELY(expr) G_LIKELY(expr)
#define ___GOB_UNLIKELY(expr) G_UNLIKELY(expr)
#else /* ! G_LIKELY */
#define ___GOB_LIKELY(expr) (expr)
#define ___GOB_UNLIKELY(expr) (expr)
#endif /* G_LIKELY */

#line 22 "gtk-typer.gob"

	#include "config.h"
	#include <stdlib.h>
	#include <gdk/gdkkeysyms.h>

	const gchar *ui_info =
	"<ui>"
	"  <toolbar name='ToolBar'>"
	"    <toolitem action='Use file'/>"
	"    <toolitem action='Use fortune'/>"
	"    <separator/>"
	"    <toolitem action='Use session'/>"
	"    <toolitem action='Save session'/>"
	"    <toolitem action='Save session as'/>"
	"    <separator/>"
	"    <toolitem action='Help'/>"
	"    <separator/>"
	"    <toolitem action='About'/>"
	"  </toolbar>"
	"</ui>";

	static GnomeVFSResult
	gnome_vfs_read_line(GnomeVFSHandle *handler, gchar **line)
	{
		GnomeVFSResult watcher;
		GString *buffer = g_string_new("");
		gchar c;
		GnomeVFSFileSize counter;
		while((watcher = gnome_vfs_read(handler, &c, 1 * sizeof(gchar), &counter)) == GNOME_VFS_OK && c != '\n')
			buffer = g_string_append_c(buffer, c);
		if(c == '\n')
			*line = g_strdup(buffer->str);
		return watcher;
	}
	
	guint
	g_str_count(gchar *str, gchar c)
	{
		guint i, r = 0;
		for(i = 0; i < strlen(str); i++)
		{
			if(str[i] == c) r++;
		}
		return r;
	}

#line 73 "gtk-typer.c"
/* self casting macros */
#define SELF(x) GTK_TYPER(x)
#define SELF_CONST(x) GTK_TYPER_CONST(x)
#define IS_SELF(x) GTK_IS_TYPER(x)
#define TYPE_SELF GTK_TYPE_TYPER
#define SELF_CLASS(x) GTK_TYPER_CLASS(x)

#define SELF_GET_CLASS(x) GTK_TYPER_GET_CLASS(x)

/* self typedefs */
typedef GtkTyper Self;
typedef GtkTyperClass SelfClass;

/* here are local prototypes */
static void gtk_typer_init (GtkTyper * o) G_GNUC_UNUSED;
static void gtk_typer_class_init (GtkTyperClass * c) G_GNUC_UNUSED;

/* pointer to the class of our parent */
static GtkWindowClass *parent_class = NULL;

/* Short form macros */
#define self_new gtk_typer_new
#define self_package_contents gtk_typer_package_contents
#define self_free gtk_typer_free
#define self_set_filer_title gtk_typer_set_filer_title
#define self_on_use_file gtk_typer_on_use_file
#define self_on_use_fortune gtk_typer_on_use_fortune
#define self_on_use_session gtk_typer_on_use_session
#define self_save_session gtk_typer_save_session
#define self_on_save_session gtk_typer_on_save_session
#define self_on_save_session_as gtk_typer_on_save_session_as
#define self_start gtk_typer_start
#define self_on_destroy gtk_typer_on_destroy
#define self_on_catcher_expose_event gtk_typer_on_catcher_expose_event
#define self_on_event gtk_typer_on_event
#define self_on_catcher_key_press_event gtk_typer_on_catcher_key_press_event
#define self_on_catcher_activate gtk_typer_on_catcher_activate
#define self_on_about gtk_typer_on_about
#define self_on_help gtk_typer_on_help
GType
gtk_typer_get_type (void)
{
	static GType type = 0;

	if ___GOB_UNLIKELY(type == 0) {
		static const GTypeInfo info = {
			sizeof (GtkTyperClass),
			(GBaseInitFunc) NULL,
			(GBaseFinalizeFunc) NULL,
			(GClassInitFunc) gtk_typer_class_init,
			(GClassFinalizeFunc) NULL,
			NULL /* class_data */,
			sizeof (GtkTyper),
			0 /* n_preallocs */,
			(GInstanceInitFunc) gtk_typer_init,
			NULL
		};

		type = g_type_register_static (GTK_TYPE_WINDOW, "GtkTyper", &info, (GTypeFlags)0);
	}

	return type;
}

/* a macro for creating a new object of our type */
#define GET_NEW ((GtkTyper *)g_object_new(gtk_typer_get_type(), NULL))

/* a function for creating a new object of our type */
#include <stdarg.h>
static GtkTyper * GET_NEW_VARG (const char *first, ...) G_GNUC_UNUSED;
static GtkTyper *
GET_NEW_VARG (const char *first, ...)
{
	GtkTyper *ret;
	va_list ap;
	va_start (ap, first);
	ret = (GtkTyper *)g_object_new_valist (gtk_typer_get_type (), first, ap);
	va_end (ap);
	return ret;
}

static void 
gtk_typer_init (GtkTyper * o G_GNUC_UNUSED)
{
#define __GOB_FUNCTION__ "Gtk:Typer::init"
#line 22 "gtk-typer.gob"
	o->streamer = NULL;
#line 161 "gtk-typer.c"
#line 22 "gtk-typer.gob"
	o->filer = NULL;
#line 164 "gtk-typer.c"
#line 22 "gtk-typer.gob"
	o->sessioner = NULL;
#line 167 "gtk-typer.c"
#line 22 "gtk-typer.gob"
	o->changer = FALSE;
#line 170 "gtk-typer.c"
}
#undef __GOB_FUNCTION__
static void 
gtk_typer_class_init (GtkTyperClass * c G_GNUC_UNUSED)
{
#define __GOB_FUNCTION__ "Gtk:Typer::class_init"

	parent_class = g_type_class_ref (GTK_TYPE_WINDOW);

}
#undef __GOB_FUNCTION__



#line 88 "gtk-typer.gob"
GtkWidget * 
gtk_typer_new (void)
#line 188 "gtk-typer.c"
{
#define __GOB_FUNCTION__ "Gtk:Typer::new"
{
#line 90 "gtk-typer.gob"
	
		GtkWidget *packager;
		GtkWidget *tmp;
		const GtkActionEntry entries[] = {
			{"Use file", GTK_STOCK_OPEN, "Use _file...", "<control>f", "Use a file", G_CALLBACK(self_on_use_file)},
			{"Use fortune", GTK_STOCK_EXECUTE, "Use fortune _epigram", "<control>e", "Use a fortune epigram", G_CALLBACK(self_on_use_fortune)},
			{"Use session", GTK_STOCK_OPEN, "_Use session", "<control>u", "Open a file session", G_CALLBACK(self_on_use_session)},
			{"Save session", GTK_STOCK_SAVE, "_Save session", "<control>s", "Save a file session", G_CALLBACK(self_on_save_session)},
			{"Save session as", GTK_STOCK_SAVE_AS, "Save session _as", "<control>a", "Save a file session as another file", G_CALLBACK(self_on_save_session_as)},
			{"Help", GTK_STOCK_HELP, "_Help", "F1", "Contents", G_CALLBACK(self_on_help)},
			{"About", GTK_STOCK_ABOUT, "_About...", "<control>a", "About " PACKAGE, G_CALLBACK(self_on_about)}
		};
		guint n_entries = G_N_ELEMENTS(entries);
		GtkActionGroup *actions;
		//static GkbdKeyboardDrawingGroupLevel groupsLevels[] = {{0, 1}, {0, 3}, {0, 0}, {0, 2}};
		static GkbdKeyboardDrawingGroupLevel groupsLevels[] = {{0, 0}, {1, 3}, {0, 1}, {1, 1}};
		static GkbdKeyboardDrawingGroupLevel *pGroupsLevels[] = {&groupsLevels[0], &groupsLevels[1], &groupsLevels[2], &groupsLevels[3]};
		static XkbComponentNamesRec names;
		Self *self = GET_NEW;

		gtk_window_set_title(GTK_WINDOW(self), PACKAGE);
		gtk_window_set_default_size(GTK_WINDOW(self), 800, 600);
		gtk_window_set_default_icon_from_file(ICONSDIR "/" PACKAGE ".png", NULL);

		self->tiper = gtk_tooltips_new();

		packager = gtk_vbox_new(FALSE, 0);

		actions = gtk_action_group_new("Actions");
		gtk_action_group_add_actions(actions, entries, n_entries, self);
		self->controller = gtk_ui_manager_new();
		gtk_ui_manager_insert_action_group(self->controller, actions, 0);
		gtk_window_add_accel_group(GTK_WINDOW(self), gtk_ui_manager_get_accel_group(self->controller));
		gtk_ui_manager_add_ui_from_string(self->controller, ui_info, -1, NULL);
		tmp =  gtk_ui_manager_get_widget(self->controller, "/ToolBar");
		gtk_box_pack_start(GTK_BOX(packager), tmp, FALSE, FALSE, 0);

		gtk_box_pack_start(GTK_BOX(packager), self_package_contents(self), FALSE, TRUE, 0);

		self->keyer = gkbd_keyboard_drawing_new();
		gkbd_keyboard_drawing_set_groups_levels(GKBD_KEYBOARD_DRAWING(self->keyer), pGroupsLevels);

		gkbd_keyboard_drawing_set_track_modifiers(GKBD_KEYBOARD_DRAWING(self->keyer), TRUE);
		gkbd_keyboard_drawing_set_track_config(GKBD_KEYBOARD_DRAWING(self->keyer), TRUE);

		memset(&names, '\0', sizeof(names));
		names.symbols = (gchar *) gkbd_keyboard_drawing_get_symbols(GKBD_KEYBOARD_DRAWING(self->keyer));
		names.keycodes = (gchar *) gkbd_keyboard_drawing_get_keycodes(GKBD_KEYBOARD_DRAWING(self->keyer));
		names.geometry = (gchar *) gkbd_keyboard_drawing_get_geometry(GKBD_KEYBOARD_DRAWING(self->keyer));
		names.types = (gchar *) gkbd_keyboard_drawing_get_types(GKBD_KEYBOARD_DRAWING(self->keyer));
		names.compat = (gchar *) gkbd_keyboard_drawing_get_compat(GKBD_KEYBOARD_DRAWING(self->keyer));
		gkbd_keyboard_drawing_set_keyboard(GKBD_KEYBOARD_DRAWING(self->keyer), &names);

		gtk_box_pack_start(GTK_BOX(packager), self->keyer, TRUE, TRUE, 0);

		self->informer = gtk_statusbar_new();
		gtk_box_pack_start(GTK_BOX(packager), self->informer, FALSE, TRUE, 0);

		self->progresser = gtk_progress_bar_new();
		gtk_box_pack_end(GTK_BOX(self->informer), self->progresser, FALSE, TRUE, 0);
		
		gtk_container_add(GTK_CONTAINER(self), packager);

		gtk_widget_set_sensitive(gtk_ui_manager_get_widget(self->controller, "/ToolBar/Save session"), FALSE);
		gtk_widget_set_sensitive(gtk_ui_manager_get_widget(self->controller, "/ToolBar/Save session as"), FALSE);
		g_signal_connect(G_OBJECT(self), "destroy", G_CALLBACK(self_on_destroy), self);

		gtk_window_set_focus(GTK_WINDOW(self), self->catcher);
		gtk_statusbar_push(GTK_STATUSBAR(self->informer), 0, "Select input");

		gtk_widget_show_all(GTK_WIDGET(self));

		return GTK_WIDGET(self);
	}}
#line 267 "gtk-typer.c"
#undef __GOB_FUNCTION__

#line 165 "gtk-typer.gob"
GtkWidget * 
gtk_typer_package_contents (GtkTyper * self)
#line 273 "gtk-typer.c"
{
#define __GOB_FUNCTION__ "Gtk:Typer::package_contents"
#line 165 "gtk-typer.gob"
	g_return_val_if_fail (self != NULL, (GtkWidget * )0);
#line 165 "gtk-typer.gob"
	g_return_val_if_fail (GTK_IS_TYPER (self), (GtkWidget * )0);
#line 280 "gtk-typer.c"
{
#line 167 "gtk-typer.gob"
	
		GtkWidget *packager;
		GdkColor tint;

		packager = gtk_vbox_new(FALSE, 0);

		// Rememberer
		self->rememberer = gtk_entry_new();
		gtk_editable_set_editable(GTK_EDITABLE(self->rememberer), FALSE);
		gtk_widget_set_sensitive(self->rememberer, FALSE);
		gtk_box_pack_start(GTK_BOX(packager), self->rememberer, FALSE, TRUE, 0);

		// Shower
		self->shower = gtk_entry_new();
		gtk_editable_set_editable(GTK_EDITABLE(self->shower), FALSE);
		gdk_color_parse("yellow", &tint);
		gtk_widget_modify_base(self->shower, GTK_STATE_NORMAL, &tint);
		gtk_tooltips_set_tip(GTK_TOOLTIPS(self->tiper), self->shower, "Text to type", "Shows the text that you should type in the white entry");
		gtk_box_pack_start(GTK_BOX(packager), self->shower, FALSE, TRUE, 0);

		// Futurer
		self->futurer = gtk_entry_new();
		gtk_editable_set_editable(GTK_EDITABLE(self->futurer), FALSE);
		gtk_widget_set_sensitive(self->futurer, FALSE);
		gtk_box_pack_start(GTK_BOX(packager), self->futurer, FALSE, TRUE, 0);

		// Catcher
		self->catcher = gtk_entry_new();
		gtk_tooltips_set_tip(GTK_TOOLTIPS(self->tiper), self->catcher, "Place to type", "Place to type the text that is showed in the yellow entry");
		gtk_box_pack_start(GTK_BOX(packager), self->catcher, FALSE, TRUE, 0);

		self->attributer = pango_attr_list_new();

		g_signal_connect(G_OBJECT(self), "event", G_CALLBACK(self_on_event), self);
		g_signal_connect(G_OBJECT(self->catcher), "key-press-event", G_CALLBACK(self_on_catcher_key_press_event), self);
		g_signal_connect(G_OBJECT(self->catcher), "expose-event", G_CALLBACK(self_on_catcher_expose_event), self);
		g_signal_connect(G_OBJECT(self->catcher), "activate", G_CALLBACK(self_on_catcher_activate), self);

		return packager;
	}}
#line 323 "gtk-typer.c"
#undef __GOB_FUNCTION__

#line 208 "gtk-typer.gob"
void 
gtk_typer_free (GtkTyper * self)
#line 329 "gtk-typer.c"
{
#define __GOB_FUNCTION__ "Gtk:Typer::free"
#line 208 "gtk-typer.gob"
	g_return_if_fail (self != NULL);
#line 208 "gtk-typer.gob"
	g_return_if_fail (GTK_IS_TYPER (self));
#line 336 "gtk-typer.c"
{
#line 210 "gtk-typer.gob"
	
		if(self->streamer) gnome_vfs_close(self->streamer);
		if(self->sessioner) g_free(self->sessioner);
		if(self->filer) g_free(self->filer);
		pango_attr_list_unref(self->attributer);
		gtk_widget_destroy(GTK_WIDGET(self));
	}}
#line 346 "gtk-typer.c"
#undef __GOB_FUNCTION__

#line 218 "gtk-typer.gob"
void 
gtk_typer_set_filer_title (GtkTyper * self)
#line 352 "gtk-typer.c"
{
#define __GOB_FUNCTION__ "Gtk:Typer::set_filer_title"
#line 218 "gtk-typer.gob"
	g_return_if_fail (self != NULL);
#line 218 "gtk-typer.gob"
	g_return_if_fail (GTK_IS_TYPER (self));
#line 359 "gtk-typer.c"
{
#line 220 "gtk-typer.gob"
	
		GnomeVFSFileInfo informer;
		gchar *titler;

		gnome_vfs_get_file_info(self->filer, &informer, GNOME_VFS_FILE_INFO_DEFAULT);
		titler = g_strdup_printf("%s - " PACKAGE, informer.name);
		gtk_window_set_title(GTK_WINDOW(self), titler);
		g_free(titler);
	}}
#line 371 "gtk-typer.c"
#undef __GOB_FUNCTION__

#line 230 "gtk-typer.gob"
void 
gtk_typer_on_use_file (GtkAction * action, gpointer data)
#line 377 "gtk-typer.c"
{
#define __GOB_FUNCTION__ "Gtk:Typer::on_use_file"
{
#line 232 "gtk-typer.gob"
	
		Self *self = SELF(data);
		GtkWidget *chooser;

		chooser = gtk_file_chooser_dialog_new("Open file ...", GTK_WINDOW(self), GTK_FILE_CHOOSER_ACTION_OPEN, GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL, GTK_STOCK_OPEN, GTK_RESPONSE_ACCEPT, NULL);
		gtk_widget_show_all(chooser);
		if(gtk_dialog_run(GTK_DIALOG(chooser)) == GTK_RESPONSE_ACCEPT)
		{
			if(self->streamer)
			{
				gnome_vfs_close(self->streamer);
				self->streamer = NULL;
			}
			if(gnome_vfs_open_fd(&self->streamer, fileno(tmpfile())) == GNOME_VFS_OK)
			{
				gchar *container;
				gint icounter;
				GnomeVFSFileSize counter;

				if(self->filer) g_free(self->filer);
				self->filer = gtk_file_chooser_get_uri(GTK_FILE_CHOOSER(chooser));
				self->liner = 0;
				gnome_vfs_read_entire_file(self->filer, &icounter, &container);
				self->linecounter = g_str_count(container, '\n');
				gnome_vfs_write(self->streamer, container, icounter, &counter);
				g_free(container);

				self_set_filer_title(self);
				gtk_progress_bar_set_fraction(GTK_PROGRESS_BAR(self->progresser), 0);
				gtk_widget_set_sensitive(gtk_ui_manager_get_widget(self->controller, "/ToolBar/Save session"), FALSE);
				gtk_widget_set_sensitive(gtk_ui_manager_get_widget(self->controller, "/ToolBar/Save session as"), TRUE);
				gnome_vfs_seek(self->streamer, GNOME_VFS_SEEK_START, 0);
				self_start(self);
				gtk_statusbar_pop(GTK_STATUSBAR(self->informer), 0);
			}
		}
		gtk_widget_destroy(chooser);
	}}
#line 420 "gtk-typer.c"
#undef __GOB_FUNCTION__

#line 271 "gtk-typer.gob"
void 
gtk_typer_on_use_fortune (GtkAction * action, gpointer data)
#line 426 "gtk-typer.c"
{
#define __GOB_FUNCTION__ "Gtk:Typer::on_use_fortune"
{
#line 273 "gtk-typer.gob"
	
		Self *self = SELF(data);

		if(self->streamer)
		{
			gnome_vfs_close(self->streamer);
			self->streamer = NULL;
		}
		if(gnome_vfs_open_fd(&self->streamer, fileno(tmpfile())) == GNOME_VFS_OK)
		{
			gchar *output;
			GnomeVFSFileSize counter;

			g_spawn_command_line_sync("fortune", &output, NULL, NULL, NULL);
			gnome_vfs_write(self->streamer, output, strlen(output) * sizeof(gchar), &counter);
			self->liner = 0;
			self->linecounter = g_str_count(output, '\n');
			g_free(output);

			gtk_window_set_title(GTK_WINDOW(self), PACKAGE);
			gtk_progress_bar_set_fraction(GTK_PROGRESS_BAR(self->progresser), 0);
			gtk_widget_set_sensitive(gtk_ui_manager_get_widget(self->controller, "/ToolBar/Save session"), FALSE);
			gtk_widget_set_sensitive(gtk_ui_manager_get_widget(self->controller, "/ToolBar/Save session as"), FALSE);
			gnome_vfs_seek(self->streamer, GNOME_VFS_SEEK_START, 0);
			self_start(self);
			gtk_statusbar_pop(GTK_STATUSBAR(self->informer), 0);
		}
	}}
#line 459 "gtk-typer.c"
#undef __GOB_FUNCTION__

#line 302 "gtk-typer.gob"
void 
gtk_typer_on_use_session (GtkAction * action, gpointer data)
#line 465 "gtk-typer.c"
{
#define __GOB_FUNCTION__ "Gtk:Typer::on_use_session"
{
#line 304 "gtk-typer.gob"
	
		Self *self = SELF(data);
		GtkWidget *chooser;

		chooser = gtk_file_chooser_dialog_new("Open file session ...", GTK_WINDOW(self), GTK_FILE_CHOOSER_ACTION_OPEN, GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL, GTK_STOCK_OPEN, GTK_RESPONSE_ACCEPT, NULL);
		gtk_widget_show_all(chooser);
		if(gtk_dialog_run(GTK_DIALOG(chooser)) == GTK_RESPONSE_ACCEPT)
		{
			GnomeVFSHandle *streamer;

			if(self->sessioner) g_free(self->sessioner);
			self->sessioner = gtk_file_chooser_get_uri(GTK_FILE_CHOOSER(chooser));
			if(gnome_vfs_open(&streamer, self->sessioner, GNOME_VFS_OPEN_READ) == GNOME_VFS_OK)
			{
				gchar *liner;

				if(self->filer) g_free(self->filer);
				gnome_vfs_read_line(streamer, &self->filer);
				gnome_vfs_read_line(streamer, &liner);
				self->liner = atoi(liner);
				g_free(liner);
				gnome_vfs_close(streamer);
				if(self->streamer)
				{
					gnome_vfs_close(self->streamer);
					self->streamer = NULL;
				}
				if(gnome_vfs_open_fd(&self->streamer, fileno(tmpfile())) == GNOME_VFS_OK)
				{
					GnomeVFSFileSize counter;
					gchar *container;
					gint i, icounter;

					gnome_vfs_read_entire_file(self->filer, &icounter, &container);
					self->linecounter = g_str_count(container, '\n');
					gnome_vfs_write(self->streamer, container, icounter, &counter);
					g_free(container);
					gnome_vfs_seek(self->streamer, GNOME_VFS_SEEK_START, 0);

					liner = NULL;
					for(i = 0; i < self->liner && (gnome_vfs_read_line(self->streamer, &liner) == GNOME_VFS_OK || liner); i++)
					{
						g_free(liner);
						liner = NULL;
					}
					if(liner) g_free(liner);
					self_set_filer_title(self);
					self_start(self);
					gtk_widget_set_sensitive(gtk_ui_manager_get_widget(self->controller, "/ToolBar/Save session"), TRUE);
					gtk_widget_set_sensitive(gtk_ui_manager_get_widget(self->controller, "/ToolBar/Save session as"), TRUE);
					gtk_progress_bar_set_fraction(GTK_PROGRESS_BAR(self->progresser), (float)self->liner / (float)self->linecounter);
					gtk_statusbar_pop(GTK_STATUSBAR(self->informer), 0);
				}
			}
		}
		gtk_widget_destroy(chooser);
	}}
#line 527 "gtk-typer.c"
#undef __GOB_FUNCTION__

#line 362 "gtk-typer.gob"
void 
gtk_typer_save_session (GtkTyper * self)
#line 533 "gtk-typer.c"
{
#define __GOB_FUNCTION__ "Gtk:Typer::save_session"
#line 362 "gtk-typer.gob"
	g_return_if_fail (self != NULL);
#line 362 "gtk-typer.gob"
	g_return_if_fail (GTK_IS_TYPER (self));
#line 540 "gtk-typer.c"
{
#line 364 "gtk-typer.gob"
	
		GnomeVFSHandle *saver;

		if(gnome_vfs_create(&saver, self->sessioner, GNOME_VFS_OPEN_WRITE | GNOME_VFS_OPEN_TRUNCATE, 0, 0664) == GNOME_VFS_OK)
		{
			GnomeVFSFileSize counter;

			gchar *liner;

			liner = g_strdup_printf("%s\n", self->filer);
			gnome_vfs_write(saver, liner, strlen(liner) * sizeof(gchar), &counter);
			g_free(liner);

			liner = g_strdup_printf("%i\n", self->liner);
			gnome_vfs_write(saver, liner, strlen(liner) * sizeof(gchar), &counter);
			g_free(liner);

			gnome_vfs_close(saver);
		}
	}}
#line 563 "gtk-typer.c"
#undef __GOB_FUNCTION__

#line 385 "gtk-typer.gob"
void 
gtk_typer_on_save_session (GtkAction * action, gpointer data)
#line 569 "gtk-typer.c"
{
#define __GOB_FUNCTION__ "Gtk:Typer::on_save_session"
{
#line 387 "gtk-typer.gob"
	
		Self *self = SELF(data);
		self_save_session(self);
	}}
#line 578 "gtk-typer.c"
#undef __GOB_FUNCTION__

#line 392 "gtk-typer.gob"
void 
gtk_typer_on_save_session_as (GtkAction * action, gpointer data)
#line 584 "gtk-typer.c"
{
#define __GOB_FUNCTION__ "Gtk:Typer::on_save_session_as"
{
#line 394 "gtk-typer.gob"
	
		Self *self = SELF(data);
		GtkWidget *chooser;

		chooser = gtk_file_chooser_dialog_new("Save session as...", GTK_WINDOW(self), GTK_FILE_CHOOSER_ACTION_SAVE, GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL, GTK_STOCK_SAVE, GTK_RESPONSE_ACCEPT, NULL);
		gtk_widget_show_all(chooser);
		if(gtk_dialog_run(GTK_DIALOG(chooser)) == GTK_RESPONSE_ACCEPT)
		{
			if(self->sessioner) g_free(self->sessioner);
			self->sessioner = gtk_file_chooser_get_uri(GTK_FILE_CHOOSER(chooser));
			self_save_session(self);
			gtk_widget_set_sensitive(gtk_ui_manager_get_widget(self->controller, "/ToolBar/Save session"), TRUE);
		}
		gtk_widget_destroy(chooser);
	}}
#line 604 "gtk-typer.c"
#undef __GOB_FUNCTION__

#line 410 "gtk-typer.gob"
void 
gtk_typer_start (GtkTyper * self)
#line 610 "gtk-typer.c"
{
#define __GOB_FUNCTION__ "Gtk:Typer::start"
#line 410 "gtk-typer.gob"
	g_return_if_fail (self != NULL);
#line 410 "gtk-typer.gob"
	g_return_if_fail (GTK_IS_TYPER (self));
#line 617 "gtk-typer.c"
{
#line 412 "gtk-typer.gob"
	
		gchar *line = NULL;

		gtk_entry_set_text(GTK_ENTRY(self->rememberer), "");
		if(gnome_vfs_read_line(self->streamer, &line) == GNOME_VFS_OK || line)
		{
			gtk_entry_set_text(GTK_ENTRY(self->shower), line);
			g_free(line); line = NULL;
			if(gnome_vfs_read_line(self->streamer, &line) == GNOME_VFS_OK || line)
			{
				gtk_entry_set_text(GTK_ENTRY(self->futurer), line);
				g_free(line);
			}
			else
			{
				gtk_statusbar_push(GTK_STATUSBAR(self->informer), 0, "End");
				gtk_entry_set_text(GTK_ENTRY(self->futurer), "");
			}
		}
		else
		{
			gtk_entry_set_text(GTK_ENTRY(self->shower), "");
			gtk_statusbar_push(GTK_STATUSBAR(self->informer), 0, "End");
			gtk_entry_set_text(GTK_ENTRY(self->futurer), "");
		}
		gtk_entry_set_text(GTK_ENTRY(self->catcher), "");
	}}
#line 647 "gtk-typer.c"
#undef __GOB_FUNCTION__

#line 440 "gtk-typer.gob"
void 
gtk_typer_on_destroy (GtkWidget * widget, gpointer data)
#line 653 "gtk-typer.c"
{
#define __GOB_FUNCTION__ "Gtk:Typer::on_destroy"
{
#line 442 "gtk-typer.gob"
	
		Self *self = SELF(widget);
		gtk_main_quit();
		gtk_typer_free(self);
	}}
#line 663 "gtk-typer.c"
#undef __GOB_FUNCTION__

#line 448 "gtk-typer.gob"
gboolean 
gtk_typer_on_catcher_expose_event (GtkWidget * widget, GdkEventExpose * event, gpointer data)
#line 669 "gtk-typer.c"
{
#define __GOB_FUNCTION__ "Gtk:Typer::on_catcher_expose_event"
{
#line 450 "gtk-typer.gob"
	
		Self *self = SELF(data);
		const gchar *showertext = gtk_entry_get_text(GTK_ENTRY(self->shower));
		const gchar *catchertext = gtk_entry_get_text(GTK_ENTRY(widget));
		PangoLayout *layouter = gtk_entry_get_layout(GTK_ENTRY(widget));
		PangoAttribute *tint;
		PangoAttribute *errorer;
		int i;

		pango_attr_list_unref(self->attributer);
		self->attributer = pango_attr_list_new();

		for(i = 0; i < strlen(catchertext); i++)
		{
			if(i > strlen(showertext) || catchertext[i] != showertext[i])
			{
				tint = pango_attr_underline_color_new(65535, 0, 0);
				errorer = pango_attr_underline_new(PANGO_UNDERLINE_ERROR);
				tint->start_index = errorer->start_index = i;
				tint->end_index = errorer->end_index = i + 1;
				pango_attr_list_insert(self->attributer, tint);
				pango_attr_list_insert(self->attributer, errorer);
			}
		}
		pango_layout_set_attributes(layouter, self->attributer);
		return FALSE;
	}}
#line 701 "gtk-typer.c"
#undef __GOB_FUNCTION__

#line 478 "gtk-typer.gob"
gboolean 
gtk_typer_on_event (GtkWidget * widget, GdkEvent * event, gpointer data)
#line 707 "gtk-typer.c"
{
#define __GOB_FUNCTION__ "Gtk:Typer::on_event"
{
#line 480 "gtk-typer.gob"
	
		Self *self = SELF(data);
		if(event->type == GDK_KEY_PRESS || event->type == GDK_KEY_RELEASE)
			gtk_widget_event(self->keyer, event);
		return FALSE;
	}}
#line 718 "gtk-typer.c"
#undef __GOB_FUNCTION__

#line 487 "gtk-typer.gob"
gboolean 
gtk_typer_on_catcher_key_press_event (GtkWidget * widget, GdkEventKey * event, gpointer data)
#line 724 "gtk-typer.c"
{
#define __GOB_FUNCTION__ "Gtk:Typer::on_catcher_key_press_event"
{
#line 489 "gtk-typer.gob"
	
		if(event->keyval == GDK_Tab && !(event->state & GDK_CONTROL_MASK))
		{
			gint position = gtk_editable_get_position(GTK_EDITABLE(widget));
			gtk_editable_insert_text(GTK_EDITABLE(widget), "\t", 1, &position); 
			gtk_editable_set_position(GTK_EDITABLE(widget), position);
			return TRUE;
		}
		else
			return FALSE;
	}}
#line 740 "gtk-typer.c"
#undef __GOB_FUNCTION__

#line 501 "gtk-typer.gob"
void 
gtk_typer_on_catcher_activate (GtkEntry * entry, gpointer data)
#line 746 "gtk-typer.c"
{
#define __GOB_FUNCTION__ "Gtk:Typer::on_catcher_activate"
{
#line 503 "gtk-typer.gob"
	
		Self *self = SELF(data);
		const gchar *showertext = gtk_entry_get_text(GTK_ENTRY(self->shower));
		const gchar *catchertext = gtk_entry_get_text(entry);

		if(self->liner < self->linecounter)
		{
			if(g_str_equal(showertext, catchertext))
			{
				gchar *line = NULL;

				gtk_entry_set_text(GTK_ENTRY(self->rememberer), gtk_entry_get_text(GTK_ENTRY(self->shower)));
				gtk_entry_set_text(GTK_ENTRY(self->shower), gtk_entry_get_text(GTK_ENTRY(self->futurer)));
				self->liner++;
				if(self->streamer)
				{
					if(gnome_vfs_read_line(self->streamer, &line) == GNOME_VFS_OK || line)
					{
						gtk_entry_set_text(GTK_ENTRY(self->futurer), line);
						g_free(line);
					}
					else
					{
						gnome_vfs_close(self->streamer);
						self->streamer = NULL;

						gtk_entry_set_text(GTK_ENTRY(self->futurer), "");
					}
				}
				gtk_entry_set_text(entry, "");
				gtk_progress_bar_set_fraction(GTK_PROGRESS_BAR(self->progresser), (float)self->liner / (float)self->linecounter);
				if(self->liner == self->linecounter)
					gtk_statusbar_push(GTK_STATUSBAR(self->informer), 0, "End");
			}
		}
	}}
#line 787 "gtk-typer.c"
#undef __GOB_FUNCTION__

#line 540 "gtk-typer.gob"
void 
gtk_typer_on_about (GtkAction * action, gpointer data)
#line 793 "gtk-typer.c"
{
#define __GOB_FUNCTION__ "Gtk:Typer::on_about"
{
#line 542 "gtk-typer.gob"
	
		Self *self = SELF(data);
		const gchar *authors[] = {"Juan Manuel Borges Caño <juanmabc3@gmail.com>", NULL};
		const gchar *artists[] = {"Akira TAGOH <tagoh@redhat.com>", "Juan Manuel Borges Caño <juanmabc3@gmail.com>", NULL};
		const gchar *documenters[] = { "Wikipedia, the free enciclopedia", NULL};
		const gchar *copyright = "Copyright © Juan Manuel Borges Caño";
		const gchar *license = 
			" This program is free software; you can redistribute it and/or modify\n"
			"it under the terms of the GNU General Public License as published by\n"
			"the Free Software Foundation; either version 2 of the License, or\n"
			"(at your option) any later version.\n"
			"\n"
			" This program is distributed in the hope that it will be useful,\n"
			"but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
			"MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
			"GNU General Public License for more details.\n"
			"\n"
			" You should have received a copy of the GNU General Public License\n"
			"along with this program; if not, write to the Free Software\n"
			"Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA";
		const gchar *comments = "A graphical typing trainer.";
		const gchar *version = VERSION;
		const gchar *website = "http://savannah.nongnu.org/projects/typer";
		gtk_show_about_dialog(GTK_WINDOW(self), "authors", authors, "artists", artists, "documenters", documenters, "copyright", copyright, "license", license, "comments", comments, "version", version, "website", website, NULL);

	}}
#line 824 "gtk-typer.c"
#undef __GOB_FUNCTION__

#line 569 "gtk-typer.gob"
void 
gtk_typer_on_help (GtkAction * action, gpointer data)
#line 830 "gtk-typer.c"
{
#define __GOB_FUNCTION__ "Gtk:Typer::on_help"
{
#line 571 "gtk-typer.gob"
	
		g_spawn_command_line_async("yelp " YELPDOCFILE, NULL);
	}}
#line 838 "gtk-typer.c"
#undef __GOB_FUNCTION__
