/*
 * Decompiled with CFR 0.152.
 */
package simtools.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.util.Iterator;
import java.util.ResourceBundle;
import java.util.TreeMap;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import simtools.data.DataException;
import simtools.data.DataSource;
import simtools.ui.ActionCheckBox;
import simtools.ui.MapperListener;
import simtools.ui.ResourceFinder;
import simtools.util.ListenerManager;
import simtools.util.NumberStringComparator;

public class GenericMapper
implements Serializable,
Cloneable {
    static final long serialVersionUID = -3336873194029698696L;
    public static ResourceBundle resources = ResourceFinder.get(class$simtools$ui$GenericMapper == null ? (class$simtools$ui$GenericMapper = GenericMapper.class$("simtools.ui.GenericMapper")) : class$simtools$ui$GenericMapper);
    public TreeMap map;
    public Vector intervals;
    public String name;
    public Object defaultValue;
    protected transient ListenerManager listeners = new ListenerManager();
    static /* synthetic */ Class class$simtools$ui$GenericMapper;
    static /* synthetic */ Class class$simtools$ui$GenericMapper$Expression;
    static /* synthetic */ Class class$java$lang$Object;

    public Object clone() throws CloneNotSupportedException {
        GenericMapper genericMapper = (GenericMapper)super.clone();
        genericMapper.map = (TreeMap)this.map.clone();
        genericMapper.intervals = (Vector)this.intervals.clone();
        genericMapper.listeners = new ListenerManager();
        return genericMapper;
    }

    public void addListener(MapperListener mapperListener) {
        this.listeners.add(mapperListener);
    }

    public void removeListener(MapperListener mapperListener) {
        this.listeners.remove(mapperListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyListeners() {
        ListenerManager listenerManager = this.listeners;
        synchronized (listenerManager) {
            int n = this.listeners.size();
            for (int i = 0; i < n; ++i) {
                MapperListener mapperListener = (MapperListener)this.listeners.get(i);
                if (mapperListener == null) continue;
                mapperListener.mappingChanged(this);
            }
        }
    }

    public GenericMapper() {
        this(null);
    }

    public GenericMapper(String string) {
        this.name = string;
        this.map = new TreeMap(new NumberStringComparator());
        this.intervals = new Vector();
    }

    public Object getMapping(DataSource dataSource, long l) {
        Object object;
        try {
            object = dataSource.getValue(l);
        }
        catch (DataException dataException) {
            return this.defaultValue;
        }
        return this.getMapping(object);
    }

    public Object getMapping(DataSource dataSource) {
        Object object;
        try {
            object = dataSource.getValue(dataSource.getLastIndex());
        }
        catch (DataException dataException) {
            return this.defaultValue;
        }
        return this.getMapping(object);
    }

    public Object getMapping(Object object) {
        Object v = this.map.get(object);
        if (v != null) {
            return v;
        }
        int n = -1;
        if (object instanceof Double || object instanceof Float) {
            n = 0;
        }
        if (object instanceof Long || object instanceof Integer || object instanceof Short || object instanceof Byte) {
            n = 1;
        }
        if (object instanceof String) {
            n = 2;
        }
        if (n == -1) {
            return this.defaultValue;
        }
        block5: for (int i = 0; i < this.intervals.size(); ++i) {
            Interval interval = (Interval)this.intervals.get(i);
            switch (n) {
                case 0: {
                    if (!interval.contains(((Number)object).doubleValue())) continue block5;
                    return interval.value;
                }
                case 1: {
                    if (!interval.contains(((Number)object).longValue())) continue block5;
                    return interval.value;
                }
                case 2: {
                    if (!interval.contains((String)object)) continue block5;
                    return interval.value;
                }
            }
        }
        return this.defaultValue;
    }

    public void setDefaultValue(Object object) {
        this.defaultValue = object;
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    public void setMapping(Object object, Object object2) {
        this.map.put(object, object2);
        this.notifyListeners();
    }

    public void setMapping(double d, double d2, Object object) {
        this.setMapping(d, true, d2, true, object);
    }

    public void setMapping(double d, boolean bl, double d2, boolean bl2, Object object) {
        this.intervals.add(new Interval(d, bl, d2, bl2, object));
        this.notifyListeners();
    }

    public void setMapping(boolean bl, double d, Object object) {
        this.setMapping(bl, d, true, object);
    }

    public void setMapping(boolean bl, double d, boolean bl2, Object object) {
        this.intervals.add(new Interval(bl, d, bl2, object));
        this.notifyListeners();
    }

    public void setMapping(long l, long l2, Object object) {
        this.setMapping(l, true, l2, true, object);
    }

    public void setMapping(long l, boolean bl, long l2, boolean bl2, Object object) {
        this.intervals.add(new Interval(l, bl, l2, bl2, object));
        this.notifyListeners();
    }

    public void setMapping(boolean bl, long l, Object object) {
        this.setMapping(bl, l, true, object);
    }

    public void setMapping(boolean bl, long l, boolean bl2, Object object) {
        this.intervals.add(new Interval(bl, l, bl2, object));
        this.notifyListeners();
    }

    public void setMapping(String string, String string2, Object object) {
        this.setMapping(string, true, string2, true, object);
    }

    public void setMapping(String string, boolean bl, String string2, boolean bl2, Object object) {
        this.intervals.add(new Interval(string, bl, string2, bl2, object));
        this.notifyListeners();
    }

    public void setMapping(boolean bl, String string, Object object) {
        this.setMapping(bl, string, true, object);
    }

    public void setMapping(boolean bl, String string, boolean bl2, Object object) {
        this.intervals.add(new Interval(bl, string, bl2, object));
        this.notifyListeners();
    }

    public String toString() {
        if (this.name != null) {
            return this.name;
        }
        return super.toString();
    }

    public boolean equals(Object object) {
        if (!(object instanceof GenericMapper)) {
            return false;
        }
        GenericMapper genericMapper = (GenericMapper)object;
        if (this.name == null && genericMapper.name == null) {
            return super.equals(object);
        }
        if (this.name == null || genericMapper.name == null) {
            return false;
        }
        return this.name.equals(genericMapper.name);
    }

    public static GenericMapper createMapperDialog(Frame frame) {
        GenericMapper genericMapper = new GenericMapper();
        genericMapper.editDialog(frame);
        return genericMapper;
    }

    public MapperTableModel createModel() {
        return new MapperTableModel();
    }

    protected ExpressionMappingTable createTable(Frame frame) {
        return new ExpressionMappingTable(frame);
    }

    protected Object createNewValue() {
        return new Double(Math.random());
    }

    public JPanel createPanel(Frame frame, ActionListener actionListener) {
        final ExpressionMappingTable expressionMappingTable = this.createTable(frame);
        final JPanel jPanel = new JPanel(new BorderLayout());
        final ActionListener actionListener2 = actionListener;
        Box box = Box.createHorizontalBox();
        final JTextField jTextField = new JTextField(20);
        box.add(new JLabel(resources.getString("MapperName:")));
        box.add(Box.createHorizontalGlue());
        box.add(jTextField);
        jTextField.setText(this.name == null ? "" : this.name);
        if (actionListener != null) {
            jPanel.add((Component)box, "North");
        }
        Box box2 = Box.createVerticalBox();
        box2.add(new JLabel(resources.getString("CurrentAssociations(double-clickToEdit)")));
        box2.add(new JScrollPane(expressionMappingTable));
        jPanel.add((Component)box2, "Center");
        JPanel jPanel2 = new JPanel(new BorderLayout());
        JPanel jPanel3 = new JPanel(new GridLayout(5, 1));
        JButton jButton = new JButton(resources.getString("NewValue"));
        jPanel3.add(jButton);
        JButton jButton2 = new JButton(resources.getString("NewInterval"));
        jPanel3.add(jButton2);
        final JButton jButton3 = new JButton(resources.getString("Delete"));
        jPanel3.add(jButton3);
        final JButton jButton4 = new JButton(resources.getString("MoveUp"));
        jPanel3.add(jButton4);
        final JButton jButton5 = new JButton(resources.getString("MoveDown"));
        jPanel3.add(jButton5);
        jPanel2.add((Component)jPanel3, "North");
        JButton jButton6 = new JButton(resources.getString("OK"));
        if (actionListener != null) {
            jPanel2.add((Component)jButton6, "South");
        }
        jPanel.add((Component)jPanel2, "East");
        jButton3.setEnabled(false);
        jButton4.setEnabled(false);
        jButton5.setEnabled(false);
        if (actionListener != null) {
            jTextField.getDocument().addDocumentListener(new DocumentListener(){

                public void insertUpdate(DocumentEvent documentEvent) {
                    this.updateName();
                }

                public void removeUpdate(DocumentEvent documentEvent) {
                    this.updateName();
                }

                public void changedUpdate(DocumentEvent documentEvent) {
                    this.updateName();
                }

                public void updateName() {
                    GenericMapper.this.name = jTextField.getText();
                    if (GenericMapper.this.name.equals("")) {
                        GenericMapper.this.name = null;
                    }
                    actionListener2.actionPerformed(new ActionEvent(jPanel, 1, GenericMapper.this.name == null ? resources.getString("UnnamedMapper") : GenericMapper.this.name));
                }
            });
        }
        expressionMappingTable.addSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                int n = expressionMappingTable.getSelectedRow();
                if (n == -1) {
                    jButton3.setEnabled(false);
                    jButton4.setEnabled(false);
                    jButton5.setEnabled(false);
                    return;
                }
                jButton3.setEnabled(true);
                Expression expression = (Expression)expressionMappingTable.tableModel.expressions.get(n);
                if (expression.value instanceof Interval) {
                    jButton4.setEnabled(n > 0 && ((Expression)expressionMappingTable.tableModel.expressions.get((int)(n - 1))).value instanceof Interval);
                    jButton5.setEnabled(n < expressionMappingTable.tableModel.expressions.size() - 1);
                } else {
                    jButton4.setEnabled(false);
                    jButton5.setEnabled(false);
                }
            }
        });
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n;
                Long l = null;
                for (n = 0; n < Integer.MAX_VALUE && GenericMapper.this.map.get(l = new Long(n)) != null; ++n) {
                }
                GenericMapper.this.map.put(l, GenericMapper.this.createNewValue());
                n = 0;
                Iterator iterator = GenericMapper.this.map.keySet().iterator();
                while (iterator.hasNext() && !iterator.next().equals(l)) {
                    ++n;
                }
                expressionMappingTable.tableModel.update(0, GenericMapper.this.map.size() + GenericMapper.this.intervals.size() - 1);
                expressionMappingTable.tableModel.fireTableRowsInserted(n, n);
                expressionMappingTable.setRowSelectionInterval(n, n);
            }
        });
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GenericMapper.this.intervals.add(new Interval(false, 0L, false, GenericMapper.this.createNewValue()));
                int n = GenericMapper.this.map.size() + GenericMapper.this.intervals.size() - 1;
                expressionMappingTable.tableModel.fireTableRowsInserted(n, n);
                expressionMappingTable.tableModel.update(0, n);
                expressionMappingTable.setRowSelectionInterval(n, n);
            }
        });
        jButton3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = expressionMappingTable.getSelectedRow();
                if (n < 0) {
                    return;
                }
                Expression expression = (Expression)expressionMappingTable.tableModel.expressions.get(n);
                if (n < GenericMapper.this.map.size()) {
                    GenericMapper.this.map.remove(expression.value);
                    expressionMappingTable.tableModel.fireTableRowsDeleted(n, n);
                    expressionMappingTable.tableModel.update(0, GenericMapper.this.map.size() + GenericMapper.this.intervals.size() - 1);
                    return;
                }
                GenericMapper.this.intervals.remove(expression.value);
                expressionMappingTable.tableModel.fireTableRowsDeleted(n, n);
                expressionMappingTable.tableModel.update(0, GenericMapper.this.map.size() + GenericMapper.this.intervals.size() - 1);
            }
        });
        jButton4.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = expressionMappingTable.getSelectedRow();
                int n2 = n - GenericMapper.this.map.size();
                if (n2 < 1 || n2 >= GenericMapper.this.intervals.size()) {
                    return;
                }
                Object e = GenericMapper.this.intervals.get(n2 - 1);
                Object e2 = GenericMapper.this.intervals.get(n2);
                GenericMapper.this.intervals.set(n2 - 1, e2);
                GenericMapper.this.intervals.set(n2, e);
                expressionMappingTable.tableModel.update(n - 1, n);
                expressionMappingTable.setRowSelectionInterval(n - 1, n - 1);
            }
        });
        jButton5.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = expressionMappingTable.getSelectedRow();
                int n2 = n - GenericMapper.this.map.size();
                if (n2 < 0 || n2 >= GenericMapper.this.intervals.size() - 1) {
                    return;
                }
                Object e = GenericMapper.this.intervals.get(n2);
                Object e2 = GenericMapper.this.intervals.get(n2 + 1);
                GenericMapper.this.intervals.set(n2, e2);
                GenericMapper.this.intervals.set(n2 + 1, e);
                expressionMappingTable.tableModel.update(n, n + 1);
                expressionMappingTable.setRowSelectionInterval(n + 1, n + 1);
            }
        });
        if (actionListener != null) {
            jButton6.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    actionListener2.actionPerformed(new ActionEvent(jPanel, 2, ""));
                }
            });
        }
        return jPanel;
    }

    public void editDialog(Frame frame) {
        final JDialog jDialog = new JDialog(frame, true);
        jDialog.setTitle(this.name == null ? resources.getString("UnnamedMapper") : this.name);
        JPanel jPanel = this.createPanel(frame, new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                switch (actionEvent.getID()) {
                    case 1: {
                        jDialog.setTitle(actionEvent.getActionCommand());
                        break;
                    }
                    case 2: {
                        jDialog.dispose();
                    }
                }
            }
        });
        jDialog.getContentPane().add(jPanel);
        jDialog.pack();
        jDialog.show();
        this.notifyListeners();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static class ExpressionDialog
    extends JDialog {
        JButton ok;
        JButton cancel;
        Expression current;
        ActionCheckBox mincb;
        ActionCheckBox maxcb;
        JTextField minValue;
        JTextField maxValue;
        JTextField theValue;
        JCheckBox minInc;
        JCheckBox maxInc;
        int mint;
        int maxt;
        long lmin;
        long lmax;
        double dmin;
        double dmax;
        String smin;
        String smax;
        int type;
        Box valuePanel;
        Box intervalPanel;

        public ExpressionDialog(Frame frame) {
            super(frame, true);
            this.setTitle(resources.getString("Editing:") + this.current);
            this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
            this.valuePanel = Box.createHorizontalBox();
            this.valuePanel.add(new JLabel(resources.getString("Value=")));
            this.theValue = new JTextField(10);
            this.valuePanel.add(this.theValue);
            this.valuePanel.setVisible(false);
            this.getContentPane().add(this.valuePanel);
            this.intervalPanel = Box.createVerticalBox();
            Box box = Box.createHorizontalBox();
            this.mincb = new ActionCheckBox(this, resources.getString("Min"), true){
                private final /* synthetic */ ExpressionDialog this$0;
                {
                    this.this$0 = expressionDialog;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    this.this$0.minValue.setEnabled(this.isSelected());
                    this.this$0.minInc.setEnabled(this.isSelected());
                }
            };
            box.add(this.mincb);
            this.minValue = new JTextField(10);
            box.add(this.minValue);
            this.minValue.getDocument().addDocumentListener(new DocumentListener(this){
                private final /* synthetic */ ExpressionDialog this$0;
                {
                    this.this$0 = expressionDialog;
                }

                public void insertUpdate(DocumentEvent documentEvent) {
                    this.this$0.updateType();
                }

                public void removeUpdate(DocumentEvent documentEvent) {
                    this.this$0.updateType();
                }

                public void changedUpdate(DocumentEvent documentEvent) {
                    this.this$0.updateType();
                }
            });
            this.minInc = new JCheckBox(resources.getString("BoundIncluded"), true);
            box.add(this.minInc);
            this.intervalPanel.add(box);
            box = Box.createHorizontalBox();
            this.maxcb = new ActionCheckBox(this, resources.getString("Max"), true){
                private final /* synthetic */ ExpressionDialog this$0;
                {
                    this.this$0 = expressionDialog;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    this.this$0.maxValue.setEnabled(this.isSelected());
                    this.this$0.maxInc.setEnabled(this.isSelected());
                }
            };
            box.add(this.maxcb);
            this.maxValue = new JTextField(10);
            box.add(this.maxValue);
            this.maxValue.getDocument().addDocumentListener(new DocumentListener(this){
                private final /* synthetic */ ExpressionDialog this$0;
                {
                    this.this$0 = expressionDialog;
                }

                public void insertUpdate(DocumentEvent documentEvent) {
                    this.this$0.updateType();
                }

                public void removeUpdate(DocumentEvent documentEvent) {
                    this.this$0.updateType();
                }

                public void changedUpdate(DocumentEvent documentEvent) {
                    this.this$0.updateType();
                }
            });
            this.maxInc = new JCheckBox(resources.getString("BoundIncluded"), true);
            box.add(this.maxInc);
            this.intervalPanel.add(box);
            this.intervalPanel.setVisible(false);
            this.getContentPane().add(this.intervalPanel);
            this.mincb.apply();
            this.maxcb.apply();
            box = Box.createHorizontalBox();
            box.add(Box.createHorizontalGlue());
            this.cancel = new JButton(resources.getString("Cancel"));
            box.add(this.cancel);
            this.ok = new JButton(resources.getString("OK"));
            box.add(this.ok);
            this.getContentPane().add(box);
            this.ok.addActionListener(new ActionListener(this){
                private final /* synthetic */ ExpressionDialog this$0;
                {
                    this.this$0 = expressionDialog;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    this.this$0.updateExpression();
                    this.this$0.hide();
                }
            });
            this.cancel.addActionListener(new ActionListener(this){
                private final /* synthetic */ ExpressionDialog this$0;
                {
                    this.this$0 = expressionDialog;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    this.this$0.hide();
                }
            });
            this.setDefaultCloseOperation(1);
            this.setResizable(false);
        }

        protected void updateType() {
            if (!(this.current.value instanceof Interval)) {
                return;
            }
            this.smin = this.minValue.getText();
            try {
                this.lmin = Long.decode(this.smin);
                this.dmin = this.lmin;
                this.mint = 1;
            }
            catch (NumberFormatException numberFormatException) {
                try {
                    this.dmin = Double.parseDouble(this.smin);
                    this.mint = 0;
                }
                catch (NumberFormatException numberFormatException2) {
                    this.mint = 2;
                }
            }
            this.smax = this.maxValue.getText();
            try {
                this.lmax = Long.decode(this.smax);
                this.dmax = this.lmax;
                this.maxt = 1;
            }
            catch (NumberFormatException numberFormatException) {
                try {
                    this.dmax = Double.parseDouble(this.smax);
                    this.maxt = 0;
                }
                catch (NumberFormatException numberFormatException3) {
                    this.maxt = 2;
                }
            }
            this.type = this.mincb.isSelected() && this.maxcb.isSelected() ? (this.mint == 2 || this.maxt == 2 ? 2 : (this.mint == 1 && this.maxt == 1 ? 1 : 0)) : (this.mincb.isSelected() ? this.mint : (this.maxcb.isSelected() ? this.maxt : 3));
        }

        protected void updateExpression() {
            if (this.current == null) {
                return;
            }
            if (this.current.value instanceof Interval) {
                if (this.minValue.getText().equals("")) {
                    this.mincb.setSelected(false);
                    this.mincb.apply();
                }
                if (this.maxValue.getText().equals("")) {
                    this.maxcb.setSelected(false);
                    this.maxcb.apply();
                }
                Object object = ((Interval)this.current.value).value;
                this.updateType();
                switch (this.type) {
                    case 0: {
                        if (this.mincb.isSelected() && this.maxcb.isSelected()) {
                            this.current.value = new Interval(this.dmin, this.minInc.isSelected(), this.dmax, this.maxInc.isSelected(), object);
                            break;
                        }
                        if (this.mincb.isSelected()) {
                            this.current.value = new Interval(true, this.dmin, this.minInc.isSelected(), object);
                            break;
                        }
                        this.current.value = new Interval(false, this.dmax, this.maxInc.isSelected(), object);
                        break;
                    }
                    case 1: {
                        if (this.mincb.isSelected() && this.maxcb.isSelected()) {
                            this.current.value = new Interval(this.lmin, this.minInc.isSelected(), this.lmax, this.maxInc.isSelected(), object);
                            break;
                        }
                        if (this.mincb.isSelected()) {
                            this.current.value = new Interval(true, this.lmin, this.minInc.isSelected(), object);
                            break;
                        }
                        this.current.value = new Interval(false, this.lmax, this.maxInc.isSelected(), object);
                        break;
                    }
                    case 2: {
                        if (this.mincb.isSelected() && this.maxcb.isSelected()) {
                            this.current.value = new Interval(this.smin, this.minInc.isSelected(), this.smax, this.maxInc.isSelected(), object);
                            break;
                        }
                        if (this.mincb.isSelected()) {
                            this.current.value = new Interval(true, this.smin, this.minInc.isSelected(), object);
                            break;
                        }
                        this.current.value = new Interval(false, this.smax, this.maxInc.isSelected(), object);
                        break;
                    }
                    case 3: {
                        this.current.value = new Interval(object);
                    }
                }
                return;
            }
            String string = this.theValue.getText();
            try {
                this.current.value = Long.decode(string);
            }
            catch (NumberFormatException numberFormatException) {
                try {
                    this.current.value = new Double(Double.parseDouble(string));
                }
                catch (NumberFormatException numberFormatException2) {
                    this.current.value = string;
                }
            }
        }

        public void edit(Expression expression) {
            this.copyExpression(expression);
            this.show();
        }

        public void copyExpression(Expression expression) {
            try {
                this.current = (Expression)expression.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                this.current = expression;
            }
            if (this.current.value instanceof Interval) {
                Interval interval = (Interval)this.current.value;
                this.mincb.setSelected(!interval.infiniteMin);
                this.mincb.apply();
                this.maxcb.setSelected(!interval.infiniteMax);
                this.maxcb.apply();
                switch (interval.type) {
                    case 0: {
                        if (interval.infiniteMin) {
                            this.minValue.setText("");
                        } else {
                            this.minValue.setText("" + interval.dmin);
                        }
                        if (interval.infiniteMax) {
                            this.maxValue.setText("");
                            break;
                        }
                        this.maxValue.setText("" + interval.dmax);
                        break;
                    }
                    case 1: {
                        if (interval.infiniteMin) {
                            this.minValue.setText("");
                        } else {
                            this.minValue.setText("" + interval.lmin);
                        }
                        if (interval.infiniteMax) {
                            this.maxValue.setText("");
                            break;
                        }
                        this.maxValue.setText("" + interval.lmax);
                        break;
                    }
                    case 2: {
                        if (interval.infiniteMin) {
                            this.minValue.setText("");
                        } else {
                            this.minValue.setText(interval.smin);
                        }
                        if (interval.infiniteMax) {
                            this.maxValue.setText("");
                            break;
                        }
                        this.maxValue.setText(interval.smax);
                        break;
                    }
                    case 3: {
                        this.minValue.setText("");
                        this.maxValue.setText("");
                    }
                }
                this.valuePanel.setVisible(false);
                this.intervalPanel.setVisible(true);
                this.minInc.setSelected(interval.boundedMin);
                this.maxInc.setSelected(interval.boundedMax);
            } else {
                this.theValue.setText(this.current.value.toString());
                this.intervalPanel.setVisible(false);
                this.valuePanel.setVisible(true);
            }
            this.setTitle(resources.getString("Editing:") + this.current);
            this.setResizable(true);
            this.pack();
            this.setResizable(false);
        }

        public void addOKListener(ActionListener actionListener) {
            this.ok.addActionListener(actionListener);
        }

        public Expression getExpression() {
            return this.current;
        }
    }

    protected class MapperTableModel
    extends AbstractTableModel {
        final String[] columnNames = new String[]{resources.getString("Expression"), resources.getString("Mapping")};
        protected Object[] mappedValues;
        protected Vector expressions = new Vector();

        public MapperTableModel() {
            Iterator<Object> iterator;
            if (GenericMapper.this.map != null && GenericMapper.this.map.keySet() != null) {
                iterator = GenericMapper.this.map.keySet().iterator();
                while (iterator.hasNext()) {
                    this.expressions.add(new Expression(iterator.next()));
                }
            }
            if (GenericMapper.this.intervals != null) {
                iterator = GenericMapper.this.intervals.iterator();
                while (iterator.hasNext()) {
                    this.expressions.add(new Expression(iterator.next()));
                }
            }
            if (GenericMapper.this.map.values() != null) {
                this.mappedValues = GenericMapper.this.map.values().toArray();
            }
        }

        public void update(int n, int n2) {
            this.expressions = new Vector();
            Iterator<Object> iterator = GenericMapper.this.map.keySet().iterator();
            while (iterator.hasNext()) {
                this.expressions.add(new Expression(iterator.next()));
            }
            iterator = GenericMapper.this.intervals.iterator();
            while (iterator.hasNext()) {
                this.expressions.add(new Expression(iterator.next()));
            }
            this.mappedValues = GenericMapper.this.map.values().toArray();
            this.fireTableRowsUpdated(n, n2);
        }

        public int getColumnCount() {
            return this.columnNames.length;
        }

        public Class getColumnClass(int n) {
            if (n == 0) {
                return class$simtools$ui$GenericMapper$Expression == null ? (class$simtools$ui$GenericMapper$Expression = GenericMapper.class$("simtools.ui.GenericMapper$Expression")) : class$simtools$ui$GenericMapper$Expression;
            }
            return class$java$lang$Object == null ? (class$java$lang$Object = GenericMapper.class$("java.lang.Object")) : class$java$lang$Object;
        }

        public int getRowCount() {
            return this.expressions.size();
        }

        public String getColumnName(int n) {
            return this.columnNames[n];
        }

        public Object getValueAt(int n, int n2) {
            if (n2 == 0) {
                return this.expressions.get(n);
            }
            if (n < this.mappedValues.length) {
                return this.mappedValues[n];
            }
            return ((Interval)GenericMapper.this.intervals.get((int)(n - this.mappedValues.length))).value;
        }

        public boolean isCellEditable(int n, int n2) {
            return n2 == 0;
        }

        public void setValueAt(Object object, int n, int n2) {
            if (n < this.mappedValues.length) {
                if (n2 == 0) {
                    Object object2 = ((Expression)this.expressions.get((int)n)).value;
                    Object object3 = this.mappedValues[n];
                    GenericMapper.this.map.remove(object2);
                    GenericMapper.this.map.put(((Expression)object).value, object3);
                    this.expressions = new Vector();
                    Iterator<Object> iterator = GenericMapper.this.map.keySet().iterator();
                    while (iterator.hasNext()) {
                        this.expressions.add(new Expression(iterator.next()));
                    }
                    iterator = GenericMapper.this.intervals.iterator();
                    while (iterator.hasNext()) {
                        this.expressions.add(new Expression(iterator.next()));
                    }
                    this.mappedValues = GenericMapper.this.map.values().toArray();
                    this.fireTableRowsUpdated(0, this.mappedValues.length - 1);
                    return;
                }
                Object object4 = ((Expression)this.expressions.get((int)n)).value;
                if (!GenericMapper.this.map.containsKey(object4)) {
                    return;
                }
                GenericMapper.this.map.put(object4, object);
                this.mappedValues[n] = object;
                this.fireTableCellUpdated(n, n2);
                return;
            }
            if (n2 == 0) {
                GenericMapper.this.intervals.set(n - this.mappedValues.length, ((Expression)object).value);
                this.expressions.set(n, object);
                this.fireTableRowsUpdated(n, n);
                return;
            }
            Interval interval = (Interval)GenericMapper.this.intervals.get(n - this.mappedValues.length);
            try {
                interval = (Interval)interval.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                // empty catch block
            }
            interval.value = object;
            GenericMapper.this.intervals.set(n - this.mappedValues.length, interval);
        }
    }

    protected static class Expression
    implements Cloneable {
        public Object value;

        public Expression(Object object) {
            this.value = object;
        }

        public String toString() {
            if (this.value instanceof Interval) {
                return ((Interval)this.value).toString();
            }
            return resources.getString("Value=") + this.value;
        }

        public Object clone() throws CloneNotSupportedException {
            return super.clone();
        }
    }

    protected static class ExpressionEditor
    extends DefaultCellEditor {
        protected Expression currentExpression;

        public ExpressionEditor(JButton jButton) {
            super(new JCheckBox());
            this.editorComponent = jButton;
            this.setClickCountToStart(2);
            jButton.addActionListener(new ActionListener(this){
                private final /* synthetic */ ExpressionEditor this$0;
                {
                    this.this$0 = expressionEditor;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    this.this$0.fireEditingStopped();
                }
            });
        }

        protected void fireEditingStopped() {
            super.fireEditingStopped();
        }

        public Object getCellEditorValue() {
            return this.currentExpression;
        }

        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            ((JButton)this.editorComponent).setText(object.toString());
            this.currentExpression = (Expression)object;
            return this.editorComponent;
        }
    }

    protected class ExpressionMappingTable
    extends JTable {
        protected MapperTableModel tableModel;

        public ExpressionMappingTable(Frame frame) {
            this.tableModel = GenericMapper.this.createModel();
            this.setModel(this.tableModel);
            this.setPreferredScrollableViewportSize(new Dimension(300, 200));
            this.getColumnModel().getColumn(0).setPreferredWidth(250);
            this.getColumnModel().getColumn(1).setPreferredWidth(50);
            this.setUpRenderer();
            this.setUpEditor();
            this.setUpExpressionEditor(frame);
            this.getSelectionModel().setSelectionMode(0);
        }

        public void addSelectionListener(ListSelectionListener listSelectionListener) {
            this.getSelectionModel().addListSelectionListener(listSelectionListener);
        }

        protected void setUpRenderer() {
        }

        protected void setUpEditor() {
        }

        protected void setUpExpressionEditor(Frame frame) {
            JButton jButton = new JButton("");
            jButton.setBackground(Color.white);
            jButton.setBorderPainted(false);
            jButton.setMargin(new Insets(0, 0, 0, 0));
            ExpressionEditor expressionEditor = new ExpressionEditor(jButton);
            this.setDefaultEditor(class$simtools$ui$GenericMapper$Expression == null ? (class$simtools$ui$GenericMapper$Expression = GenericMapper.class$("simtools.ui.GenericMapper$Expression")) : class$simtools$ui$GenericMapper$Expression, expressionEditor);
            ExpressionDialog expressionDialog = new ExpressionDialog(frame);
            expressionDialog.addOKListener(new ActionListener(this, expressionEditor, expressionDialog){
                private final /* synthetic */ ExpressionEditor val$expressionEditor;
                private final /* synthetic */ ExpressionDialog val$expressionDialog;
                private final /* synthetic */ ExpressionMappingTable this$1;
                {
                    this.this$1 = expressionMappingTable;
                    this.val$expressionEditor = expressionEditor;
                    this.val$expressionDialog = expressionDialog;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    this.val$expressionEditor.currentExpression = this.val$expressionDialog.getExpression();
                }
            });
            jButton.addActionListener(new ActionListener(this, jButton, expressionEditor, expressionDialog){
                private final /* synthetic */ JButton val$button;
                private final /* synthetic */ ExpressionEditor val$expressionEditor;
                private final /* synthetic */ ExpressionDialog val$expressionDialog;
                private final /* synthetic */ ExpressionMappingTable this$1;
                {
                    this.this$1 = expressionMappingTable;
                    this.val$button = jButton;
                    this.val$expressionEditor = expressionEditor;
                    this.val$expressionDialog = expressionDialog;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    this.val$button.setText(this.val$expressionEditor.currentExpression.toString());
                    this.val$expressionDialog.setLocationRelativeTo(this.val$button);
                    this.val$expressionDialog.edit(this.val$expressionEditor.currentExpression);
                }
            });
        }
    }

    public static class Interval
    implements Cloneable,
    Serializable {
        protected int type;
        protected double dmin;
        protected double dmax;
        protected long lmin;
        protected long lmax;
        protected String smin;
        protected String smax;
        protected boolean boundedMin;
        protected boolean boundedMax;
        protected boolean infiniteMin;
        protected boolean infiniteMax;
        public Object value;

        public Interval(boolean bl, double d, boolean bl2, Object object) {
            this.type = 0;
            this.value = object;
            if (bl) {
                this.dmin = d;
                this.dmax = Double.POSITIVE_INFINITY;
                this.lmin = (long)this.dmin;
                this.lmax = Long.MAX_VALUE;
                this.boundedMin = bl2;
                this.boundedMax = true;
                this.infiniteMax = true;
            } else {
                this.dmin = Double.NEGATIVE_INFINITY;
                this.dmax = d;
                this.lmin = Long.MIN_VALUE;
                this.lmax = (long)this.dmax;
                this.boundedMin = true;
                this.boundedMax = bl2;
                this.infiniteMin = true;
            }
        }

        public Interval(double d, boolean bl, double d2, boolean bl2, Object object) {
            this.type = 0;
            this.dmin = d;
            this.dmax = d2;
            this.lmin = (long)d;
            this.lmax = (long)d2;
            this.boundedMin = bl;
            this.boundedMax = bl2;
            this.value = object;
        }

        public Interval(boolean bl, long l, boolean bl2, Object object) {
            this.type = 1;
            this.value = object;
            if (bl) {
                this.dmin = l;
                this.dmax = Double.POSITIVE_INFINITY;
                this.lmin = l;
                this.lmax = Long.MAX_VALUE;
                this.boundedMin = bl2;
                this.boundedMax = true;
                this.infiniteMax = true;
            } else {
                this.dmin = Double.NEGATIVE_INFINITY;
                this.dmax = l;
                this.lmin = Long.MIN_VALUE;
                this.lmax = l;
                this.boundedMin = true;
                this.boundedMax = bl2;
                this.infiniteMin = true;
            }
        }

        public Interval(long l, boolean bl, long l2, boolean bl2, Object object) {
            this.type = 1;
            this.dmin = l;
            this.dmax = l2;
            this.lmin = l;
            this.lmax = l2;
            this.boundedMin = bl;
            this.boundedMax = bl2;
            this.value = object;
        }

        public Interval(boolean bl, String string, boolean bl2, Object object) {
            this.type = 2;
            this.value = object;
            if (bl) {
                this.smin = string;
                this.smax = null;
                this.boundedMin = bl2;
                this.boundedMax = false;
                this.infiniteMax = true;
            } else {
                this.smin = null;
                this.smax = string;
                this.boundedMin = false;
                this.boundedMax = bl2;
                this.infiniteMin = true;
            }
        }

        public Interval(String string, boolean bl, String string2, boolean bl2, Object object) {
            this.type = 2;
            this.smin = string;
            this.smax = string2;
            this.boundedMin = bl;
            this.boundedMax = bl2;
            this.value = object;
        }

        public Interval(Object object) {
            this.type = 3;
            this.value = object;
            this.infiniteMax = true;
            this.infiniteMin = true;
            this.boundedMin = true;
            this.boundedMax = true;
        }

        public boolean contains(double d) {
            if (this.type == 3) {
                return true;
            }
            if (this.type == 2) {
                return false;
            }
            if (d == this.dmin) {
                return this.boundedMin;
            }
            if (d == this.dmax) {
                return this.boundedMax;
            }
            if (this.infiniteMin && this.infiniteMax) {
                return true;
            }
            if (this.infiniteMin) {
                return d < this.dmax;
            }
            if (this.infiniteMax) {
                return d > this.dmin;
            }
            return d > this.dmin && d < this.dmax;
        }

        public boolean contains(long l) {
            if (this.type == 3) {
                return true;
            }
            if (this.type == 2) {
                return false;
            }
            if (l == this.lmin) {
                return this.boundedMin;
            }
            if (l == this.lmax) {
                return this.boundedMax;
            }
            if (this.infiniteMin && this.infiniteMax) {
                return true;
            }
            if (this.infiniteMin) {
                return l < this.lmax;
            }
            if (this.infiniteMax) {
                return l > this.lmin;
            }
            return l > this.lmin && l < this.lmax;
        }

        public boolean contains(String string) {
            if (this.type == 3) {
                return true;
            }
            if (this.type != 2) {
                return false;
            }
            if (string.compareTo(this.smin) == 0) {
                return this.boundedMin;
            }
            if (string.compareTo(this.smax) == 0) {
                return this.boundedMax;
            }
            if (this.infiniteMin && this.infiniteMax) {
                return true;
            }
            if (this.infiniteMin) {
                return string.compareTo(this.smax) < 0;
            }
            if (this.infiniteMax) {
                return string.compareTo(this.smin) > 0;
            }
            return string.compareTo(this.smin) > 0 && string.compareTo(this.smax) < 0;
        }

        public String toString() {
            if (this.type == 3) {
                return resources.getString("AnyValue");
            }
            String string = "";
            if (!this.infiniteMin) {
                switch (this.type) {
                    case 0: {
                        string = string + this.dmin;
                        break;
                    }
                    case 1: {
                        string = string + this.lmin;
                        break;
                    }
                    case 2: {
                        string = string + this.smin;
                    }
                }
                string = string + " <";
                if (this.boundedMin) {
                    string = string + "=";
                }
                string = string + " ";
            }
            string = string + resources.getString("Value");
            if (!this.infiniteMax) {
                string = string + " <";
                if (this.boundedMax) {
                    string = string + "=";
                }
                string = string + " ";
                switch (this.type) {
                    case 0: {
                        string = string + this.dmax;
                        break;
                    }
                    case 1: {
                        string = string + this.lmax;
                        break;
                    }
                    case 2: {
                        string = string + this.smax;
                    }
                }
            }
            return string;
        }

        public Object clone() throws CloneNotSupportedException {
            return super.clone();
        }
    }
}

