/*
 * Decompiled with CFR 0.152.
 */
package simtools.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.table.TableCellRenderer;
import simtools.data.DataSource;
import simtools.ui.GenericMapper;
import simtools.ui.ResourceFinder;

public class ColorMapper
extends GenericMapper {
    static final long serialVersionUID = 3583538958279328171L;
    public static ResourceBundle resources = ResourceFinder.get(class$simtools$ui$ColorMapper == null ? (class$simtools$ui$ColorMapper = ColorMapper.class$("simtools.ui.ColorMapper")) : class$simtools$ui$ColorMapper);
    public static final int COLOR_CYCLE = 6;
    public static final int SATURATION_CYCLE = 2;
    public static final int BRIGHTNESS_CYCLE = 3;
    protected static int defaultColorIndex = 0;
    static /* synthetic */ Class class$simtools$ui$ColorMapper;
    static /* synthetic */ Class class$java$awt$Color;

    public ColorMapper() {
    }

    public ColorMapper(String string) {
        super(string);
    }

    public Paint getPaint(DataSource dataSource, long l) {
        return (Paint)this.getMapping(dataSource, l);
    }

    public void setDefaultPaint(Paint paint) {
        super.setDefaultValue(paint);
    }

    public Paint getDefaultPaint() {
        return (Paint)super.getDefaultValue();
    }

    public Paint getPaint(DataSource dataSource) {
        return (Paint)this.getMapping(dataSource);
    }

    public Paint getPaint(Object object) {
        return (Paint)this.getMapping(object);
    }

    public void setPaint(Object object, Paint paint) {
        this.setMapping(object, paint);
    }

    public void setPaint(double d, double d2, Paint paint) {
        this.setMapping(d, true, d2, true, (Object)paint);
    }

    public void setPaint(double d, boolean bl, double d2, boolean bl2, Paint paint) {
        this.setMapping(d, bl, d2, bl2, (Object)paint);
    }

    public void setPaint(boolean bl, double d, Paint paint) {
        this.setMapping(bl, d, true, (Object)paint);
    }

    public void setPaint(boolean bl, double d, boolean bl2, Paint paint) {
        this.setMapping(bl, d, bl2, (Object)paint);
    }

    public void setPaint(long l, long l2, Paint paint) {
        this.setMapping(l, true, l2, true, (Object)paint);
    }

    public void setPaint(long l, boolean bl, long l2, boolean bl2, Paint paint) {
        this.setMapping(l, bl, l2, bl2, (Object)paint);
    }

    public void setPaint(boolean bl, long l, Paint paint) {
        this.setMapping(bl, l, true, (Object)paint);
    }

    public void setPaint(boolean bl, long l, boolean bl2, Paint paint) {
        this.setMapping(bl, l, bl2, (Object)paint);
    }

    public void setPaint(String string, String string2, Paint paint) {
        this.setMapping(string, true, string2, true, (Object)paint);
    }

    public void setPaint(String string, boolean bl, String string2, boolean bl2, Paint paint) {
        this.setMapping(string, bl, string2, bl2, (Object)paint);
    }

    public void setPaint(boolean bl, String string, Paint paint) {
        this.setMapping(bl, string, true, (Object)paint);
    }

    public void setPaint(boolean bl, String string, boolean bl2, Paint paint) {
        this.setMapping(bl, string, bl2, (Object)paint);
    }

    public GenericMapper.MapperTableModel createModel() {
        return new ColorMapperTableModel();
    }

    protected GenericMapper.ExpressionMappingTable createTable(Frame frame) {
        return new ColorMappingTable(frame);
    }

    protected Object createNewValue() {
        float f = 1.0f - (float)(defaultColorIndex / 6 % 2) * 1.0f / 2.0f;
        float f2 = 1.0f - 0.5f * ((float)(defaultColorIndex / 12 % 3) * 1.0f / 3.0f);
        float f3 = 0.6666667f + (float)defaultColorIndex / 6.0f + (1.0f - f) * (1.0f - f2);
        ++defaultColorIndex;
        return Color.getHSBColor(f3, f, f2);
    }

    public static ColorMapper createColorMapperDialog(Frame frame) {
        ColorMapper colorMapper = new ColorMapper();
        colorMapper.editDialog(frame);
        return colorMapper;
    }

    public static void main(String[] stringArray) {
        ColorMapper colorMapper = new ColorMapper();
        colorMapper.setMapping(new Long(3L), Color.red);
        colorMapper.setMapping(new Long(4L), Color.blue);
        colorMapper.setMapping(5L, 10L, (Object)Color.magenta);
        colorMapper.setMapping(8L, 20L, (Object)Color.green);
        colorMapper.setMapping(-18L, 7L, (Object)Color.black);
        colorMapper.editDialog(null);
        System.exit(0);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected class ColorMapperTableModel
    extends GenericMapper.MapperTableModel {
        protected ColorMapperTableModel() {
            super(ColorMapper.this);
        }

        public Class getColumnClass(int n) {
            if (n == 1) {
                return class$java$awt$Color == null ? (class$java$awt$Color = ColorMapper.class$("java.awt.Color")) : class$java$awt$Color;
            }
            return super.getColumnClass(n);
        }

        public String getColumnName(int n) {
            if (n == 1) {
                return resources.getString("Color");
            }
            return super.getColumnName(n);
        }

        public boolean isCellEditable(int n, int n2) {
            if (n2 == 1) {
                return true;
            }
            return super.isCellEditable(n, n2);
        }
    }

    protected class ColorMappingTable
    extends GenericMapper.ExpressionMappingTable {
        public ColorMappingTable(Frame frame) {
            super(ColorMapper.this, frame);
        }

        protected void setUpRenderer() {
            this.setDefaultRenderer(class$java$awt$Color == null ? (class$java$awt$Color = ColorMapper.class$("java.awt.Color")) : class$java$awt$Color, new ColorRenderer(true));
        }

        protected void setUpEditor() {
            JButton jButton = new JButton(this, ""){
                private final /* synthetic */ ColorMappingTable this$1;
                {
                    this.this$1 = colorMappingTable;
                }

                public void setText(String string) {
                }
            };
            jButton.setBackground(Color.white);
            jButton.setBorderPainted(false);
            jButton.setMargin(new Insets(0, 0, 0, 0));
            ColorEditor colorEditor = new ColorEditor(jButton);
            this.setDefaultEditor(class$java$awt$Color == null ? (class$java$awt$Color = ColorMapper.class$("java.awt.Color")) : class$java$awt$Color, colorEditor);
            JColorChooser jColorChooser = new JColorChooser();
            ActionListener actionListener = new ActionListener(this, colorEditor, jColorChooser){
                private final /* synthetic */ ColorEditor val$colorEditor;
                private final /* synthetic */ JColorChooser val$colorChooser;
                private final /* synthetic */ ColorMappingTable this$1;
                {
                    this.this$1 = colorMappingTable;
                    this.val$colorEditor = colorEditor;
                    this.val$colorChooser = jColorChooser;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    this.val$colorEditor.currentColor = this.val$colorChooser.getColor();
                }
            };
            JDialog jDialog = JColorChooser.createDialog(jButton, resources.getString("PickAColor"), true, jColorChooser, actionListener, null);
            jButton.addActionListener(new ActionListener(this, jButton, colorEditor, jColorChooser, jDialog){
                private final /* synthetic */ JButton val$button;
                private final /* synthetic */ ColorEditor val$colorEditor;
                private final /* synthetic */ JColorChooser val$colorChooser;
                private final /* synthetic */ JDialog val$dialog;
                private final /* synthetic */ ColorMappingTable this$1;
                {
                    this.this$1 = colorMappingTable;
                    this.val$button = jButton;
                    this.val$colorEditor = colorEditor;
                    this.val$colorChooser = jColorChooser;
                    this.val$dialog = jDialog;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    this.val$button.setBackground(this.val$colorEditor.currentColor);
                    this.val$colorChooser.setColor(this.val$colorEditor.currentColor);
                    this.val$dialog.setLocationRelativeTo(this.val$button);
                    this.val$dialog.show();
                }
            });
        }
    }

    protected static class ColorRenderer
    extends JLabel
    implements TableCellRenderer {
        Border unselectedBorder = null;
        Border selectedBorder = null;
        boolean isBordered = true;

        public ColorRenderer(boolean bl) {
            this.isBordered = bl;
            this.setOpaque(true);
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            this.setBackground((Color)object);
            if (this.isBordered) {
                if (bl) {
                    if (this.selectedBorder == null) {
                        this.selectedBorder = BorderFactory.createMatteBorder(2, 5, 2, 5, jTable.getSelectionBackground());
                    }
                    this.setBorder(this.selectedBorder);
                } else {
                    if (this.unselectedBorder == null) {
                        this.unselectedBorder = BorderFactory.createMatteBorder(2, 5, 2, 5, jTable.getBackground());
                    }
                    this.setBorder(this.unselectedBorder);
                }
            }
            return this;
        }
    }

    protected static class ColorEditor
    extends DefaultCellEditor {
        Color currentColor = null;

        public ColorEditor(JButton jButton) {
            super(new JCheckBox());
            this.editorComponent = jButton;
            this.setClickCountToStart(2);
            jButton.addActionListener(new ActionListener(this){
                private final /* synthetic */ ColorEditor this$0;
                {
                    this.this$0 = colorEditor;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    this.this$0.fireEditingStopped();
                }
            });
        }

        protected void fireEditingStopped() {
            super.fireEditingStopped();
        }

        public Object getCellEditorValue() {
            return this.currentColor;
        }

        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            ((JButton)this.editorComponent).setText(object.toString());
            this.currentColor = (Color)object;
            return this.editorComponent;
        }
    }
}

