/*
 * Decompiled with CFR 0.152.
 */
package simtools.shapes;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import java.awt.print.PageFormat;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;
import simtools.diagram.DiagramClipboard;
import simtools.diagram.DiagramComponent;
import simtools.diagram.DiagramConnection;
import simtools.diagram.DiagramConnector;
import simtools.diagram.DiagramParameters;
import simtools.diagram.DiagramSelectedShape;
import simtools.diagram.DiagramSelection;
import simtools.shapes.AbstractShape;
import simtools.shapes.CompoundShape;
import simtools.shapes.ShapeListener;

public class ShapesContainer
extends Vector
implements Serializable {
    static final long serialVersionUID = 4552602745191436089L;
    protected DiagramParameters _diagParam = new DiagramParameters();
    protected static Font _sFont = new Font("TimesRoman", 0, 10);
    protected transient ShapesComponent _comp;
    protected Vector _oldCompounds;

    private void initComponent() {
        this._comp = this.createShapesComponent(this._diagParam);
        this._comp.createSelection();
        this._comp.getDiagramSelection().setShapes(this);
    }

    public ShapesContainer(String string) {
        this._diagParam.name = string;
        this._oldCompounds = new Vector();
        this.initComponent();
    }

    protected ShapesComponent createShapesComponent(DiagramParameters diagramParameters) {
        return new ShapesComponent(diagramParameters);
    }

    public ShapesComponent getComponent() {
        return this._comp;
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
        this.initComponent();
    }

    public synchronized boolean add(Object object) {
        if (object instanceof AbstractShape) {
            ((AbstractShape)object).addListener(this._comp);
        }
        return super.add(object);
    }

    public void add(int n, Object object) {
        if (object instanceof AbstractShape) {
            ((AbstractShape)object).addListener(this._comp);
        }
        super.add(n, object);
    }

    public synchronized boolean addAll(Collection collection) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!(e instanceof AbstractShape)) continue;
            ((AbstractShape)e).addListener(this._comp);
        }
        return super.addAll(collection);
    }

    public synchronized boolean addAll(int n, Collection collection) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!(e instanceof AbstractShape)) continue;
            ((AbstractShape)e).addListener(this._comp);
        }
        return super.addAll(n, collection);
    }

    public synchronized void addElement(Object object) {
        if (object instanceof AbstractShape) {
            ((AbstractShape)object).addListener(this._comp);
        }
        super.addElement(object);
    }

    public void clear() {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!(e instanceof AbstractShape)) continue;
            ((AbstractShape)e).removeListener(this._comp);
        }
        super.clear();
    }

    public synchronized void insertElementAt(Object object, int n) {
        if (object instanceof AbstractShape) {
            ((AbstractShape)object).addListener(this._comp);
        }
        super.insertElementAt(object, n);
    }

    public synchronized Object remove(int n) {
        Object e = this.get(n);
        if (e instanceof AbstractShape) {
            ((AbstractShape)e).removeListener(this._comp);
        }
        return super.remove(n);
    }

    public boolean remove(Object object) {
        if (object instanceof AbstractShape) {
            ((AbstractShape)object).removeListener(this._comp);
        }
        return super.remove(object);
    }

    public synchronized boolean removeAll(Collection collection) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!(e instanceof AbstractShape)) continue;
            ((AbstractShape)e).removeListener(this._comp);
        }
        return super.removeAll(collection);
    }

    public synchronized void removeAllElements() {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!(e instanceof AbstractShape)) continue;
            ((AbstractShape)e).removeListener(this._comp);
        }
        super.removeAllElements();
    }

    public synchronized boolean removeElement(Object object) {
        if (object instanceof AbstractShape) {
            ((AbstractShape)object).removeListener(this._comp);
        }
        return super.removeElement(object);
    }

    public synchronized void removeElementAt(int n) {
        Object e = this.get(n);
        if (e instanceof AbstractShape) {
            ((AbstractShape)e).removeListener(this._comp);
        }
        super.removeElementAt(n);
    }

    protected void removeRange(int n, int n2) {
        for (int i = n; i <= n2; ++i) {
            Object e = this.get(i);
            if (!(e instanceof AbstractShape)) continue;
            ((AbstractShape)e).removeListener(this._comp);
        }
        super.removeRange(n, n2);
    }

    public synchronized Object set(int n, Object object) {
        Object e = this.get(n);
        if (e instanceof AbstractShape) {
            ((AbstractShape)e).removeListener(this._comp);
        }
        if (object instanceof AbstractShape) {
            ((AbstractShape)object).addListener(this._comp);
        }
        return super.set(n, object);
    }

    public synchronized void setElementAt(Object object, int n) {
        Object e = this.get(n);
        if (e instanceof AbstractShape) {
            ((AbstractShape)e).removeListener(this._comp);
        }
        if (object instanceof AbstractShape) {
            ((AbstractShape)object).addListener(this._comp);
        }
        super.setElementAt(object, n);
    }

    public class GraphicSelection
    extends DiagramSelection {
        GraphicSelection() {
        }

        public Point getShapeOrigin(Shape shape, Point point) {
            Point point2;
            Point point3 = point2 = point == null ? new Point() : point;
            if (shape instanceof AbstractShape) {
                AbstractShape abstractShape = (AbstractShape)shape;
                point2.x = abstractShape._ox;
                point2.y = abstractShape._oy;
                return point2;
            }
            return super.getShapeOrigin(shape, point2);
        }

        public Shape copyShape(Shape shape) {
            if (shape instanceof AbstractShape) {
                AbstractShape abstractShape = ((AbstractShape)shape).cloneShape();
                return abstractShape;
            }
            return null;
        }

        public void translateShape(Shape shape, int n, int n2) {
            if (shape instanceof AbstractShape) {
                AbstractShape abstractShape = (AbstractShape)shape;
                abstractShape.translate(n, n2);
            }
        }

        protected boolean addShapeAt(int n, int n2) {
            boolean bl = false;
            for (int i = ShapesContainer.this.size() - 1; i >= 0; --i) {
                Shape shape = (Shape)ShapesContainer.this.elementAt(i);
                if (!shape.contains(n, n2)) continue;
                super.add(new DiagramSelectedShape(shape, this.getShapeOrigin(shape, null)));
                bl = true;
                break;
            }
            return bl;
        }

        protected void setToShape(AbstractShape abstractShape) {
            super.clear();
            this.selectAreaEnd();
            this.width = -1;
            super.add(new DiagramSelectedShape(abstractShape, this.getShapeOrigin(abstractShape, null)));
            this.propagate();
        }

        protected void addShapes(Vector vector) {
            for (int i = 0; i < vector.size(); ++i) {
                AbstractShape abstractShape = (AbstractShape)vector.elementAt(i);
                super.add(new DiagramSelectedShape(abstractShape, this.getShapeOrigin(abstractShape, null)));
            }
            this.propagate();
        }

        protected void replaceShapes(Vector vector, AbstractShape abstractShape) {
            int n;
            for (int i = n = this.getShapeCount() - 1; i >= 0; --i) {
                Shape shape = this.getShape(i);
                if (!vector.contains(shape)) continue;
                this.removeShapeAt(i);
            }
            super.add(new DiagramSelectedShape(abstractShape, this.getShapeOrigin(abstractShape, null)));
            this.propagate();
        }
    }

    public class ShapesComponent
    extends DiagramComponent
    implements ShapeListener {
        public ShapesComponent(DiagramParameters diagramParameters) {
            super(diagramParameters);
        }

        public ShapesContainer getContainer() {
            return ShapesContainer.this;
        }

        public void createSelection() {
            this._selection = new GraphicSelection();
            this._selection.setGrid(this._param.grid);
        }

        public boolean canGroup() {
            return this._selection.getShapeCount() > 1;
        }

        public boolean canUnGroup() {
            for (int i = 0; i < this._selection.getShapeCount(); ++i) {
                AbstractShape abstractShape = (AbstractShape)this._selection.getShape(i);
                if (!(abstractShape instanceof CompoundShape)) continue;
                return true;
            }
            return false;
        }

        public boolean canReGroup() {
            for (int i = 0; i < ShapesContainer.this._oldCompounds.size(); ++i) {
                CompoundShape compoundShape = (CompoundShape)ShapesContainer.this._oldCompounds.elementAt(i);
                for (int j = 0; j < this._selection.getShapeCount(); ++j) {
                    if (!compoundShape.contains((AbstractShape)this._selection.getShape(j))) continue;
                    return true;
                }
            }
            return false;
        }

        public void group() {
            CompoundShape compoundShape;
            if (this._selection.getShapeCount() < 2) {
                return;
            }
            Iterator iterator = ShapesContainer.this._oldCompounds.iterator();
            while (iterator.hasNext()) {
                compoundShape = (CompoundShape)iterator.next();
                compoundShape.retainShapes(ShapesContainer.this);
                if (compoundShape.size() != 0) continue;
                iterator.remove();
            }
            compoundShape = new CompoundShape();
            for (int i = 0; i < this._selection.getShapeCount(); ++i) {
                AbstractShape abstractShape = (AbstractShape)this._selection.getShape(i);
                iterator = ShapesContainer.this._oldCompounds.iterator();
                while (iterator.hasNext()) {
                    CompoundShape compoundShape2 = (CompoundShape)iterator.next();
                    if (!compoundShape2.contains(abstractShape)) continue;
                    compoundShape2.removeShape(abstractShape);
                    if (compoundShape2.size() != 0) continue;
                    iterator.remove();
                }
                compoundShape.addShape(abstractShape);
                ShapesContainer.this.removeElement(abstractShape);
            }
            ShapesContainer.this.addElement(compoundShape);
            ((GraphicSelection)this._selection).setToShape(compoundShape);
            this.repaint();
        }

        public void unGroup() {
            Vector<AbstractShape> vector = new Vector<AbstractShape>();
            for (int i = 0; i < this._selection.getShapeCount(); ++i) {
                AbstractShape abstractShape = (AbstractShape)this._selection.getShape(i);
                if (!(abstractShape instanceof CompoundShape)) continue;
                CompoundShape compoundShape = (CompoundShape)abstractShape;
                for (int j = 0; j < compoundShape.size(); ++j) {
                    vector.add(compoundShape.getShape(j));
                }
                ShapesContainer.this._oldCompounds.add(compoundShape);
                ShapesContainer.this.removeElement(abstractShape);
            }
            ShapesContainer.this.addAll(vector);
            ((GraphicSelection)this._selection).addShapes(vector);
            this.repaint();
        }

        public void reGroup() {
            Iterator iterator = ShapesContainer.this._oldCompounds.iterator();
            block0: while (iterator.hasNext()) {
                CompoundShape compoundShape = (CompoundShape)iterator.next();
                compoundShape.retainShapes(ShapesContainer.this);
                if (compoundShape.size() == 0) {
                    iterator.remove();
                    continue;
                }
                for (int i = 0; i < this._selection.getShapeCount(); ++i) {
                    AbstractShape abstractShape = (AbstractShape)this._selection.getShape(i);
                    if (!compoundShape.contains(abstractShape)) continue;
                    Vector<AbstractShape> vector = new Vector<AbstractShape>();
                    for (int j = 0; j < compoundShape.size(); ++j) {
                        vector.add(compoundShape.getShape(j));
                    }
                    ((GraphicSelection)this._selection).replaceShapes(vector, compoundShape);
                    ShapesContainer.this.removeAll(vector);
                    compoundShape.computeBounds();
                    compoundShape.synchroSizes();
                    ShapesContainer.this.add(compoundShape);
                    iterator.remove();
                    continue block0;
                }
            }
            this.repaint();
        }

        protected void translate(int n, int n2) {
            for (int i = 0; i < ShapesContainer.this.size(); ++i) {
                AbstractShape abstractShape = (AbstractShape)ShapesContainer.this.elementAt(i);
                abstractShape.translate(n, n2);
            }
        }

        protected void getMin(Point point) {
            for (int i = 0; i < ShapesContainer.this.size(); ++i) {
                AbstractShape abstractShape = (AbstractShape)ShapesContainer.this.elementAt(i);
                abstractShape.getMin(point);
            }
        }

        protected void copyAt(Vector vector, int n, int n2) {
            for (int i = 0; i < vector.size(); ++i) {
                Object e = vector.elementAt(i);
                if (!(e instanceof AbstractShape)) continue;
                AbstractShape abstractShape = ((AbstractShape)e).cloneShape();
                abstractShape.setAnchor(n, n2);
                ShapesContainer.this.addElement(abstractShape);
            }
        }

        protected void drawDiagramElements(Graphics2D graphics2D, Point point) {
            graphics2D.setFont(_sFont);
            graphics2D.setColor(Color.black);
            graphics2D.setBackground(DiagramParameters.DEFAULT_COLOR);
            graphics2D.setStroke(new BasicStroke(1.0f));
            for (int i = 0; i < ShapesContainer.this.size(); ++i) {
                AbstractShape abstractShape = (AbstractShape)ShapesContainer.this.elementAt(i);
                boolean bl = this._selection.isSelected(abstractShape);
                if (bl) {
                    abstractShape.draw(graphics2D);
                    this.drawBounds(graphics2D, abstractShape);
                } else {
                    abstractShape.draw(graphics2D);
                }
                abstractShape.getMax(point);
            }
        }

        protected void drawBounds(Graphics2D graphics2D, AbstractShape abstractShape) {
            int n;
            Rectangle2D rectangle2D = abstractShape.getBounds2D();
            int n2 = (int)rectangle2D.getX();
            int n3 = (int)rectangle2D.getY();
            int n4 = (int)rectangle2D.getWidth();
            int n5 = (int)rectangle2D.getHeight();
            graphics2D.drawRect(n2, n3, n4 - 1, n5 - 1);
            graphics2D.fillRect(n2, n3, 5, 5);
            int n6 = n = n2 + n4 - 5;
            graphics2D.fillRect(n6, n3, 5, 5);
            int n7 = n3 + n5 - 5;
            graphics2D.fillRect(n6, n7, 5, 5);
            graphics2D.fillRect(n2, n7, 5, 5);
            n6 = n2 + n4 / 2 - 2;
            graphics2D.fillRect(n6, n3, 5, 5);
            graphics2D.fillRect(n6, n7, 5, 5);
            n7 = n3 + n5 / 2 - 2;
            graphics2D.fillRect(n2, n7, 5, 5);
            graphics2D.fillRect(n, n7, 5, 5);
        }

        protected void drawClipboardElements(Graphics2D graphics2D, Point point) {
            int n = this._dragPoint.x;
            int n2 = this._dragPoint.y;
            DiagramClipboard diagramClipboard = DiagramClipboard.get();
            graphics2D.setColor(Color.green);
            for (int i = 0; i < diagramClipboard.size(); ++i) {
                Object e = diagramClipboard.elementAt(i);
                if (!(e instanceof AbstractShape)) continue;
                AbstractShape abstractShape = (AbstractShape)e;
                abstractShape.setAnchor(n, n2);
                abstractShape.draw(graphics2D);
                abstractShape.getMax(point);
            }
        }

        protected void printDiagramElements(Graphics2D graphics2D, Point point) {
            AbstractShape abstractShape;
            int n;
            graphics2D.setFont(_sFont);
            graphics2D.setColor(Color.black);
            boolean bl = false;
            if (this._printSelectionOnly) {
                for (n = 0; n < ShapesContainer.this.size(); ++n) {
                    abstractShape = (AbstractShape)ShapesContainer.this.elementAt(n);
                    if (!this._selection.isSelected(abstractShape)) continue;
                    abstractShape.draw(graphics2D);
                    abstractShape.getMax(point);
                    bl = true;
                }
            }
            if (!bl) {
                for (n = 0; n < ShapesContainer.this.size(); ++n) {
                    abstractShape = (AbstractShape)ShapesContainer.this.elementAt(n);
                    abstractShape.draw(graphics2D);
                    abstractShape.getMax(point);
                }
            }
        }

        protected double computePrintScaleFactor(PageFormat pageFormat) {
            if (!this._printSelectionOnly) {
                return super.computePrintScaleFactor(pageFormat);
            }
            Point point = new Point();
            boolean bl = false;
            for (int i = 0; i < ShapesContainer.this.size(); ++i) {
                AbstractShape abstractShape = (AbstractShape)ShapesContainer.this.elementAt(i);
                if (!this._selection.isSelected(abstractShape)) continue;
                abstractShape.getMax(point);
                bl = true;
            }
            if (!bl) {
                return super.computePrintScaleFactor(pageFormat);
            }
            double d = pageFormat.getImageableWidth() / (double)point.x;
            double d2 = point.y;
            if (this.hasHeader()) {
                d2 += (double)this._param.headerHeight;
            }
            double d3 = pageFormat.getImageableHeight() / d2;
            double d4 = Math.min(d, d3);
            return d4;
        }

        protected void drawConnection(Graphics2D graphics2D, Point point) {
            throw new UnsupportedOperationException();
        }

        protected DiagramConnection createConnection(DiagramConnector diagramConnector, int n, int n2) {
            throw new UnsupportedOperationException();
        }

        protected void translateConnection(DiagramConnection diagramConnection, int n, int n2) {
            throw new UnsupportedOperationException();
        }

        protected void performConnection(DiagramConnection diagramConnection, DiagramConnector diagramConnector, DiagramConnector diagramConnector2) {
            throw new UnsupportedOperationException();
        }

        public void shapeChanged(AbstractShape abstractShape, Rectangle rectangle) {
            this.repaint(rectangle);
        }
    }
}

