/*
 * Decompiled with CFR 0.152.
 */
package simtools.diagram;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsDevice;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPopupMenu;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.Scrollable;
import simtools.diagram.DiagramAction;
import simtools.diagram.DiagramClipboard;
import simtools.diagram.DiagramConnection;
import simtools.diagram.DiagramConnector;
import simtools.diagram.DiagramParameters;
import simtools.diagram.DiagramSelection;

public abstract class DiagramComponent
extends JComponent
implements Scrollable,
Printable,
MouseListener,
MouseMotionListener,
ActionListener {
    private static Cursor[] _cursors = new Cursor[]{Cursor.getPredefinedCursor(13), Cursor.getPredefinedCursor(8), Cursor.getPredefinedCursor(7), Cursor.getPredefinedCursor(11), Cursor.getPredefinedCursor(5), Cursor.getPredefinedCursor(9), Cursor.getPredefinedCursor(4), Cursor.getPredefinedCursor(10), Cursor.getPredefinedCursor(6)};
    protected static BasicStroke _dashStroke;
    protected static BasicStroke _defaultStroke;
    protected static Color _gridColor;
    protected static Color _selectionColor;
    protected static Color _defaultColor;
    protected Dimension _size;
    protected Rectangle _autoScrollRect;
    private int _selX = 0;
    private int _selY = 0;
    private int _moveX = 0;
    private int _moveY = 0;
    protected boolean _dragging;
    protected Point _dragPoint;
    protected boolean _linking;
    protected boolean _translating;
    protected int _resizeWay;
    protected DiagramConnection _connection;
    protected DiagramConnector _inputConnector;
    protected DiagramConnector _outputConnector;
    protected DiagramSelection _selection;
    protected boolean _printSelectionOnly;
    protected DiagramParameters _param;
    protected DiagramAction _action;
    protected JPopupMenu _popup;
    protected String _headerTitle;
    protected boolean autofit = true;
    protected boolean fullScreen;
    protected GraphicsDevice fullScreenDevice;
    protected JFrame fullScreenFrame;
    protected Container windowedModeParent;

    public DiagramComponent(DiagramParameters diagramParameters) {
        this._param = diagramParameters;
        if (this._param.backgr != null) {
            this.setOpaque(true);
        }
        this._selX = 0;
        this._selY = 0;
        this._moveX = 0;
        this._moveY = 0;
        this._dragging = false;
        this._dragPoint = new Point();
        this._linking = false;
        this._resizeWay = 0;
        this._translating = false;
        this._connection = null;
        this._inputConnector = null;
        this._outputConnector = null;
        this._printSelectionOnly = false;
        this.createSelection();
        this._size = new Dimension(this._param.width, this._param.height);
        this._autoScrollRect = new Rectangle(0, 0, 32, 32);
        this.registerActions();
        this._popup = null;
        this._action = null;
        this._headerTitle = null;
        this.autofit = true;
        this.setDiagramSize(this._param.width, this._param.height);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    public DiagramParameters getParameters() {
        return this._param;
    }

    public void setPopupMenu(JPopupMenu jPopupMenu) {
        this._popup = jPopupMenu;
    }

    public JPopupMenu getPopupMenu() {
        return this._popup;
    }

    public void setAction(DiagramAction diagramAction) {
        this._action = diagramAction;
    }

    public DiagramAction getAction() {
        return this._action;
    }

    public void createSelection() {
        this._selection = new DiagramSelection();
        this._selection.setGrid(this._param.grid);
    }

    public String getName() {
        return this._param.name;
    }

    public void setName(String string) {
        this._param.name = string;
    }

    public String toString() {
        return this._param.name;
    }

    public boolean isAutofit() {
        return this.autofit;
    }

    public void setAutofit(boolean bl) {
        this.autofit = bl;
    }

    public int getXMargin() {
        return this._param.xmargin;
    }

    public int getYMargin() {
        return this._param.ymargin;
    }

    public void setMargin(int n, int n2) {
        this._param.xmargin = n;
        this._param.ymargin = n2;
    }

    public int getHeaderHeight() {
        return this._param.headerHeight;
    }

    public void setHeaderHeight(int n) {
        this._param.headerHeight = n;
    }

    public void setDiagramSize(int n, int n2) {
        this._param.width = Math.max(this._param.minimumWidth, n);
        this._param.height = Math.max(this._param.minimumHeight, n2);
        this._size.width = (int)(this._param.scale * (double)this._param.width);
        this._size.height = (int)(this._param.scale * (double)this._param.height);
        this.setPreferredSize(this._size);
        this.setSize(this._size);
    }

    public int getDiagramWidth() {
        return this._param.width;
    }

    public int getDiagramHeight() {
        return this._param.height;
    }

    public void setGrid(int n) {
        this._param.grid = n < 0 ? 0 : n;
        this._selection.setGrid(this._param.grid);
        this.setDiagramSize(this._param.width, this._param.height);
        this.repaint();
    }

    public void setGridDisplay(boolean bl) {
        if (this._param.gridDisplay != bl) {
            this.setDiagramSize(this._param.width, this._param.height);
            this.repaint();
        }
        this._param.gridDisplay = bl;
    }

    public int getGrid() {
        return this._param.grid;
    }

    public boolean getGridDisplay() {
        return this._param.gridDisplay;
    }

    public void setZoom(double d) {
        this._param.scale = d <= 0.0 ? 1.0 : d;
        this.setDiagramSize(this._param.width, this._param.height);
        this.repaint();
    }

    public double getZoom() {
        return this._param.scale;
    }

    public void adjust() {
        Point point = new Point(0, 0);
        this.getMin(point);
        if (point.x != 0 || point.y != 0) {
            this._selection.unselect();
            if (this._param.grid > 0) {
                point.x = (point.x / this._param.grid - 1) * this._param.grid;
                point.y = (point.y / this._param.grid - 1) * this._param.grid;
            }
            this.translate(-point.x, -point.y);
            this.repaint();
        }
    }

    public void align() {
        this._selection.alignSelection();
        this.repaint();
    }

    public void paint(Graphics graphics) {
        int n;
        int n2;
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.scale(this._param.scale, this._param.scale);
        if (this._param.backgr != null) {
            graphics2D.setColor(this._param.backgr);
            graphics2D.fillRect(0, 0, this._param.width, this._param.height);
            if (!this.autofit) {
                if (this.fullScreen) {
                    n2 = this.fullScreenFrame.getWidth();
                    n = this.fullScreenFrame.getHeight();
                } else if (this.getParent() instanceof JViewport) {
                    n2 = ((JViewport)this.getParent()).getWidth();
                    n = ((JViewport)this.getParent()).getHeight();
                } else {
                    n2 = this._param.width;
                    n = this._param.height;
                }
                if (n2 > this._param.width || n > this._param.height) {
                    graphics2D.setColor(this.getBackground());
                    graphics2D.fillRect(0, this._param.height, n2, n - this._param.height);
                    graphics2D.fillRect(this._param.width, 0, n2 - this._param.width, n);
                }
            }
        }
        if ((n2 = this.getGrid()) > 0 && this._param.gridDisplay) {
            int n3;
            graphics2D.translate(this._param.xmargin, this._param.ymargin);
            n = this._param.width - 2 * this._param.xmargin;
            int n4 = this._param.height - 2 * this._param.ymargin;
            int n5 = n / n2;
            int n6 = n4 / n2;
            graphics2D.setColor(_gridColor);
            for (n3 = 0; n3 <= n5; ++n3) {
                graphics2D.fillRect(n3 * n2, 0, 1, n4);
            }
            for (n3 = 0; n3 <= n6; ++n3) {
                graphics2D.fillRect(0, n3 * n2, n, 1);
            }
            graphics2D.translate(-this._param.xmargin, -this._param.ymargin);
        }
        this.drawDiagram(graphics2D);
    }

    public void repaint(Rectangle rectangle) {
        this.repaint(rectangle, true);
    }

    public void repaint(Rectangle rectangle, boolean bl) {
        if (bl) {
            rectangle.setBounds((int)((double)rectangle.x * this._param.scale + (double)this._param.xmargin), (int)((double)rectangle.y * this._param.scale + (double)this._param.ymargin), (int)((double)rectangle.width * this._param.scale), (int)((double)rectangle.height * this._param.scale));
        }
        super.repaint(rectangle);
    }

    protected void drawDiagram(Graphics2D graphics2D) {
        Point point = new Point();
        graphics2D.translate(this._param.xmargin, this._param.ymargin);
        this.drawDiagramElements(graphics2D, point);
        if (this._dragging) {
            this.drawClipboardElements(graphics2D, point);
        }
        if (this._linking) {
            this.drawConnection(graphics2D, point);
        }
        if (this._selection.width >= 0) {
            graphics2D.setColor(_selectionColor);
            graphics2D.setStroke(_dashStroke);
            graphics2D.draw(this._selection);
            if (this._selection.x + this._selection.width > point.x) {
                point.x = this._selection.x + this._selection.width;
            }
            if (this._selection.y + this._selection.height > point.y) {
                point.y = this._selection.y + this._selection.height;
            }
        }
        graphics2D.setStroke(_defaultStroke);
        graphics2D.translate(-this._param.xmargin, -this._param.ymargin);
        point.x += 2 * this._param.xmargin;
        point.y += 2 * this._param.ymargin;
        if (this.fullScreen) {
            this.setDiagramSize((int)((double)this.fullScreenFrame.getWidth() / this._param.scale + 0.5), (int)((double)this.fullScreenFrame.getHeight() / this._param.scale + 0.5));
        } else if (this.autofit && this.getParent() instanceof JViewport) {
            int n = Math.max((int)((double)point.x * this._param.scale), ((JViewport)this.getParent()).getWidth());
            int n2 = Math.max((int)((double)point.y * this._param.scale), ((JViewport)this.getParent()).getHeight());
            this.setDiagramSize((int)((double)n / this._param.scale + 0.5), (int)((double)n2 / this._param.scale + 0.5));
        } else if (point.y != this._param.height || point.x != this._param.width) {
            this.setDiagramSize(point.x, point.y);
        }
    }

    protected void drawHeader(Graphics2D graphics2D) {
        if (this.hasHeader()) {
            graphics2D.setColor(_defaultColor);
            graphics2D.draw(new Rectangle(1, this._param.height + 1, this._param.width - 2, this._param.headerHeight - 2));
            graphics2D.drawString(this._headerTitle, this._param.headerHeight / 8, this._param.height + 3 * this._param.headerHeight / 8);
        }
    }

    public void printDiagram(Graphics2D graphics2D) {
        Point point = new Point();
        graphics2D.translate(this._param.xmargin, this._param.ymargin);
        this.printDiagramElements(graphics2D, point);
        this.drawHeader(graphics2D);
    }

    public void setHeader(String string) {
        this._headerTitle = string;
    }

    public boolean hasHeader() {
        return this._param.headerHeight > 0 && this._headerTitle != null;
    }

    public void setSelectionPrintMode(boolean bl) {
        this._printSelectionOnly = bl;
    }

    public void drawDiagramWithHeader(Graphics2D graphics2D) {
        this.drawDiagram(graphics2D);
        this.drawHeader(graphics2D);
    }

    public void executeNewElement() {
    }

    public void executeSelectConnectors() {
    }

    public void executeConnectionCreation() {
        if (this._linking) {
            return;
        }
        DiagramConnector diagramConnector = this.getSelectionConnector();
        if (diagramConnector != null) {
            this._dragging = false;
            this._linking = true;
            this._translating = false;
            this._resizeWay = 0;
            this._selection.unselect();
            this._connection = this.createConnection(diagramConnector, this._moveX, this._moveY);
            this._inputConnector = diagramConnector;
            this.repaint();
        }
    }

    public void executeSelectionCut() {
        if (this._linking) {
            return;
        }
        this._dragPoint.x = this._moveX;
        this._dragPoint.y = this._moveY;
        DiagramClipboard.set(this._selection.copySelection(this._dragPoint));
        this._dragging = false;
        this._selection.deleteSelection();
        this.repaint();
    }

    public void executeSelectionDelete() {
        if (this._linking) {
            this._linking = false;
            return;
        }
        this._selection.deleteSelection();
        this._translating = false;
        this._resizeWay = 0;
        this.repaint();
    }

    public void executeSelectionCopy() {
        if (this._linking) {
            return;
        }
        this._dragPoint.x = this._selX;
        this._dragPoint.y = this._selY;
        DiagramClipboard.set(this._selection.copySelection(this._dragPoint));
        this._dragging = false;
        this._selection.unselect();
        this._translating = false;
        this._resizeWay = 0;
        this.repaint();
    }

    public void executeClipboardPaste() {
        if (this._linking) {
            return;
        }
        this._selection.unselect();
        this._dragPoint.x = this._moveX;
        this._dragPoint.y = this._moveY;
        this.setCursor(Cursor.getPredefinedCursor(12));
        this._dragging = true;
        this._translating = false;
        this._resizeWay = 0;
        this.repaint();
    }

    public boolean isSelectionEmpty() {
        return this._selection.isEmpty();
    }

    public Vector getSelection() {
        return this._selection.getSelection();
    }

    public DiagramSelection getDiagramSelection() {
        return this._selection;
    }

    public DiagramConnector getSelectionConnector() {
        DiagramConnector diagramConnector;
        Shape shape;
        if (this._selection.getShapeCount() == 1 && (shape = this._selection.getShape(0)) instanceof DiagramConnector && (diagramConnector = (DiagramConnector)((Object)shape)).allowsInputConnection(null)) {
            return diagramConnector;
        }
        return null;
    }

    protected abstract void translate(int var1, int var2);

    protected abstract void getMin(Point var1);

    protected abstract void copyAt(Vector var1, int var2, int var3);

    protected abstract void drawDiagramElements(Graphics2D var1, Point var2);

    protected abstract void printDiagramElements(Graphics2D var1, Point var2);

    protected abstract void drawClipboardElements(Graphics2D var1, Point var2);

    protected abstract void drawConnection(Graphics2D var1, Point var2);

    protected abstract DiagramConnection createConnection(DiagramConnector var1, int var2, int var3);

    protected abstract void translateConnection(DiagramConnection var1, int var2, int var3);

    protected abstract void performConnection(DiagramConnection var1, DiagramConnector var2, DiagramConnector var3);

    protected void translationEnd() {
    }

    protected void resizeEnd() {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getClickCount() == 2 && (mouseEvent.getModifiers() & 0x10) == 16 && this._action != null) {
            this._action.executeAction(0, this);
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        this.requestFocus();
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if ((mouseEvent.getModifiers() & 4) == 4) {
            if (this._popup != null) {
                this._popup.show(this, mouseEvent.getX(), mouseEvent.getY());
            }
            return;
        }
        this._selX = (int)((double)mouseEvent.getX() / this._param.scale) - this._param.xmargin;
        this._selY = (int)((double)mouseEvent.getY() / this._param.scale) - this._param.ymargin;
        this._moveX = this._selX;
        this._moveY = this._selY;
        this._translating = false;
        this._resizeWay = 0;
        if (!this._linking) {
            if (this._dragging) {
                this.copyAt(DiagramClipboard.get(), this._selX, this._selY);
                this._dragging = false;
                this.setCursor(Cursor.getDefaultCursor());
                this.repaint();
            } else if (this._selection.isEmpty()) {
                if (this._selection.selectPoint(this._selX, this._selY)) {
                    this.repaint();
                }
            } else if ((mouseEvent.getModifiers() & 1) == 1) {
                if (this._selection.addPoint(this._selX, this._selY)) {
                    this.repaint();
                }
            } else if (this._selection.isSelected(this._selX, this._selY)) {
                if ((mouseEvent.getModifiers() & 2) == 2) {
                    this._dragPoint.x = this._selX;
                    this._dragPoint.y = this._selY;
                    DiagramClipboard.set(this._selection.copySelection(this._dragPoint));
                    this.setCursor(Cursor.getPredefinedCursor(12));
                    this._dragging = true;
                    this._selection.unselect();
                    this.repaint();
                } else {
                    this._resizeWay = this._selection.checkResizeWay(this._moveX, this._moveY);
                    this.setCursor(_cursors[this._resizeWay]);
                    if (this._resizeWay == 0) {
                        this._translating = true;
                    }
                    this.repaint();
                }
            } else {
                this._selection.unselect();
                this._selection.selectPoint(this._selX, this._selY);
                this.repaint();
            }
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (this._linking) {
            if (this._outputConnector == null) {
                this._linking = false;
                this._connection = null;
                this._inputConnector = null;
            } else {
                this.performConnection(this._connection, this._inputConnector, this._outputConnector);
                this._linking = false;
                this._connection = null;
                this._outputConnector = null;
                this._inputConnector = null;
                this._selection.unselect();
            }
            this.setCursor(Cursor.getDefaultCursor());
            this.repaint();
        } else {
            if (this._dragging) {
                this.copyAt(DiagramClipboard.get(), this._dragPoint.x, this._dragPoint.y);
                this._dragging = false;
                this.repaint();
            } else if (this._translating) {
                this.translationEnd();
                this._translating = false;
            } else if (this._resizeWay > 0) {
                this.resizeEnd();
                this._resizeWay = 0;
            }
            this.setCursor(Cursor.getDefaultCursor());
            if (this._selection.selectAreaEnd()) {
                this.repaint();
            }
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if ((mouseEvent.getModifiers() & 0x10) != 16) {
            return;
        }
        int n = (int)((double)mouseEvent.getX() / this._param.scale) - this._param.xmargin;
        int n2 = (int)((double)mouseEvent.getY() / this._param.scale) - this._param.ymargin;
        if (this._linking) {
            if (this._autoScrollRect != null) {
                this._autoScrollRect.x = mouseEvent.getX();
                this._autoScrollRect.y = mouseEvent.getY();
                this.scrollRectToVisible(this._autoScrollRect);
            }
            this.setCursor(Cursor.getPredefinedCursor(13));
            int n3 = n - this._moveX;
            int n4 = n2 - this._moveY;
            this.translateConnection(this._connection, n3, n4);
            this._selection.unselect();
            this._outputConnector = null;
            if (this._selection.addPoint(n, n2)) {
                Shape shape = this._selection.getShape(0);
                if (shape instanceof DiagramConnector && ((DiagramConnector)((Object)shape)).allowsOutputConnection(this._connection.input())) {
                    this._outputConnector = (DiagramConnector)((Object)shape);
                } else {
                    this._selection.unselect();
                }
            }
        } else if (this._dragging) {
            this.setCursor(Cursor.getPredefinedCursor(12));
            int n5 = n - this._moveX;
            int n6 = n2 - this._moveY;
            this._dragPoint.translate(n5, n6);
        } else if (this._selection.isEmpty() || this._selection.isSizing()) {
            this._selection.selectArea(this._selX, this._selY, n - this._selX, n2 - this._selY);
        } else {
            int n7 = n - this._moveX;
            int n8 = n2 - this._moveY;
            if (this._resizeWay > 0) {
                this._selection.resizeSelection(n7, n8, this._resizeWay);
            } else if (this._translating) {
                this._selection.translateSelection(n7, n8);
            } else {
                this._resizeWay = this._selection.checkResizeWay(this._moveX, this._moveY);
                this.setCursor(_cursors[this._resizeWay]);
                if (this._resizeWay > 0) {
                    this._selection.resizeSelection(n7, n8, this._resizeWay);
                } else {
                    this._selection.translateSelection(n7, n8);
                    this._translating = true;
                }
            }
        }
        this._moveX = n;
        this._moveY = n2;
        this.repaint();
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        int n = (int)((double)mouseEvent.getX() / this._param.scale) - this._param.xmargin;
        int n2 = (int)((double)mouseEvent.getY() / this._param.scale) - this._param.ymargin;
        if (this._linking) {
            if (this._autoScrollRect != null) {
                this._autoScrollRect.x = mouseEvent.getX();
                this._autoScrollRect.y = mouseEvent.getY();
                this.scrollRectToVisible(this._autoScrollRect);
            }
            this.setCursor(Cursor.getPredefinedCursor(13));
            int n3 = n - this._moveX;
            int n4 = n2 - this._moveY;
            this.translateConnection(this._connection, n3, n4);
            this._selection.unselect();
            this._outputConnector = null;
            if (this._selection.addPoint(n, n2)) {
                Shape shape = this._selection.getShape(0);
                if (shape instanceof DiagramConnector && ((DiagramConnector)((Object)shape)).allowsOutputConnection(this._connection.input())) {
                    this._outputConnector = (DiagramConnector)((Object)shape);
                } else {
                    this._selection.unselect();
                }
            }
            this._moveX = n;
            this._moveY = n2;
            this.repaint();
        } else if (this._dragging) {
            this.setCursor(Cursor.getPredefinedCursor(12));
            int n5 = n - this._moveX;
            int n6 = n2 - this._moveY;
            this._dragPoint.translate(n5, n6);
            this._moveX = n;
            this._moveY = n2;
            this.repaint();
        } else {
            this._translating = false;
            this._resizeWay = 0;
            this._moveX = n;
            this._moveY = n2;
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("l")) {
            this.executeConnectionCreation();
        } else if (string.equals("s")) {
            this.executeSelectConnectors();
        } else if (string.equals("n")) {
            this.executeNewElement();
        } else if (string.equals("c")) {
            this.executeSelectionCopy();
        } else if (string.equals("v")) {
            this.executeClipboardPaste();
        } else if (string.equals("x")) {
            this.executeSelectionCut();
        } else if (string.equals("d")) {
            this.executeSelectionDelete();
        } else if (string.equals("exitFullScreen") && this.fullScreen) {
            this.setFullScreen(false);
        }
    }

    protected double computePrintScaleFactor(PageFormat pageFormat) {
        double d;
        double d2;
        double d3 = pageFormat.getImageableWidth() / (double)this._param.width;
        double d4 = this._param.height;
        if (this.hasHeader()) {
            d4 += (double)this._param.headerHeight;
        }
        if ((d2 = Math.min(d3, d = pageFormat.getImageableHeight() / d4)) > 1.0) {
            d2 = 1.0;
        }
        return d2;
    }

    public int print(Graphics graphics, PageFormat pageFormat, int n) throws PrinterException {
        if (n >= 1) {
            return 1;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.translate((int)pageFormat.getImageableX(), (int)pageFormat.getImageableY());
        double d = this.computePrintScaleFactor(pageFormat);
        graphics2D.scale(d, d);
        this.printDiagram(graphics2D);
        return 0;
    }

    public Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    public int getScrollableUnitIncrement(Rectangle rectangle, int n, int n2) {
        return Math.max(1, (n == 1 ? rectangle.height : rectangle.width) / 10);
    }

    public int getScrollableBlockIncrement(Rectangle rectangle, int n, int n2) {
        return n == 1 ? rectangle.height : rectangle.width;
    }

    public boolean getScrollableTracksViewportWidth() {
        return false;
    }

    public boolean getScrollableTracksViewportHeight() {
        return false;
    }

    protected void registerActions() {
        this.setRequestFocusEnabled(true);
        KeyStroke keyStroke = KeyStroke.getKeyStroke(76, 2);
        this.registerKeyboardAction(this, "l", keyStroke, 0);
        keyStroke = KeyStroke.getKeyStroke(87, 2);
        this.registerKeyboardAction(this, "l", keyStroke, 0);
        keyStroke = KeyStroke.getKeyStroke(83, 2);
        this.registerKeyboardAction(this, "s", keyStroke, 0);
        keyStroke = KeyStroke.getKeyStroke(78, 2);
        this.registerKeyboardAction(this, "n", keyStroke, 0);
        keyStroke = KeyStroke.getKeyStroke(67, 2);
        this.registerKeyboardAction(this, "c", keyStroke, 0);
        keyStroke = KeyStroke.getKeyStroke(65485, 0);
        this.registerKeyboardAction(this, "c", keyStroke, 0);
        keyStroke = KeyStroke.getKeyStroke(88, 2);
        this.registerKeyboardAction(this, "x", keyStroke, 0);
        keyStroke = KeyStroke.getKeyStroke(65489, 0);
        this.registerKeyboardAction(this, "x", keyStroke, 0);
        keyStroke = KeyStroke.getKeyStroke(86, 2);
        this.registerKeyboardAction(this, "v", keyStroke, 0);
        keyStroke = KeyStroke.getKeyStroke(65487, 0);
        this.registerKeyboardAction(this, "v", keyStroke, 0);
        keyStroke = KeyStroke.getKeyStroke(127, 0);
        this.registerKeyboardAction(this, "d", keyStroke, 0);
        keyStroke = KeyStroke.getKeyStroke(8, 0);
        this.registerKeyboardAction(this, "d", keyStroke, 0);
        keyStroke = KeyStroke.getKeyStroke(27, 0);
        this.registerKeyboardAction(this, "exitFullScreen", keyStroke, 0);
    }

    public boolean isFullScreen() {
        return this.fullScreen;
    }

    public void setFullScreen(boolean bl) {
        if (this.fullScreenDevice == null || this.fullScreenFrame == null) {
            bl = false;
        }
        if (bl) {
            this.setFullScreen(this.fullScreenDevice);
            return;
        }
        if (this.fullScreen) {
            if (this.fullScreenDevice != null) {
                this.fullScreenDevice.setFullScreenWindow(null);
            }
            if (this.windowedModeParent != null) {
                this.windowedModeParent.add(this);
            }
            this.setVisible(true);
            this.revalidate();
            this.fullScreenFrame.hide();
        }
        this.fullScreen = false;
    }

    public void setFullScreen(GraphicsDevice graphicsDevice) {
        if (graphicsDevice == null) {
            this.setFullScreen(false);
            return;
        }
        this.fullScreenDevice = graphicsDevice;
        if (this.fullScreenFrame == null) {
            this.fullScreenFrame = new JFrame();
            this.fullScreenFrame.setUndecorated(true);
            this.fullScreenFrame.setResizable(false);
            if (this._param.backgr != null) {
                this.fullScreenFrame.setBackground(this._param.backgr);
            }
        }
        if (!this.fullScreen) {
            this.windowedModeParent = this.getParent();
        }
        this.fullScreenFrame.getContentPane().add(this);
        graphicsDevice.setFullScreenWindow(this.fullScreenFrame);
        this.fullScreen = true;
        this.setDiagramSize((int)((double)graphicsDevice.getDisplayMode().getWidth() / this._param.scale + 0.5), (int)((double)graphicsDevice.getDisplayMode().getHeight() / this._param.scale + 0.5));
        this.fullScreenFrame.show();
    }

    static {
        float[] fArray = new float[]{5.0f};
        _dashStroke = new BasicStroke(1.0f, 2, 0, 10.0f, fArray, 0.0f);
        _defaultStroke = new BasicStroke();
        _gridColor = Color.lightGray;
        _selectionColor = Color.red;
        _defaultColor = Color.black;
    }
}

