/*
 * Decompiled with CFR 0.152.
 */
package jsynoptic.ui;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.SystemColor;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InputEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.TransferHandler;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import jsynoptic.base.ContextualActionProvider;
import jsynoptic.data.ExpressionDataSource;
import jsynoptic.ui.JSynoptic;
import jsynoptic.ui.ShapesContainer;
import simtools.data.DataInfo;
import simtools.data.DataSource;
import simtools.data.DataSourceCollection;
import simtools.data.DataSourcePool;
import simtools.data.DataSourcePoolEvent;
import simtools.data.DataSourcePoolListener;
import simtools.data.DynamicDataSource;
import simtools.data.DynamicDataSourceCollection;
import simtools.shapes.ShapesContainer;
import simtools.ui.BasicMessageWriter;
import simtools.ui.MenuResourceBundle;
import simtools.ui.ResourceFinder;

public class SourceTree
extends JTree
implements DataSourcePoolListener,
ActionListener {
    public static MenuResourceBundle resources = ResourceFinder.getMenu(class$jsynoptic$ui$SourceTree == null ? (class$jsynoptic$ui$SourceTree = SourceTree.class$("jsynoptic.ui.SourceTree")) : class$jsynoptic$ui$SourceTree);
    public static BasicMessageWriter messageWriter = ResourceFinder.getMessages(class$jsynoptic$ui$SourceTree == null ? (class$jsynoptic$ui$SourceTree = SourceTree.class$("jsynoptic.ui.SourceTree")) : class$jsynoptic$ui$SourceTree);
    protected DataSourcePool pool;
    protected DefaultMutableTreeNode rootNode = new DefaultMutableTreeNode();
    protected DefaultTreeModel treeModel = new DefaultTreeModel(this.rootNode);
    protected JMenuItem sourceInfo;
    protected double actionX;
    protected double actionY;
    static /* synthetic */ Class class$jsynoptic$ui$SourceTree;
    static /* synthetic */ Class class$simtools$data$DataSource;
    static /* synthetic */ Class class$simtools$data$DataSourceCollection;

    public SourceTree(DataSourcePool dataSourcePool) {
        this.setModel(this.treeModel);
        this.setRootVisible(false);
        this.setShowsRootHandles(true);
        this.pool = dataSourcePool;
        dataSourcePool.addListener(this);
        Object object = dataSourcePool.dataSources().iterator();
        while (object.hasNext()) {
            this.addSource((DataSource)object.next());
        }
        object = dataSourcePool.dataSourceCollections().iterator();
        while (object.hasNext()) {
            this.addCollection((DataSourceCollection)object.next());
        }
        this.treeModel.reload();
        this.setTransferHandler(new SourceTransferHandler());
        this.setDragEnabled(true);
        this.setCellRenderer(new SourceCellRenderer());
        object = new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                JComponent jComponent = (JComponent)mouseEvent.getSource();
                if (jComponent != SourceTree.this) {
                    return;
                }
                TreePath treePath = SourceTree.this.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
                if ((mouseEvent.getModifiers() & 4) == 4) {
                    Object object;
                    if (treePath != null) {
                        SourceTree.this.setSelectionPath(treePath);
                    }
                    boolean bl = false;
                    if (SourceTree.this.getSelectionPath() != null && (object = SourceTree.this.getSelectionPath().getLastPathComponent()) instanceof LockableTreeNode && ((LockableTreeNode)object).isLocked()) {
                        bl = true;
                    }
                    if (!bl) {
                        SourceTree.this.doPopup(mouseEvent.getX(), mouseEvent.getY());
                    }
                    return;
                }
                if (treePath == null) {
                    return;
                }
                TransferHandler transferHandler = jComponent.getTransferHandler();
                transferHandler.exportAsDrag(jComponent, mouseEvent, 1);
            }

            public void mouseExited(MouseEvent mouseEvent) {
                SourceTree.this.setCursor(Cursor.getDefaultCursor());
            }
        };
        this.addMouseListener((MouseListener)object);
        MouseMotionAdapter mouseMotionAdapter = new MouseMotionAdapter(){

            public void mouseMoved(MouseEvent mouseEvent) {
                Object object;
                JComponent jComponent = (JComponent)mouseEvent.getSource();
                if (jComponent != SourceTree.this) {
                    return;
                }
                TreePath treePath = SourceTree.this.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
                if (treePath != null && (object = treePath.getLastPathComponent()) instanceof LockableTreeNode && ((LockableTreeNode)object).isLocked()) {
                    SourceTree.this.setCursor(Cursor.getPredefinedCursor(3));
                    return;
                }
                SourceTree.this.setCursor(Cursor.getDefaultCursor());
            }
        };
        this.addMouseMotionListener(mouseMotionAdapter);
        this.registerKeyboardAction(this, "d", KeyStroke.getKeyStroke(127, 0), 0);
        this.registerKeyboardAction(this, "d", KeyStroke.getKeyStroke(8, 0), 0);
    }

    public SourceTree() {
        this(DataSourcePool.global);
    }

    public void setSelectedValue(Object object) {
        if (object == null) {
            return;
        }
        Enumeration<TreeNode> enumeration = this.rootNode.depthFirstEnumeration();
        while (enumeration.hasMoreElements()) {
            DefaultMutableTreeNode defaultMutableTreeNode;
            Object object2;
            TreeNode treeNode = enumeration.nextElement();
            if (!(treeNode instanceof DefaultMutableTreeNode) || (object2 = (defaultMutableTreeNode = (DefaultMutableTreeNode)treeNode).getUserObject()) == null || !object2.equals(object)) continue;
            TreePath treePath = new TreePath(defaultMutableTreeNode.getPath());
            this.scrollPathToVisible(treePath);
            this.setSelectionPath(treePath);
            return;
        }
    }

    public void setSelectedValueById(String string) {
        if (string == null) {
            return;
        }
        Enumeration<TreeNode> enumeration = this.rootNode.depthFirstEnumeration();
        while (enumeration.hasMoreElements()) {
            DefaultMutableTreeNode defaultMutableTreeNode;
            TreeNode treeNode = enumeration.nextElement();
            if (!(treeNode instanceof DefaultMutableTreeNode) || !string.equals(DataInfo.getId((defaultMutableTreeNode = (DefaultMutableTreeNode)treeNode).getUserObject()))) continue;
            TreePath treePath = new TreePath(defaultMutableTreeNode.getPath());
            this.scrollPathToVisible(treePath);
            this.setSelectionPath(treePath);
            return;
        }
    }

    protected void recursiveLock(DefaultMutableTreeNode defaultMutableTreeNode, Object object, boolean bl) {
        if (defaultMutableTreeNode == null) {
            return;
        }
        if (defaultMutableTreeNode.getUserObject() == object && defaultMutableTreeNode instanceof LockableTreeNode) {
            ((LockableTreeNode)defaultMutableTreeNode).setLocked(bl);
            return;
        }
        if (!defaultMutableTreeNode.getAllowsChildren()) {
            return;
        }
        Enumeration<TreeNode> enumeration = defaultMutableTreeNode.children();
        if (enumeration == null) {
            return;
        }
        while (enumeration.hasMoreElements()) {
            this.recursiveLock((DefaultMutableTreeNode)enumeration.nextElement(), object, bl);
        }
    }

    public void lock(Object object) {
        this.recursiveLock(this.rootNode, object, true);
        this.repaint();
    }

    public void unlock(Object object) {
        this.recursiveLock(this.rootNode, object, false);
        this.repaint();
    }

    public boolean isLocked(Object object) {
        return this.recursiveIsLocked(this.rootNode, object);
    }

    protected boolean recursiveIsLocked(DefaultMutableTreeNode defaultMutableTreeNode, Object object) {
        if (defaultMutableTreeNode == null) {
            return false;
        }
        if (defaultMutableTreeNode.getUserObject() == object && defaultMutableTreeNode instanceof LockableTreeNode) {
            return ((LockableTreeNode)defaultMutableTreeNode).isLocked();
        }
        if (!defaultMutableTreeNode.getAllowsChildren()) {
            return false;
        }
        Enumeration<TreeNode> enumeration = defaultMutableTreeNode.children();
        if (enumeration == null) {
            return false;
        }
        while (enumeration.hasMoreElements()) {
            if (!this.recursiveIsLocked((DefaultMutableTreeNode)enumeration.nextElement(), object)) continue;
            return true;
        }
        return false;
    }

    protected void doPopup(int n, int n2) {
        ContextualActionProvider contextualActionProvider;
        String[] stringArray;
        JPopupMenu jPopupMenu;
        ShapesContainer shapesContainer = JSynoptic.gui.getActiveContainer();
        if (shapesContainer == null) {
            return;
        }
        ShapesContainer.ShapesComponent shapesComponent = shapesContainer.getComponent();
        if (shapesComponent == null) {
            return;
        }
        if (!(shapesComponent instanceof ShapesContainer.ShapesComponent)) {
            return;
        }
        ShapesContainer.ShapesComponent shapesComponent2 = (ShapesContainer.ShapesComponent)shapesComponent;
        if (this.getSelectionPath() == null && shapesComponent2.isSelectionEmpty()) {
            JSynoptic.setStatus(messageWriter.print0args("noSelection"));
            return;
        }
        Point point = shapesComponent2.getLocationOnScreen();
        Point point2 = this.getLocationOnScreen();
        int n3 = n + point2.x - point.x;
        int n4 = n2 + point2.y - point.y;
        if (shapesComponent2.isSelectionEmpty()) {
            jPopupMenu = new JPopupMenu();
        } else {
            jPopupMenu = shapesComponent2.doPopup(n3, n4, 2);
            jPopupMenu.addSeparator();
        }
        if (this.sourceInfo == null) {
            this.sourceInfo = resources.getItem("sourceInfo", this);
        }
        jPopupMenu.add(this.sourceInfo);
        Object object = this.getSelectedSourceOrCollection();
        if (object != null && object instanceof ContextualActionProvider && (stringArray = (contextualActionProvider = (ContextualActionProvider)object).getActions(n, n2, object, 2)) != null && stringArray.length != 0) {
            for (int i = 0; i < stringArray.length; ++i) {
                JMenuItem jMenuItem = new JMenuItem(stringArray[i]);
                if (!contextualActionProvider.canDoAction(n, n2, object, stringArray[i], 2)) {
                    jMenuItem.setEnabled(false);
                } else {
                    jMenuItem.addActionListener(this);
                }
                this.add(jMenuItem);
                jPopupMenu.add(jMenuItem);
            }
        }
        this.actionX = n2;
        this.actionY = n2;
        jPopupMenu.show(this, n, n2);
    }

    protected void removeNodesWithUserObject(Object object) {
        Vector<DefaultMutableTreeNode> vector = new Vector<DefaultMutableTreeNode>();
        Object object2 = this.rootNode.children();
        while (object2.hasMoreElements()) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)object2.nextElement();
            if (defaultMutableTreeNode.getUserObject() != object) continue;
            vector.add(defaultMutableTreeNode);
        }
        object2 = vector.iterator();
        while (object2.hasNext()) {
            this.rootNode.remove((MutableTreeNode)object2.next());
        }
    }

    protected void addSource(DataSource dataSource) {
        this.treeModel.insertNodeInto(new SourceNode(dataSource), this.rootNode, this.rootNode.getChildCount());
    }

    protected void addCollection(DataSourceCollection dataSourceCollection) {
        this.treeModel.insertNodeInto(new CollectionNode(dataSourceCollection), this.rootNode, this.rootNode.getChildCount());
    }

    protected void changeSource(DataSource dataSource, DataSource dataSource2) {
        Enumeration<TreeNode> enumeration = this.rootNode.children();
        while (enumeration.hasMoreElements()) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)enumeration.nextElement();
            if (defaultMutableTreeNode.getUserObject() != dataSource2) continue;
            ((SourceNode)defaultMutableTreeNode).changeSource(dataSource);
        }
    }

    protected void changeCollection(DataSourceCollection dataSourceCollection, DataSourceCollection dataSourceCollection2) {
        Enumeration<TreeNode> enumeration = this.rootNode.children();
        while (enumeration.hasMoreElements()) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)enumeration.nextElement();
            if (defaultMutableTreeNode.getUserObject() != dataSourceCollection2) continue;
            ((CollectionNode)defaultMutableTreeNode).changeCollection(dataSourceCollection);
        }
    }

    public Object getSelectedSourceOrCollection() {
        if (this.getSelectionPath() == null) {
            return null;
        }
        Object object = this.getSelectionPath().getLastPathComponent();
        if (object == null) {
            return null;
        }
        if (object instanceof SourceNode) {
            return ((SourceNode)object).getUserObject();
        }
        if (object instanceof CollectionNode) {
            return ((CollectionNode)object).getUserObject();
        }
        return null;
    }

    public void dataSourcePoolNotification(DataSourcePoolEvent dataSourcePoolEvent) {
        switch (dataSourcePoolEvent.action) {
            case 9: {
                this.addSource(dataSourcePoolEvent.source);
                break;
            }
            case 17: {
                this.addCollection(dataSourcePoolEvent.collection);
                break;
            }
            case 10: {
                this.removeNodesWithUserObject(dataSourcePoolEvent.source);
                break;
            }
            case 18: {
                this.removeNodesWithUserObject(dataSourcePoolEvent.collection);
                break;
            }
            case 12: {
                this.changeSource(dataSourcePoolEvent.source, dataSourcePoolEvent.oldSource);
                break;
            }
            case 20: {
                this.changeCollection(dataSourcePoolEvent.collection, dataSourcePoolEvent.oldCollection);
            }
        }
        this.reload();
    }

    public void reload() {
        DefaultMutableTreeNode defaultMutableTreeNode;
        TreePath treePath = this.getSelectionPath();
        Vector<DefaultMutableTreeNode> vector = new Vector<DefaultMutableTreeNode>();
        Object object = this.rootNode.children();
        while (object.hasMoreElements()) {
            defaultMutableTreeNode = (DefaultMutableTreeNode)object.nextElement();
            if (!this.isExpanded(new TreePath(defaultMutableTreeNode.getPath()))) continue;
            vector.add(defaultMutableTreeNode);
        }
        this.treeModel.reload();
        object = vector.iterator();
        while (object.hasNext()) {
            defaultMutableTreeNode = (DefaultMutableTreeNode)object.next();
            this.expandPath(new TreePath(defaultMutableTreeNode.getPath()));
        }
        this.setSelectionPath(treePath);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.sourceInfo) {
            Object object = this.getSelectedSourceOrCollection();
            if (object == null) {
                return;
            }
            Vector<String> vector = new Vector<String>();
            if (DataInfo.getLabel(object) != null) {
                vector.add(messageWriter.print1args("sourceName", DataInfo.getLabel(object)));
            }
            if (DataInfo.getId(object) != null) {
                vector.add(messageWriter.print1args("sourceId", DataInfo.getId(object)));
            }
            if (DataInfo.getComment(object) != null) {
                vector.add(messageWriter.print1args("sourceComment", DataInfo.getComment(object)));
            }
            if (DataInfo.getUnit(object) != null) {
                vector.add(messageWriter.print1args("sourceUnit", DataInfo.getUnit(object)));
            }
            if (DataInfo.getLinkedId(object) != null) {
                vector.add(messageWriter.print1args("sourceLinkedId", DataInfo.getLinkedId(object)));
            }
            if (vector.size() == 0) {
                JSynoptic.setStatus(messageWriter.print0args("noInfo"));
                return;
            }
            JOptionPane.showMessageDialog(JSynoptic.gui, vector.toArray(), messageWriter.print0args("sourceInfo"), 1);
            return;
        }
        if (actionEvent.getSource() instanceof JMenuItem) {
            JMenuItem jMenuItem = (JMenuItem)actionEvent.getSource();
            Object object = this.getSelectedSourceOrCollection();
            if (!(object instanceof ContextualActionProvider)) {
                return;
            }
            ((ContextualActionProvider)object).doAction(this.actionX, this.actionY, object, jMenuItem.getText());
            return;
        }
        String string = actionEvent.getActionCommand();
        if (string.equals("d")) {
            Object object = this.getSelectedSourceOrCollection();
            if (object == null) {
                return;
            }
            if (this.isLocked(object)) {
                return;
            }
            if (object instanceof DataSource) {
                this.pool.removeDataSource((DataSource)object);
            } else if (object instanceof DataSourceCollection) {
                this.pool.removeDataSourceCollection((DataSourceCollection)object);
            }
            return;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class SourceTransferHandler
    extends TransferHandler {
        SourceTransferHandler() {
        }

        protected Transferable createTransferable(JComponent jComponent) {
            if (jComponent != SourceTree.this) {
                return null;
            }
            return new SourceTransferable();
        }

        public void exportAsDrag(JComponent jComponent, InputEvent inputEvent, int n) {
            super.exportAsDrag(jComponent, inputEvent, n);
        }
    }

    class SourceTransferable
    implements Transferable {
        SourceTransferable() {
        }

        public DataFlavor[] getTransferDataFlavors() {
            Object object = SourceTree.this.getSelectionPath().getLastPathComponent();
            if (object == null) {
                return new DataFlavor[0];
            }
            DataFlavor[] dataFlavorArray = new DataFlavor[]{object instanceof SourceNode ? new DataFlavor(class$simtools$data$DataSource == null ? (class$simtools$data$DataSource = SourceTree.class$("simtools.data.DataSource")) : class$simtools$data$DataSource, object.toString()) : (object instanceof CollectionNode ? new DataFlavor(class$simtools$data$DataSourceCollection == null ? (class$simtools$data$DataSourceCollection = SourceTree.class$("simtools.data.DataSourceCollection")) : class$simtools$data$DataSourceCollection, object.toString()) : DataFlavor.stringFlavor)};
            return dataFlavorArray;
        }

        public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
            Object object = SourceTree.this.getSelectionPath().getLastPathComponent();
            if (object == null) {
                return false;
            }
            if (object instanceof SourceNode) {
                return (class$simtools$data$DataSource == null ? (class$simtools$data$DataSource = SourceTree.class$("simtools.data.DataSource")) : class$simtools$data$DataSource).equals(dataFlavor.getRepresentationClass());
            }
            if (object instanceof CollectionNode) {
                return (class$simtools$data$DataSourceCollection == null ? (class$simtools$data$DataSourceCollection = SourceTree.class$("simtools.data.DataSourceCollection")) : class$simtools$data$DataSourceCollection).equals(dataFlavor.getRepresentationClass());
            }
            return false;
        }

        public Object getTransferData(DataFlavor dataFlavor) {
            Object object = SourceTree.this.getSelectedSourceOrCollection();
            if (object == null) {
                return null;
            }
            if (object instanceof DataSource && (class$simtools$data$DataSource == null ? (class$simtools$data$DataSource = SourceTree.class$("simtools.data.DataSource")) : class$simtools$data$DataSource).equals(dataFlavor.getRepresentationClass())) {
                return object;
            }
            if (object instanceof DataSourceCollection && (class$simtools$data$DataSourceCollection == null ? (class$simtools$data$DataSourceCollection = SourceTree.class$("simtools.data.DataSourceCollection")) : class$simtools$data$DataSourceCollection).equals(dataFlavor.getRepresentationClass())) {
                return object;
            }
            return null;
        }
    }

    class CollectionNode
    extends LockableTreeNode {
        CollectionNode(DataSourceCollection dataSourceCollection) {
            super(dataSourceCollection, true);
            Iterator iterator = dataSourceCollection.iterator();
            while (iterator.hasNext()) {
                this.add(new SourceNode((DataSource)iterator.next()));
            }
        }

        public String toString() {
            if (this.userObject == null) {
                return "DataSourceCollection";
            }
            String string = DataInfo.getLabel((DataSourceCollection)this.userObject);
            if (string != null) {
                return string;
            }
            string = this.userObject.getClass().getName();
            int n = string.lastIndexOf(".");
            if (n != -1) {
                return string.substring(n + 1);
            }
            return string;
        }

        public void changeCollection(DataSourceCollection dataSourceCollection) {
            this.removeAllChildren();
            this.setUserObject(dataSourceCollection);
            Iterator iterator = dataSourceCollection.iterator();
            while (iterator.hasNext()) {
                this.add(new SourceNode((DataSource)iterator.next()));
            }
        }

        public boolean isLocked() {
            Enumeration<TreeNode> enumeration = this.children();
            if (enumeration != null) {
                while (enumeration.hasMoreElements()) {
                    TreeNode treeNode = enumeration.nextElement();
                    if (!(treeNode instanceof LockableTreeNode) || !((LockableTreeNode)treeNode).getLocked()) continue;
                    return true;
                }
            }
            return super.isLocked();
        }
    }

    class SourceNode
    extends LockableTreeNode {
        SourceNode(DataSource dataSource) {
            super(dataSource, false);
        }

        public String toString() {
            if (this.userObject == null) {
                return "DataSource";
            }
            String string = DataInfo.toString((DataSource)this.userObject);
            if (string != null) {
                return string;
            }
            string = this.userObject.getClass().getName();
            int n = string.lastIndexOf(".");
            if (n != -1) {
                return string.substring(n + 1);
            }
            return string;
        }

        public void changeSource(DataSource dataSource) {
            this.setUserObject(dataSource);
        }
    }

    class LockableTreeNode
    extends DefaultMutableTreeNode {
        boolean locked;

        LockableTreeNode(Object object, boolean bl) {
            super(object, bl);
            this.setLocked(false);
        }

        public void setLocked(boolean bl) {
            this.locked = bl;
        }

        public boolean getLocked() {
            return this.locked;
        }

        public boolean isLocked() {
            if (this.locked) {
                return true;
            }
            TreeNode treeNode = this.getParent();
            if (treeNode == null) {
                return false;
            }
            if (treeNode instanceof LockableTreeNode) {
                return ((LockableTreeNode)treeNode).isLocked();
            }
            return false;
        }
    }

    class SourceCellRenderer
    extends DefaultTreeCellRenderer {
        Icon expressionIcon = resources.getIcon("expIcon");
        Icon dynamicSourceIcon = resources.getIcon("dynamicSourceIcon");
        Icon dynamicSourceCollectionIcon = resources.getIcon("dynamicSourceCollectionIcon");

        SourceCellRenderer() {
        }

        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            Component component = super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
            if (object == null) {
                return component;
            }
            if (object instanceof LockableTreeNode) {
                Object object2 = ((LockableTreeNode)object).getUserObject();
                if (object2 instanceof ExpressionDataSource) {
                    this.setIcon(this.expressionIcon);
                    this.setText(DataInfo.toString(object2) + " = " + DataInfo.getComment(object2));
                }
                if (object2 instanceof DynamicDataSource) {
                    this.setIcon(this.dynamicSourceIcon);
                }
                if (object2 instanceof DynamicDataSourceCollection) {
                    this.setIcon(this.dynamicSourceCollectionIcon);
                }
                if (((LockableTreeNode)object).isLocked()) {
                    component.setForeground(SystemColor.controlDkShadow);
                }
            }
            return component;
        }
    }
}

