/*
 * Decompiled with CFR 0.152.
 */
package jsynoptic.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.Iterator;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import jsynoptic.base.Plugin;
import jsynoptic.builtin.Builtin;
import jsynoptic.data.ExpressionDataSourceProvider;
import jsynoptic.ui.JSynoptic;
import jsynoptic.ui.JSynopticBatch;
import jsynoptic.ui.PluginLookup;
import simtools.data.DataSourcePool;
import simtools.ui.BasicMessageWriter;
import simtools.ui.CustomizedLocale;
import simtools.ui.MenuResourceBundle;
import simtools.ui.ResourceFinder;
import simtools.ui.UserProperties;

public class Run {
    public static MenuResourceBundle resources;
    public static BasicMessageWriter messageWriter;
    public static String productName;
    public static double productVersion;
    protected static UserProperties userProperties;
    public static Vector plugins;
    public static Frame barFrame;
    static /* synthetic */ Class class$jsynoptic$ui$Run;

    protected static void loadPlugin(String string) {
        for (int i = 0; i < plugins.size(); ++i) {
            if (!plugins.get(i).getClass().getName().equals(string)) continue;
            return;
        }
        Plugin plugin = Plugin.load(string);
        if (plugin == null) {
            System.err.println(messageWriter.print1args("cannotLoadPlugin", string));
        } else {
            plugins.add(plugin);
        }
    }

    public static UserProperties getProperties() {
        return userProperties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void checkJavaVersion(boolean bl) {
        double d = 0.0;
        try {
            d = Double.parseDouble(System.getProperty("java.specification.version"));
        }
        catch (Throwable throwable) {
            d = 0.0;
        }
        if (d < 1.4) {
            System.err.println("Java version 1.4 or later is required to run this program.");
            System.err.println("Please download it from http://java.sun.com/");
            if (!bl) {
                final Frame frame = new Frame("System Configuration Error");
                frame.add((Component)new Label("Java version 1.4 or later is required to run this program."), "North");
                frame.add((Component)new Label("Please download it from http://java.sun.com/"), "South");
                frame.pack();
                frame.show();
                frame.addWindowListener(new WindowAdapter(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void windowClosing(WindowEvent windowEvent) {
                        Frame frame2 = frame;
                        synchronized (frame2) {
                            frame.notifyAll();
                        }
                    }
                });
                Frame frame2 = frame;
                synchronized (frame2) {
                    try {
                        frame.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
            System.exit(1);
        }
    }

    public static void main(String[] stringArray) {
        String string;
        boolean bl = false;
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals("-printToFile") && !stringArray[i].equals("-f") && !stringArray[i].equals("-print") && !stringArray[i].equals("-p") && !stringArray[i].equals("-printTo") && !stringArray[i].equals("-t")) continue;
            bl = true;
        }
        Run.checkJavaVersion(bl);
        userProperties = new UserProperties("jsynoptic");
        userProperties.read();
        String string2 = userProperties.getString("jsynoptic.language", "");
        if ((System.getProperty("language") == null || System.getProperty("language").equals("")) && !string2.equals("")) {
            int n = string2.indexOf(95);
            if (n == -1) {
                CustomizedLocale.set(new Locale(string2));
            } else {
                String string3 = string2.substring(0, n);
                string = string2.substring(n + 1);
                if ((n = string.indexOf(95)) == -1) {
                    CustomizedLocale.set(new Locale(string3, string));
                } else {
                    CustomizedLocale.set(new Locale(string3, string.substring(0, n), string.substring(n + 1)));
                }
            }
        }
        resources = ResourceFinder.getMenu(class$jsynoptic$ui$Run == null ? (class$jsynoptic$ui$Run = Run.class$("jsynoptic.ui.Run")) : class$jsynoptic$ui$Run);
        messageWriter = ResourceFinder.getMessages(class$jsynoptic$ui$Run == null ? (class$jsynoptic$ui$Run = Run.class$("jsynoptic.ui.Run")) : class$jsynoptic$ui$Run);
        productName = resources.getStringValue("productName");
        productVersion = resources.getDoubleValue("productVersion");
        plugins = new Vector();
        plugins.add(new Builtin());
        Vector<String> vector = new Vector<String>();
        boolean bl2 = false;
        string = userProperties.getString("jsynoptic.plugins", "");
        barFrame = null;
        JProgressBar jProgressBar = null;
        JLabel jLabel = null;
        JLabel jLabel2 = null;
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-help") || stringArray[i].equals("-h") || stringArray[i].equals("--help")) {
                int n = resources.getIntValue("helpMsgNumLines");
                for (int j = 0; j < n; ++j) {
                    System.out.println(messageWriter.print0args("helpMsg" + j));
                }
                System.exit(0);
            }
            if (stringArray[i].equals("-plugin") || stringArray[i].equals("-g")) {
                if (i + 1 >= stringArray.length) {
                    System.err.println(messageWriter.print0args("pluginHelp"));
                    System.exit(0);
                }
                Run.loadPlugin(stringArray[++i]);
                continue;
            }
            if (stringArray[i].equals("-printToFile") || stringArray[i].equals("-f")) {
                bl = true;
                if (i + 1 >= stringArray.length) {
                    System.err.println(messageWriter.print0args("printToFileHelp"));
                    System.exit(0);
                }
                vector.add("printToFile " + stringArray[++i]);
                continue;
            }
            if (stringArray[i].equals("-paper") || stringArray[i].equals("-a")) {
                bl = true;
                if (i + 1 >= stringArray.length) {
                    System.err.println(messageWriter.print0args("paperHelp"));
                    System.exit(0);
                }
                vector.add("paper " + stringArray[++i]);
                continue;
            }
            if (stringArray[i].equals("-orientation") || stringArray[i].equals("-o")) {
                bl = true;
                if (i + 1 >= stringArray.length) {
                    System.err.println(messageWriter.print0args("orientationHelp"));
                    System.exit(0);
                }
                vector.add("orientation " + stringArray[++i]);
                continue;
            }
            if (stringArray[i].equals("-printTo") || stringArray[i].equals("-t")) {
                bl = true;
                if (i + 1 >= stringArray.length) {
                    System.err.println(messageWriter.print0args("printToHelp"));
                    System.exit(0);
                }
                vector.add("printToPrinter " + stringArray[++i]);
                continue;
            }
            if (stringArray[i].equals("-print") || stringArray[i].equals("-p")) {
                bl = true;
                vector.add("printToPrinter");
                continue;
            }
            vector.add("load " + stringArray[i]);
        }
        if (bl) {
            System.out.println(messageWriter.print0args("waitLoading"));
        } else {
            barFrame = new Frame(messageWriter.print0args("waitLoading"));
            Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
            barFrame.setBounds(dimension.width / 4, 3 * dimension.height / 7, dimension.width / 2, dimension.height / 7);
            JPanel jPanel = new JPanel(new GridLayout(3, 1));
            jProgressBar = new JProgressBar();
            jProgressBar.setMinimum(0);
            jProgressBar.setValue(0);
            jProgressBar.setMaximum(100);
            jLabel = new JLabel(messageWriter.print2args("productString", productName, String.valueOf(productVersion)));
            jLabel2 = new JLabel("");
            jPanel.add(jProgressBar);
            jPanel.add(jLabel);
            jPanel.add(jLabel2);
            barFrame.add((Component)jPanel, "Center");
            barFrame.show();
            Toolkit.getDefaultToolkit().sync();
            jProgressBar.setValue(10);
            Toolkit.getDefaultToolkit().sync();
        }
        try {
            String string4 = userProperties.getString("jsynoptic.class.path", "");
            String string5 = userProperties.getString("jsynoptic.native.path", "");
            if (string4.equals("") || string5.equals("")) {
                PluginLookup.addPluginPaths();
                userProperties.setString("jsynoptic.class.path", PluginLookup.getClassPath());
                userProperties.setString("jsynoptic.native.path", PluginLookup.getNativePath());
            } else {
                StringTokenizer stringTokenizer = new StringTokenizer(string4, ", ;:\t|");
                while (stringTokenizer.hasMoreTokens()) {
                    PluginLookup.addClassPath(stringTokenizer.nextToken());
                }
                stringTokenizer = new StringTokenizer(string5, ", ;:\t|");
                while (stringTokenizer.hasMoreTokens()) {
                    PluginLookup.addNativePath(new File(stringTokenizer.nextToken()));
                }
            }
            if (string.equals("")) {
                if (!bl) {
                    jProgressBar.setValue(20);
                    jLabel.setText(messageWriter.print0args("lookupPlugins"));
                }
                Iterator iterator = PluginLookup.lookup().iterator();
                while (iterator.hasNext()) {
                    String string6 = (String)iterator.next();
                    if (!string.equals("")) {
                        string = string + ",";
                    }
                    string = string + string6;
                    Run.loadPlugin(string6);
                }
                if (!string.equals("")) {
                    userProperties.setString("jsynoptic.plugins", string);
                }
            } else {
                StringTokenizer stringTokenizer = new StringTokenizer(string, ", ;:\t|");
                int n = stringTokenizer.countTokens();
                int n2 = 0;
                if (!bl) {
                    jLabel.setText(messageWriter.print0args("loadingPlugins"));
                }
                while (stringTokenizer.hasMoreTokens()) {
                    Run.loadPlugin(stringTokenizer.nextToken());
                    if (!bl) {
                        jProgressBar.setValue(20 + 40 * n2 / n);
                    }
                    ++n2;
                }
            }
            DataSourcePool.global.addProvider(new ExpressionDataSourceProvider());
            if (bl) {
                new JSynopticBatch(plugins, vector);
            } else {
                jProgressBar.setValue(50);
                jLabel.setText(messageWriter.print0args("buildingGUI"));
                new JSynoptic(jProgressBar, plugins, vector);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(-1);
        }
    }

    private static void displayError(boolean bl, JLabel jLabel, String string) {
        if (bl) {
            System.out.println(messageWriter.print0args(string));
        } else {
            jLabel.setText(messageWriter.print0args(string));
        }
    }

    private static void displayError(boolean bl, JLabel jLabel, String string, Object object) {
        if (bl) {
            System.out.println(messageWriter.print1args(string, object));
        } else {
            jLabel.setText(messageWriter.print1args(string, object));
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        barFrame = null;
    }
}

