/*
 * Decompiled with CFR 0.152.
 */
package jsynoptic.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GraphicsEnvironment;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.print.PrinterJob;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.Iterator;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JProgressBar;
import javax.swing.JSplitPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.filechooser.FileFilter;
import javax.swing.text.JTextComponent;
import jsynoptic.base.Plugin;
import jsynoptic.builtin.Builtin;
import jsynoptic.ui.AggregateFileFilter;
import jsynoptic.ui.FiledDesktopCardPanel;
import jsynoptic.ui.LongAction;
import jsynoptic.ui.PluginLookup;
import jsynoptic.ui.Run;
import jsynoptic.ui.ShapesContainer;
import jsynoptic.ui.SourcePanel;
import simtools.data.DataSource;
import simtools.data.DataSourceCollection;
import simtools.data.DataSourcePool;
import simtools.diagram.DiagramClipboard;
import simtools.diagram.DiagramClipboardListener;
import simtools.diagram.DiagramComponent;
import simtools.diagram.DiagramSelection;
import simtools.diagram.DiagramSelectionListener;
import simtools.shapes.AbstractShape;
import simtools.ui.BasicMessageWriter;
import simtools.ui.DesktopCardPanelListener;
import simtools.ui.MenuResourceBundle;
import simtools.ui.PrintDialog;
import simtools.ui.ResourceFinder;
import simtools.ui.UserProperties;

public class JSynoptic
extends JFrame
implements ActionListener,
DesktopCardPanelListener,
DiagramClipboardListener,
DiagramSelectionListener {
    public static MenuResourceBundle resources = ResourceFinder.getMenu(class$jsynoptic$ui$JSynoptic == null ? (class$jsynoptic$ui$JSynoptic = JSynoptic.class$("jsynoptic.ui.JSynoptic")) : class$jsynoptic$ui$JSynoptic);
    public static BasicMessageWriter messageWriter = ResourceFinder.getMessages(class$jsynoptic$ui$JSynoptic == null ? (class$jsynoptic$ui$JSynoptic = JSynoptic.class$("jsynoptic.ui.JSynoptic")) : class$jsynoptic$ui$JSynoptic);
    public static JSynoptic gui = null;
    public static Vector colorMappers;
    public static Vector textMappers;
    public static Vector imageMappers;
    protected FiledDesktopCardPanel desktopCardPanel;
    protected SourcePanel sourcePanel;
    protected Vector plugins;
    protected static UserProperties userProperties;
    protected int untitledDocumentNumber;
    protected Action aCut;
    protected Action aCopy;
    protected Action aPaste;
    protected Action aRemove;
    protected Action aFullScreen;
    protected JFrame aboutFrame;
    protected JMenuItem miNew;
    protected JMenuItem miOpen;
    protected JMenuItem miClose;
    protected JMenuItem miSave;
    protected JMenuItem miSaveAs;
    protected JMenuItem miPrint;
    protected JMenuItem miExit;
    protected JMenuItem miFindPlugins;
    protected JMenuItem miChooseLanguage;
    protected JMenuItem miAbout;
    protected JButton bNew;
    protected JButton bOpen;
    protected JButton bSave;
    protected JButton bPrint;
    protected JButton bAdjust;
    protected JButton bAlign;
    protected JToggleButton tbGridDisplay;
    protected JComboBox cbxGrid;
    protected JComboBox cbxZoom;
    protected JSplitPane splitPane;
    protected JToolBar toolbar;
    protected JLabel status;
    protected TimerTask cleanStatusTask;
    protected Timer cleanStatusTimer;
    protected long statusDelay;
    protected JFileChooser openFileChooser;
    protected JFileChooser saveFileChooser;
    protected JFileChooser fileChooser;
    protected File currentPath;
    protected FileFilter currentFileFilter;
    public Vector lockedShapes;
    private int fileSaveSemaphoreCounter;
    private int fileOpenSemaphoreCounter;
    private int printSemaphoreCounter;
    protected static String propW;
    protected static String propH;
    protected static String propSplit;
    protected static String propPath;
    protected static int propWDefault;
    protected static int propHDefault;
    protected static int propSplitDefault;
    protected static String propPathDefault;
    static /* synthetic */ Class class$jsynoptic$ui$JSynoptic;

    public JSynoptic(JProgressBar jProgressBar, Vector vector, Vector vector2) {
        super("JSynoptic");
        Plugin plugin;
        int n;
        gui = this;
        this.plugins = vector == null ? new Vector() : vector;
        this.untitledDocumentNumber = 0;
        this.fileSaveSemaphoreCounter = 0;
        this.fileOpenSemaphoreCounter = 0;
        this.printSemaphoreCounter = 0;
        this.openFileChooser = null;
        this.saveFileChooser = null;
        this.currentPath = null;
        this.currentFileFilter = null;
        this.lockedShapes = new Vector();
        this.aboutFrame = null;
        this.sourcePanel = new SourcePanel(DataSourcePool.global);
        for (n = 0; n < vector.size(); ++n) {
            plugin = (Plugin)vector.get(n);
            if (plugin == null) continue;
            plugin.newSourceComponent(this.sourcePanel);
        }
        jProgressBar.setValue(65);
        this.desktopCardPanel = new FiledDesktopCardPanel(true);
        this.createActions();
        this.setMenuBar();
        this.setToolBar();
        jProgressBar.setValue(70);
        this.setSelectionEditEnabled(false);
        this.setPasteEnabled(false);
        this.setDiagramComponentSpecificsEnabled(false);
        this.desktopCardPanel.addListener(this);
        jProgressBar.setValue(75);
        for (n = 0; n < vector.size(); ++n) {
            plugin = (Plugin)vector.get(n);
            if (plugin == null) continue;
            plugin.newDesktopComponent(this.desktopCardPanel);
        }
        this.newComponent();
        jProgressBar.setValue(80);
        this.splitPane = new JSplitPane(1, this.sourcePanel, this.desktopCardPanel);
        this.getContentPane().add("Center", this.splitPane);
        jProgressBar.setValue(85);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(0));
        jPanel.setBorder(BorderFactory.createLoweredBevelBorder());
        this.status = new JLabel();
        jPanel.add(this.status);
        this.getContentPane().add("South", jPanel);
        this.cleanStatusTask = null;
        this.cleanStatusTimer = new Timer();
        this.statusDelay = resources.getLongValue("statusDelayMilliSec");
        jProgressBar.setValue(90);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                JSynoptic.this.exit();
            }
        });
        DiagramClipboard.create();
        DiagramClipboard.get().addListener(this);
        jProgressBar.setValue(95);
        this.pack();
        this.cbxGrid.setMaximumSize(new Dimension(this.bPrint.getWidth() * 3, this.bPrint.getHeight()));
        this.cbxZoom.setMaximumSize(new Dimension(this.bPrint.getWidth() * 3, this.bPrint.getHeight()));
        if (vector2.size() > 0) {
            this.status.setText(messageWriter.print0args("processingCommands"));
        } else {
            this.status.setText(messageWriter.print0args("welcomeMessage"));
        }
        this.loadProperties();
        jProgressBar.setValue(100);
        this.doLayout();
        if (Run.barFrame != null) {
            Run.barFrame.setVisible(false);
        } else {
            jProgressBar.setVisible(false);
        }
        this.show();
        this.processCommands(vector2);
        jPanel.setMinimumSize(jPanel.getSize());
        jPanel.setPreferredSize(jPanel.getSize());
        JSynoptic.setStatus(messageWriter.print0args("welcomeMessage"));
    }

    protected void exit() {
        this.cleanStatusTimer.cancel();
        this.saveProperties();
        System.exit(0);
    }

    protected void processCommands(Vector vector) {
        if (vector == null) {
            return;
        }
        Iterator iterator = vector.iterator();
        while (iterator.hasNext()) {
            this.processCommand((String)iterator.next());
        }
    }

    protected void processCommand(String string) {
        if (string.startsWith("load ")) {
            File file = new File(string.substring(5));
            Plugin plugin = this.getPluginToProcessFile(file, 1, null);
            if (plugin == null) {
                return;
            }
            plugin.processFile(file, 1);
            return;
        }
    }

    public synchronized void lockFileSave() {
        if (this.fileSaveSemaphoreCounter++ == 0) {
            this.miSave.setEnabled(false);
            this.bSave.setEnabled(false);
            this.miSaveAs.setEnabled(false);
        }
    }

    public synchronized void unlockFileSave() {
        if (--this.fileSaveSemaphoreCounter == 0) {
            this.miSave.setEnabled(true);
            this.bSave.setEnabled(true);
            this.miSaveAs.setEnabled(true);
        }
    }

    public synchronized boolean canSave() {
        return this.fileSaveSemaphoreCounter == 0;
    }

    public synchronized void lockFileOpen() {
        if (this.fileOpenSemaphoreCounter++ == 0) {
            this.miOpen.setEnabled(false);
            this.bOpen.setEnabled(false);
        }
    }

    public synchronized void unlockFileOpen() {
        if (--this.fileOpenSemaphoreCounter == 0) {
            this.miOpen.setEnabled(true);
            this.bOpen.setEnabled(true);
        }
    }

    public synchronized boolean canOpen() {
        return this.fileOpenSemaphoreCounter == 0;
    }

    public synchronized void lockPrint() {
        if (this.printSemaphoreCounter++ == 0) {
            this.miPrint.setEnabled(false);
            this.bPrint.setEnabled(false);
        }
    }

    public synchronized void unlockPrint() {
        if (--this.printSemaphoreCounter == 0) {
            this.miPrint.setEnabled(true);
            this.bPrint.setEnabled(true);
        }
    }

    public synchronized boolean canPrint() {
        return this.printSemaphoreCounter == 0;
    }

    protected void saveProperties() {
        UserProperties userProperties = Run.getProperties();
        userProperties.setInt(propW, this.getWidth());
        userProperties.setInt(propH, this.getHeight());
        userProperties.setInt(propSplit, this.splitPane.getDividerLocation());
        userProperties.setString(propPath, this.currentPath.getAbsolutePath());
        JSynoptic.userProperties.write();
    }

    protected void loadProperties() {
        UserProperties userProperties = Run.getProperties();
        this.setSize(userProperties.getInt(propW, propWDefault), userProperties.getInt(propH, propHDefault));
        this.splitPane.setDividerLocation(userProperties.getInt(propSplit, propSplitDefault));
        this.currentPath = new File(userProperties.getString(propPath, propPathDefault));
        if (!this.currentPath.exists()) {
            this.currentPath = new File(propPathDefault);
        }
        AbstractShape.REFRESH_PERIOD = userProperties.getInt("simtools.shapes.AbstractShape.REFRESH_PERIOD", AbstractShape.REFRESH_PERIOD);
    }

    public void createActions() {
        this.aCut = new AbstractAction(resources.getStringValue("cutAction"), resources.getIcon("cutImage")){

            public void actionPerformed(ActionEvent actionEvent) {
                DiagramComponent diagramComponent = JSynoptic.this.getActiveDiagram();
                if (diagramComponent != null) {
                    diagramComponent.executeSelectionCut();
                }
            }
        };
        this.aCopy = new AbstractAction(resources.getStringValue("copyAction"), resources.getIcon("copyImage")){

            public void actionPerformed(ActionEvent actionEvent) {
                DiagramComponent diagramComponent = JSynoptic.this.getActiveDiagram();
                if (diagramComponent != null) {
                    diagramComponent.executeSelectionCopy();
                }
            }
        };
        this.aPaste = new AbstractAction(resources.getStringValue("pasteAction"), resources.getIcon("pasteImage")){

            public void actionPerformed(ActionEvent actionEvent) {
                DiagramComponent diagramComponent = JSynoptic.this.getActiveDiagram();
                if (diagramComponent != null) {
                    diagramComponent.executeClipboardPaste();
                }
            }
        };
        this.aRemove = new AbstractAction(resources.getStringValue("removeAction")){

            public void actionPerformed(ActionEvent actionEvent) {
                DiagramComponent diagramComponent = JSynoptic.this.getActiveDiagram();
                if (diagramComponent != null) {
                    diagramComponent.executeSelectionDelete();
                }
            }
        };
        this.aFullScreen = new AbstractAction(resources.getStringValue("fullScreen")){

            public void actionPerformed(ActionEvent actionEvent) {
                DiagramComponent diagramComponent = JSynoptic.this.getActiveDiagram();
                if (diagramComponent.isFullScreen()) {
                    diagramComponent.setFullScreen(false);
                } else {
                    diagramComponent.setFullScreen(GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice());
                }
            }
        };
        this.aFullScreen.putValue("AcceleratorKey", resources.getKeyStroke("fullScreenShortcut"));
    }

    public void setMenuBar() {
        JMenuBar jMenuBar = new JMenuBar();
        this.addFileMenu(jMenuBar);
        this.addEditMenu(jMenuBar);
        this.addToolsMenu(jMenuBar);
        Iterator iterator = this.plugins.iterator();
        while (iterator.hasNext()) {
            Plugin plugin = (Plugin)iterator.next();
            plugin.setMenu(jMenuBar);
        }
        jMenuBar.add(this.desktopCardPanel.createMenu(null));
        this.addHelpMenu(jMenuBar);
        this.setJMenuBar(jMenuBar);
    }

    public void setToolBar() {
        this.toolbar = new JToolBar();
        this.addFileButtons(this.toolbar);
        this.toolbar.addSeparator();
        this.addEditButtons(this.toolbar);
        this.toolbar.addSeparator();
        this.bAdjust = resources.getBox("adjust", this);
        this.toolbar.add(this.bAdjust);
        this.bAlign = resources.getBox("align", this);
        this.toolbar.add(this.bAlign);
        this.toolbar.addSeparator();
        this.tbGridDisplay = new JToggleButton(resources.getIcon("gridImage"));
        this.tbGridDisplay.setPreferredSize(new Dimension(22, 22));
        this.tbGridDisplay.addActionListener(this);
        this.tbGridDisplay.setToolTipText(resources.getStringValue("gridButtonTip"));
        this.toolbar.add(this.tbGridDisplay);
        this.cbxGrid = new JComboBox();
        this.cbxGrid.addItem("0");
        this.cbxGrid.addItem("5");
        this.cbxGrid.addItem("10");
        this.cbxGrid.addItem("20");
        this.cbxGrid.addItem("40");
        this.cbxGrid.setSelectedItem("0");
        this.cbxGrid.setEditable(true);
        this.cbxGrid.addActionListener(this);
        this.toolbar.add(this.cbxGrid);
        this.cbxZoom = new JComboBox();
        this.cbxZoom.addItem("500%");
        this.cbxZoom.addItem("200%");
        this.cbxZoom.addItem("150%");
        this.cbxZoom.addItem("100%");
        this.cbxZoom.addItem("75%");
        this.cbxZoom.addItem("50%");
        this.cbxZoom.addItem("25%");
        this.cbxZoom.addItem("10%");
        this.cbxZoom.setSelectedItem("100%");
        this.cbxZoom.setEditable(true);
        this.cbxZoom.addActionListener(this);
        this.toolbar.add(this.cbxZoom);
        this.toolbar.addSeparator();
        Iterator iterator = this.plugins.iterator();
        while (iterator.hasNext()) {
            Plugin plugin = (Plugin)iterator.next();
            plugin.setToolBarItem(this.toolbar);
        }
        this.getContentPane().add("North", this.toolbar);
    }

    public void addFileMenu(JMenuBar jMenuBar) {
        JMenu jMenu = resources.getMenu("file");
        this.miNew = resources.getItem("new", this);
        jMenu.add(this.miNew);
        this.miOpen = resources.getItem("open", this);
        jMenu.add(this.miOpen);
        this.miSave = resources.getItem("save", this);
        jMenu.add(this.miSave);
        this.miSaveAs = resources.getItem("saveAs", this);
        jMenu.add(this.miSaveAs);
        this.miPrint = resources.getItem("print", this);
        jMenu.add(this.miPrint);
        this.miClose = resources.getItem("close", this);
        jMenu.add(this.miClose);
        this.miExit = resources.getItem("exit", this);
        jMenu.add(this.miExit);
        jMenuBar.add(jMenu);
    }

    public void addEditMenu(JMenuBar jMenuBar) {
        JMenu jMenu = resources.getMenu("edit");
        JMenuItem jMenuItem = jMenu.add(this.aCut);
        jMenuItem.setIcon(null);
        KeyStroke keyStroke = resources.getKeyStroke("cutShortcut");
        if (keyStroke != null) {
            jMenuItem.setAccelerator(keyStroke);
        }
        jMenuItem = jMenu.add(this.aCopy);
        jMenuItem.setIcon(null);
        keyStroke = resources.getKeyStroke("copyShortcut");
        if (keyStroke != null) {
            jMenuItem.setAccelerator(keyStroke);
        }
        jMenuItem = jMenu.add(this.aPaste);
        jMenuItem.setIcon(null);
        keyStroke = resources.getKeyStroke("pasteShortcut");
        if (keyStroke != null) {
            jMenuItem.setAccelerator(keyStroke);
        }
        jMenuItem = jMenu.add(this.aRemove);
        jMenuItem.setIcon(null);
        keyStroke = resources.getKeyStroke("removeShortcut");
        if (keyStroke != null) {
            jMenuItem.setAccelerator(keyStroke);
        }
        jMenuBar.add(jMenu);
    }

    public void addFileButtons(JToolBar jToolBar) {
        this.bNew = resources.getBox("new", this);
        jToolBar.add(this.bNew);
        this.bOpen = resources.getBox("open", this);
        jToolBar.add(this.bOpen);
        this.bSave = resources.getBox("save", this);
        jToolBar.add(this.bSave);
        this.toolbar.addSeparator();
        this.bPrint = resources.getBox("print", this);
        jToolBar.add(this.bPrint);
    }

    public void addEditButtons(JToolBar jToolBar) {
        JButton jButton = jToolBar.add(this.aCut);
        jButton.setPreferredSize(new Dimension(22, 22));
        String string = resources.getStringValue("cutTip");
        if (string != null) {
            jButton.setToolTipText(string);
        }
        jButton = jToolBar.add(this.aCopy);
        jButton.setPreferredSize(new Dimension(22, 22));
        string = resources.getStringValue("copyTip");
        if (string != null) {
            jButton.setToolTipText(string);
        }
        jButton = jToolBar.add(this.aPaste);
        jButton.setPreferredSize(new Dimension(22, 22));
        string = resources.getStringValue("pasteTip");
        if (string != null) {
            jButton.setToolTipText(string);
        }
    }

    public void addEditMenu(JPopupMenu jPopupMenu) {
        JMenuItem jMenuItem = jPopupMenu.add(this.aCut);
        jMenuItem.setIcon(null);
        jMenuItem = jPopupMenu.add(this.aCopy);
        jMenuItem.setIcon(null);
        jMenuItem = jPopupMenu.add(this.aPaste);
        jMenuItem.setIcon(null);
        jMenuItem = jPopupMenu.add(this.aRemove);
        jMenuItem.setIcon(null);
    }

    public void addToolsMenu(JMenuBar jMenuBar) {
        JMenu jMenu = resources.getMenu("tools");
        this.miFindPlugins = resources.getItem("findPlugins", this);
        jMenu.add(this.miFindPlugins);
        this.miChooseLanguage = resources.getItem("chooseLanguage", this);
        jMenu.add(this.miChooseLanguage);
        jMenuBar.add(jMenu);
    }

    public void addHelpMenu(JMenuBar jMenuBar) {
        JMenu jMenu = resources.getMenu("help");
        this.miAbout = resources.getItem("about", this);
        jMenu.add(this.miAbout);
        jMenuBar.add(Box.createHorizontalGlue());
        jMenuBar.add(jMenu);
    }

    public SourcePanel getSourcePanel() {
        return this.sourcePanel;
    }

    public Vector getPlugins() {
        return this.plugins;
    }

    public JComponent getActiveComponent() {
        return this.desktopCardPanel.getSelectedComponent();
    }

    public DiagramComponent getActiveDiagram() {
        JComponent jComponent = this.desktopCardPanel.getSelectedComponent();
        if (!(jComponent instanceof DiagramComponent)) {
            return null;
        }
        return (DiagramComponent)jComponent;
    }

    public ShapesContainer getActiveContainer() {
        JComponent jComponent = this.desktopCardPanel.getSelectedComponent();
        if (!(jComponent instanceof ShapesContainer.ShapesComponent)) {
            return null;
        }
        return (ShapesContainer)((ShapesContainer.ShapesComponent)jComponent).getContainer();
    }

    public void addComponent(JComponent jComponent, File file) {
        this.desktopCardPanel.addComponent(jComponent, file);
    }

    public void addComponent(JComponent jComponent) {
        this.addComponent(jComponent, null);
    }

    public void addContainer(ShapesContainer shapesContainer, File file) {
        this.addComponent(shapesContainer.getComponent(), file);
    }

    public void addContainer(ShapesContainer shapesContainer) {
        this.addContainer(shapesContainer, null);
    }

    public void setFile(JComponent jComponent, File file) {
        this.desktopCardPanel.setFile(jComponent, file);
    }

    public FiledDesktopCardPanel getFilePanel() {
        return this.desktopCardPanel;
    }

    public File getFile(JComponent jComponent) {
        return this.desktopCardPanel.getFile(jComponent);
    }

    public void setFile(ShapesContainer shapesContainer, File file) {
        this.setFile(shapesContainer.getComponent(), file);
    }

    public File getFile(ShapesContainer shapesContainer) {
        return this.getFile(shapesContainer.getComponent());
    }

    protected File getFileFromDialog(int n) {
        String string;
        if (n == 2) {
            string = resources.getStringValue("saveDialogText");
            this.fileChooser = this.saveFileChooser;
        } else {
            string = resources.getStringValue("openDialogText");
            this.fileChooser = this.openFileChooser;
        }
        if (this.fileChooser == null) {
            this.fileChooser = new JFileChooser(this.currentPath);
            FileFilter fileFilter = null;
            for (int i = 0; i < this.plugins.size(); ++i) {
                Plugin plugin = (Plugin)this.plugins.get(i);
                FileFilter[] fileFilterArray = plugin.getFileFilters(n);
                if (fileFilterArray == null) continue;
                for (int j = 0; j < fileFilterArray.length; ++j) {
                    this.fileChooser.addChoosableFileFilter(fileFilterArray[j]);
                    if (fileFilter != null) continue;
                    fileFilter = fileFilterArray[j];
                }
            }
            this.fileChooser.setAcceptAllFileFilterUsed(false);
            if (n == 1) {
                AggregateFileFilter aggregateFileFilter = new AggregateFileFilter(this.fileChooser.getChoosableFileFilters());
                this.fileChooser.addChoosableFileFilter(aggregateFileFilter);
                this.fileChooser.setAccessory(new FileChooserAccessory());
            }
            if (fileFilter != null) {
                this.fileChooser.setFileFilter(fileFilter);
            }
            if (n == 2) {
                this.saveFileChooser = this.fileChooser;
            } else {
                this.openFileChooser = this.fileChooser;
            }
        }
        this.fileChooser.setCurrentDirectory(this.currentPath);
        int n2 = this.fileChooser.showDialog(this, string);
        if (n2 != 0) {
            return null;
        }
        this.currentPath = this.fileChooser.getCurrentDirectory();
        this.currentFileFilter = this.fileChooser.getFileFilter();
        if (this.currentFileFilter instanceof AggregateFileFilter) {
            this.currentFileFilter = ((AggregateFileFilter)this.currentFileFilter).getFilterForFile(this.fileChooser.getSelectedFile());
            if (this.currentFileFilter == null) {
                return null;
            }
        }
        return this.fileChooser.getSelectedFile();
    }

    protected Plugin getPluginForFilter(int n, FileFilter fileFilter) {
        if (fileFilter == null) {
            return null;
        }
        for (int i = 0; i < this.plugins.size(); ++i) {
            Plugin plugin = (Plugin)this.plugins.get(i);
            FileFilter[] fileFilterArray = plugin.getFileFilters(n);
            if (fileFilterArray == null) continue;
            for (int j = 0; j < fileFilterArray.length; ++j) {
                if (!fileFilter.equals(fileFilterArray[j])) continue;
                return plugin;
            }
        }
        return null;
    }

    protected Plugin getPluginToProcessFile(File file, int n, FileFilter fileFilter) {
        boolean bl = fileFilter == null ? false : fileFilter.accept(file);
        Plugin plugin = null;
        for (int i = 0; i < this.plugins.size(); ++i) {
            Plugin plugin2 = (Plugin)this.plugins.get(i);
            FileFilter[] fileFilterArray = plugin2.getFileFilters(n);
            if (fileFilterArray == null) continue;
            for (int j = 0; j < fileFilterArray.length; ++j) {
                if (bl && fileFilterArray[j].equals(fileFilter)) {
                    return plugin2;
                }
                if (plugin != null && !(plugin instanceof Builtin) || !fileFilterArray[j].accept(file)) continue;
                plugin = plugin2;
            }
        }
        if (plugin == null) {
            JOptionPane.showMessageDialog(this, messageWriter.print1args("noPluginForFile", file.getName()), resources.getStringValue("unknownFileType"), 0);
            return null;
        }
        return plugin;
    }

    public void open() {
        File file = this.getFileFromDialog(1);
        this.open(file);
    }

    public void open(File file) {
        if (file == null) {
            return;
        }
        Plugin plugin = this.getPluginToProcessFile(file, 1, this.currentFileFilter);
        if (plugin == null) {
            return;
        }
        plugin.processFile(file, 1);
    }

    protected void saveAs(File file) {
        Plugin plugin;
        if (file == null && (file = this.getFileFromDialog(2)) == null) {
            return;
        }
        if (file.getName().indexOf(".") == -1) {
            file = new File(file.getAbsolutePath() + resources.getStringValue("defaultSaveExtension"));
        }
        if ((plugin = this.getPluginToProcessFile(file, 2, this.currentFileFilter)) == null) {
            return;
        }
        plugin.processFile(file, 2);
    }

    void setSelectionEditEnabled(boolean bl) {
        DiagramComponent diagramComponent;
        if (bl && (diagramComponent = this.getActiveDiagram()) != null) {
            DiagramSelection diagramSelection = diagramComponent.getDiagramSelection();
            for (int i = 0; i < this.lockedShapes.size(); ++i) {
                if (!diagramSelection.isSelected((Shape)this.lockedShapes.get(i))) continue;
                bl = false;
                break;
            }
        }
        this.aCut.setEnabled(bl);
        this.aCopy.setEnabled(bl);
        this.aRemove.setEnabled(bl);
    }

    void setPasteEnabled(boolean bl) {
        this.aPaste.setEnabled(bl);
    }

    void setDiagramComponentSpecificsEnabled(boolean bl) {
        this.miPrint.setEnabled(bl);
        this.bPrint.setEnabled(bl);
        this.bAdjust.setEnabled(bl);
        this.tbGridDisplay.setEnabled(bl);
        this.cbxGrid.setEnabled(bl);
        this.cbxZoom.setEnabled(bl);
        this.bAlign.setEnabled(bl);
    }

    public void selectionChanged(DiagramSelection diagramSelection) {
        this.setSelectionEditEnabled(!diagramSelection.isEmpty());
    }

    public void clipboardChanged(DiagramClipboard diagramClipboard) {
        this.setPasteEnabled(!diagramClipboard.isEmpty());
    }

    public void componentSelected(JComponent jComponent) {
        int n;
        if (jComponent == null) {
            return;
        }
        if (!(jComponent instanceof DiagramComponent)) {
            this.setSelectionEditEnabled(false);
            this.setPasteEnabled(false);
            this.setDiagramComponentSpecificsEnabled(false);
            return;
        }
        DiagramComponent diagramComponent = (DiagramComponent)jComponent;
        if (jComponent == null) {
            return;
        }
        DiagramSelection diagramSelection = diagramComponent.getDiagramSelection();
        diagramSelection.addListener(this);
        this.selectionChanged(diagramSelection);
        this.setDiagramComponentSpecificsEnabled(true);
        String string = String.valueOf(diagramComponent.getGrid());
        boolean bl = false;
        for (n = 0; n < this.cbxGrid.getItemCount(); ++n) {
            String string2 = (String)this.cbxGrid.getItemAt(n);
            if (!string.equals(string2)) continue;
            this.cbxGrid.setSelectedIndex(n);
            bl = true;
        }
        if (!bl) {
            this.cbxGrid.getEditor().setItem(string);
        }
        this.tbGridDisplay.setSelected(diagramComponent.getGridDisplay());
        n = (int)(diagramComponent.getZoom() * 100.0);
        string = String.valueOf(n) + "%";
        bl = false;
        for (int i = 0; i < this.cbxZoom.getItemCount(); ++i) {
            String string3 = (String)this.cbxZoom.getItemAt(i);
            if (!string.equals(string3)) continue;
            this.cbxZoom.setSelectedIndex(i);
            bl = true;
        }
        if (!bl) {
            this.cbxZoom.getEditor().setItem(string);
        }
    }

    public void newComponent() {
        String string = messageWriter.print1args("untitledDocNum", new Integer(++this.untitledDocumentNumber));
        ShapesContainer shapesContainer = new ShapesContainer(string);
        this.addContainer(shapesContainer);
        for (int i = 0; i < this.plugins.size(); ++i) {
            Plugin plugin = (Plugin)this.plugins.get(i);
            if (plugin == null) continue;
            plugin.newComponent(shapesContainer.getComponent());
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.miExit) {
            this.exit();
        } else {
            if (actionEvent.getSource() == this.miNew || actionEvent.getSource() == this.bNew) {
                this.newComponent();
                return;
            }
            if (actionEvent.getSource() == this.miSave || actionEvent.getSource() == this.bSave) {
                if (!this.canSave()) {
                    return;
                }
                File file = this.desktopCardPanel.getFile(this.desktopCardPanel.getSelectedIndex());
                this.saveAs(file);
            } else {
                if (actionEvent.getSource() == this.miSaveAs) {
                    if (!this.canSave()) {
                        return;
                    }
                    this.saveAs(null);
                    return;
                }
                if (actionEvent.getSource() == this.miOpen || actionEvent.getSource() == this.bOpen) {
                    if (!this.canOpen()) {
                        return;
                    }
                    this.open();
                    return;
                }
                if (actionEvent.getSource() == this.miClose) {
                    JComponent jComponent = this.desktopCardPanel.getSelectedComponent();
                    if (jComponent == null) {
                        return;
                    }
                    this.desktopCardPanel.removeComponent(jComponent);
                } else {
                    if (actionEvent.getSource() == this.bAdjust) {
                        DiagramComponent diagramComponent = this.getActiveDiagram();
                        if (diagramComponent != null) {
                            diagramComponent.adjust();
                        }
                        return;
                    }
                    if (actionEvent.getSource() == this.bAlign) {
                        DiagramComponent diagramComponent = this.getActiveDiagram();
                        if (diagramComponent != null) {
                            diagramComponent.align();
                        }
                        return;
                    }
                    if (actionEvent.getSource() == this.cbxGrid) {
                        DiagramComponent diagramComponent = this.getActiveDiagram();
                        if (diagramComponent == null) {
                            return;
                        }
                        int n = 0;
                        try {
                            n = Long.decode((String)this.cbxGrid.getSelectedItem()).intValue();
                        }
                        catch (Exception exception) {
                            n = 0;
                        }
                        diagramComponent.setGrid(n);
                        return;
                    }
                    if (actionEvent.getSource() == this.cbxZoom) {
                        DiagramComponent diagramComponent = this.getActiveDiagram();
                        if (diagramComponent == null) {
                            return;
                        }
                        int n = 0;
                        try {
                            String string = (String)this.cbxZoom.getSelectedItem();
                            if (string.endsWith("%")) {
                                string = string.substring(0, string.length() - 1);
                            }
                            n = Long.decode(string).intValue();
                        }
                        catch (Exception exception) {
                            n = 100;
                        }
                        diagramComponent.setZoom((double)n / 100.0);
                        return;
                    }
                    if (actionEvent.getSource() == this.tbGridDisplay) {
                        DiagramComponent diagramComponent = this.getActiveDiagram();
                        if (diagramComponent == null) {
                            return;
                        }
                        diagramComponent.setGridDisplay(this.tbGridDisplay.isSelected());
                    } else if (object == this.miPrint || object == this.bPrint) {
                        if (!this.canPrint()) {
                            return;
                        }
                        DiagramComponent diagramComponent = this.getActiveDiagram();
                        if (diagramComponent == null) {
                            return;
                        }
                        PrintDialog printDialog = new PrintDialog(diagramComponent.toString());
                        printDialog.show();
                        if (!printDialog.getResult()) {
                            return;
                        }
                        PrinterJob printerJob = printDialog.getPrinterJob();
                        diagramComponent.setSelectionPrintMode(printDialog.printSelection());
                        printerJob.setPrintable(diagramComponent, printDialog.getPageFormat());
                        JSynoptic.setStatus(messageWriter.print1args("printingTo", printerJob.getPrintService().getName()));
                        try {
                            printerJob.print();
                        }
                        catch (Exception exception) {
                            JSynoptic.setStatus(messageWriter.print1args("printFailed", exception.getMessage()));
                            exception.printStackTrace();
                        }
                    } else if (actionEvent.getSource() == this.miChooseLanguage) {
                        int n;
                        DefaultListModel<String> defaultListModel = new DefaultListModel<String>();
                        int n2 = resources.getIntValue("languageNumber");
                        String string = Run.getProperties().getString("jsynoptic.language", "");
                        int n3 = -1;
                        for (int i = 0; i < n2; ++i) {
                            defaultListModel.addElement(resources.getStringValue("languageName" + i));
                            if (!resources.getStringValue("languageCode" + i).equals(string)) continue;
                            n3 = i;
                        }
                        JList jList = new JList(defaultListModel);
                        jList.setSelectionMode(0);
                        if (n3 != -1) {
                            jList.setSelectedIndex(n3);
                        }
                        if ((n = JOptionPane.showConfirmDialog(null, jList, resources.getString("chooseLanguageTitle"), 2, -1)) == 0 && jList.getSelectedIndex() != -1) {
                            String string2 = resources.getStringValue("languageCode" + jList.getSelectedIndex());
                            Run.getProperties().setString("jsynoptic.language", string2 != null ? string2 : "");
                        }
                    } else {
                        if (actionEvent.getSource() == this.miFindPlugins) {
                            JSynoptic.setStatus(messageWriter.print0args("lookingForPlugins"));
                            new LongAction(){

                                protected void doAction() {
                                    String string = "";
                                    PluginLookup.addPluginPaths();
                                    userProperties.setString("jsynoptic.class.path", PluginLookup.getClassPath());
                                    Vector vector = PluginLookup.lookup();
                                    Iterator iterator = vector.iterator();
                                    while (iterator.hasNext()) {
                                        String string2 = (String)iterator.next();
                                        if (!string.equals("")) {
                                            string = string + ",";
                                        }
                                        string = string + string2;
                                    }
                                    if (!string.equals("")) {
                                        userProperties.setString("jsynoptic.plugins", string);
                                    }
                                    vector.add(0, " \n" + messageWriter.print0args("foundPlugins") + "\n ");
                                    vector.add(" \n" + messageWriter.print0args("restartForPlugins") + "\n ");
                                    JOptionPane.showMessageDialog(null, vector.toArray(), messageWriter.print0args("Plugins:"), 1);
                                }
                            }.start();
                            return;
                        }
                        if (actionEvent.getSource() == this.miAbout) {
                            if (this.aboutFrame == null) {
                                this.aboutFrame = new JFrame(messageWriter.print1args("aboutTitle", Run.productName));
                                String string = messageWriter.print1args("aboutContent", String.valueOf(Run.productVersion));
                                boolean bl = false;
                                Object object2 = this.plugins.iterator();
                                while (object2.hasNext()) {
                                    Plugin plugin = (Plugin)object2.next();
                                    String string3 = plugin.about();
                                    if (string3 == null) continue;
                                    if (!bl) {
                                        string = string + "<p>" + messageWriter.print0args("Plugins:") + "<ul>";
                                        bl = true;
                                    }
                                    string = string + "<li>" + plugin.about() + "</li>";
                                }
                                if (bl) {
                                    string = string + "</ul></p>";
                                }
                                object2 = new JEditorPane("text/html", string);
                                ((JTextComponent)object2).setEditable(false);
                                this.aboutFrame.getContentPane().add((Component)object2);
                                this.aboutFrame.pack();
                                this.aboutFrame.doLayout();
                            }
                            this.aboutFrame.show();
                            return;
                        }
                    }
                }
            }
        }
    }

    void addLongActions(long l, Object object) {
        block16: {
            Object object2;
            int n;
            block18: {
                block17: {
                    if ((l & 1L) != 0L) {
                        this.lockFileOpen();
                    }
                    if ((l & 2L) != 0L) {
                        this.lockFileSave();
                    }
                    if ((l & 4L) != 0L) {
                        this.lockPrint();
                    }
                    if ((l & 0x10L) != 0L) {
                        DiagramSelection diagramSelection;
                        n = 0;
                        object2 = this.getActiveDiagram();
                        DiagramSelection diagramSelection2 = diagramSelection = object2 == null ? null : ((DiagramComponent)object2).getDiagramSelection();
                        if (object != null) {
                            Object object3;
                            if (object instanceof Shape) {
                                this.lockedShapes.add(object);
                                if (diagramSelection != null && diagramSelection.isSelected((Shape)object)) {
                                    n = 1;
                                }
                            } else if (object instanceof Vector) {
                                Iterator iterator = ((Vector)object).iterator();
                                while (iterator.hasNext()) {
                                    object3 = iterator.next();
                                    if (!(object3 instanceof Shape)) continue;
                                    this.lockedShapes.add(object3);
                                    if (diagramSelection == null || !diagramSelection.isSelected((Shape)object3)) continue;
                                    n = 1;
                                }
                            } else if (object instanceof Object[]) {
                                for (int i = 0; i < ((Object[])object).length; ++i) {
                                    object3 = ((Object[])object)[i];
                                    if (!(object3 instanceof Shape)) continue;
                                    this.lockedShapes.add(object3);
                                    if (diagramSelection == null || !diagramSelection.isSelected((Shape)object3)) continue;
                                    n = 1;
                                }
                            }
                        }
                        if (n != 0) {
                            this.selectionChanged(diagramSelection);
                        }
                    }
                    if ((l & 8L) == 0L || object == null) break block16;
                    if (!(object instanceof DataSource) && !(object instanceof DataSourceCollection)) break block17;
                    this.sourcePanel.getSourceTree().lock(object);
                    break block16;
                }
                if (!(object instanceof Vector)) break block18;
                Iterator iterator = ((Vector)object).iterator();
                while (iterator.hasNext()) {
                    object2 = iterator.next();
                    if (!(object2 instanceof DataSource) && !(object2 instanceof DataSourceCollection)) continue;
                    this.sourcePanel.getSourceTree().lock(object2);
                }
                break block16;
            }
            if (!(object instanceof Object[])) break block16;
            for (n = 0; n < ((Object[])object).length; ++n) {
                object2 = ((Object[])object)[n];
                if (!(object2 instanceof DataSource) && !(object2 instanceof DataSourceCollection)) continue;
                this.sourcePanel.getSourceTree().lock(object2);
            }
        }
    }

    void removeLongActions(long l, Object object) {
        block16: {
            Object object2;
            int n;
            block18: {
                block17: {
                    if ((l & 1L) != 0L) {
                        this.unlockFileOpen();
                    }
                    if ((l & 2L) != 0L) {
                        this.unlockFileSave();
                    }
                    if ((l & 4L) != 0L) {
                        this.unlockPrint();
                    }
                    if ((l & 0x10L) != 0L) {
                        DiagramSelection diagramSelection;
                        n = 0;
                        object2 = this.getActiveDiagram();
                        DiagramSelection diagramSelection2 = diagramSelection = object2 == null ? null : ((DiagramComponent)object2).getDiagramSelection();
                        if (object != null) {
                            Object object3;
                            if (object instanceof Shape) {
                                this.lockedShapes.remove(object);
                                if (diagramSelection != null && diagramSelection.isSelected((Shape)object)) {
                                    n = 1;
                                }
                            } else if (object instanceof Vector) {
                                Iterator iterator = ((Vector)object).iterator();
                                while (iterator.hasNext()) {
                                    object3 = iterator.next();
                                    if (!(object3 instanceof Shape)) continue;
                                    this.lockedShapes.remove(object3);
                                    if (diagramSelection == null || !diagramSelection.isSelected((Shape)object3)) continue;
                                    n = 1;
                                }
                            } else if (object instanceof Object[]) {
                                for (int i = 0; i < ((Object[])object).length; ++i) {
                                    object3 = ((Object[])object)[i];
                                    if (!(object3 instanceof Shape)) continue;
                                    this.lockedShapes.remove(object3);
                                    if (diagramSelection == null || !diagramSelection.isSelected((Shape)object3)) continue;
                                    n = 1;
                                }
                            }
                        }
                        if (n != 0) {
                            this.selectionChanged(diagramSelection);
                        }
                    }
                    if ((l & 8L) == 0L || object == null) break block16;
                    if (!(object instanceof DataSource) && !(object instanceof DataSourceCollection)) break block17;
                    this.sourcePanel.getSourceTree().unlock(object);
                    break block16;
                }
                if (!(object instanceof Vector)) break block18;
                Iterator iterator = ((Vector)object).iterator();
                while (iterator.hasNext()) {
                    object2 = iterator.next();
                    if (!(object2 instanceof DataSource) && !(object2 instanceof DataSourceCollection)) continue;
                    this.sourcePanel.getSourceTree().unlock(object2);
                }
                break block16;
            }
            if (!(object instanceof Object[])) break block16;
            for (n = 0; n < ((Object[])object).length; ++n) {
                object2 = ((Object[])object)[n];
                if (!(object2 instanceof DataSource) && !(object2 instanceof DataSourceCollection)) continue;
                this.sourcePanel.getSourceTree().unlock(object2);
            }
        }
    }

    public void setPath(File file) {
        if (file.isDirectory()) {
            this.currentPath = file;
            return;
        }
        File file2 = file.getParentFile();
        if (file2 == null) {
            return;
        }
        this.currentPath = file2;
    }

    public File getPath() {
        return this.currentPath;
    }

    public static void setStatus(String string) {
        if (gui == null) {
            return;
        }
        if (string == null) {
            string = "";
        }
        if (JSynoptic.gui.cleanStatusTask != null) {
            JSynoptic.gui.cleanStatusTask.cancel();
        }
        JSynoptic.gui.status.setText(string);
        JSynoptic.gui.cleanStatusTask = new TimerTask(){

            public void run() {
                JSynoptic.gui.status.setText("");
                JSynoptic.gui.cleanStatusTask.cancel();
                JSynoptic.gui.cleanStatusTask = null;
            }
        };
        JSynoptic.gui.cleanStatusTimer.schedule(JSynoptic.gui.cleanStatusTask, JSynoptic.gui.statusDelay);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        userProperties = Run.getProperties();
        propW = "jsynoptic.ui.JSynoptic.width";
        propH = "jsynoptic.ui.JSynoptic.height";
        propSplit = "jsynoptic.ui.JSynoptic.split";
        propPath = "jsynoptic.ui.JSynoptic.currentPath";
        propWDefault = 700;
        propHDefault = 500;
        propSplitDefault = propWDefault / 2;
        propPathDefault = System.getProperty("user.dir");
    }

    protected class FileChooserAccessory
    extends JPanel
    implements PropertyChangeListener {
        public FileChooserAccessory() {
            JSynoptic.this.fileChooser.addPropertyChangeListener("fileFilterChanged", this);
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            Plugin plugin;
            if ("fileFilterChanged".equals(propertyChangeEvent.getPropertyName()) && (plugin = JSynoptic.this.getPluginForFilter(1, JSynoptic.this.fileChooser.getFileFilter())) != null) {
                this.removeAll();
                JComponent jComponent = plugin.getOptionPanelForFilter(JSynoptic.this.fileChooser.getFileFilter());
                if (jComponent != null) {
                    this.add(jComponent);
                    jComponent.setVisible(true);
                }
                this.revalidate();
            }
        }
    }
}

