/*
 * Decompiled with CFR 0.152.
 */
package jsynoptic.builtin;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Iterator;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.imageio.ImageIO;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import jsynoptic.builtin.Abstract1DShape;
import jsynoptic.ui.JSynoptic;
import jsynoptic.ui.SourceTree;
import simtools.data.DataInfo;
import simtools.data.DataSource;
import simtools.data.DataSourcePool;
import simtools.data.UnsupportedOperation;
import simtools.ui.ActionCheckBox;
import simtools.ui.BasicMessageWriter;
import simtools.ui.ImageMapper;
import simtools.ui.ImagePreview;
import simtools.ui.ResourceFinder;
import simtools.util.ImageSerializer;

public class ImageShape
extends Abstract1DShape {
    static final long serialVersionUID = 8701487979765549739L;
    public static ResourceBundle resources = ResourceFinder.get(class$jsynoptic$builtin$ImageShape == null ? (class$jsynoptic$builtin$ImageShape = ImageShape.class$("jsynoptic.builtin.ImageShape")) : class$jsynoptic$builtin$ImageShape);
    public static BasicMessageWriter messageWriter = ResourceFinder.getMessages(class$jsynoptic$builtin$ImageShape == null ? (class$jsynoptic$builtin$ImageShape = ImageShape.class$("jsynoptic.builtin.ImageShape")) : class$jsynoptic$builtin$ImageShape);
    protected transient BufferedImage image;
    protected transient BufferedImage dynamicImage = null;
    protected ImageMapper mapper;
    protected transient DataSource source;
    protected transient long index;
    protected transient boolean dirtyImage = false;
    protected File currentFile = null;
    protected boolean autoFit;
    static /* synthetic */ Class class$jsynoptic$builtin$ImageShape;

    public boolean isAutoFit() {
        return this.autoFit;
    }

    public void setAutoFit(boolean bl) {
        this.autoFit = bl;
    }

    public ImageShape(File file, int n, int n2) {
        super(n, n2, 100, 100);
        try {
            this.image = ImageIO.read(file);
            this._w = this.image.getWidth();
            this._h = this.image.getHeight();
        }
        catch (IOException iOException) {
            this.image = null;
        }
    }

    public ImageShape(int n, int n2, int n3, int n4) {
        super(n, n2, n3, n4);
        this.image = null;
    }

    protected Shape getDelegateShape() {
        return new Rectangle(this._ox, this._oy - this._h, this._w - 1, this._h - 1);
    }

    protected void drawHook(Graphics2D graphics2D, boolean bl) {
        BufferedImage bufferedImage;
        if (bl) {
            return;
        }
        BufferedImage bufferedImage2 = bufferedImage = this.dynamicImage != null ? this.dynamicImage : this.image;
        if (bufferedImage != null) {
            graphics2D.drawImage(bufferedImage, this._ox, this._oy - this._h, this._w, this._h, null);
        }
    }

    public Abstract1DShape.PropertiesPanel createPanel() {
        return new ImagePropertiesPanel();
    }

    public void notificationEnd(Object object) {
        if (this.dirtyImage) {
            ImageMapper.ImageFile imageFile;
            boolean bl = false;
            Object object2 = null;
            if (this.mapper != null && (imageFile = (ImageMapper.ImageFile)this.mapper.getMapping(this.source, this.index)) != null) {
                object2 = imageFile.image;
            }
            bl = object2 == null ? this.dynamicImage != null : !object2.equals(this.dynamicImage);
            this.dynamicImage = object2;
            if (bl) {
                int n = this._w;
                int n2 = this._h;
                if (!this.autoFit) {
                    if (this.dynamicImage != null) {
                        this._w = this.dynamicImage.getWidth();
                        this._h = this.dynamicImage.getHeight();
                    } else if (this.image != null) {
                        this._w = this.image.getWidth();
                        this._h = this.image.getHeight();
                    }
                    n = Math.max(n, this._w);
                    n2 = Math.max(n2, this._h);
                }
                this.dirtyRectangle = new Rectangle(this._ox, this._oy - n2, n, n2);
                this.dirty = true;
            }
            this.dirtyImage = false;
        }
        super.notificationEnd(object);
    }

    public void DataSourceIndexRangeChanged(DataSource dataSource, long l, long l2) {
        if (dataSource.equals(this.source)) {
            this.index = l2;
            this.dirtyImage = true;
        }
        super.DataSourceIndexRangeChanged(dataSource, l, l2);
    }

    public void DataSourceValueChanged(DataSource dataSource, long l, long l2) {
        if (dataSource.equals(this.source) && this.index >= l && this.index <= l2) {
            this.dirtyImage = true;
        }
        super.DataSourceValueChanged(dataSource, l, l2);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        DataSourcePool.global.writeDataSource(objectOutputStream, this.source);
        ImageSerializer.write(objectOutputStream, this.image);
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        ImageMapper.ImageFile imageFile;
        objectInputStream.defaultReadObject();
        this.source = DataSourcePool.global.readDataSource(objectInputStream);
        this.image = ImageSerializer.read(objectInputStream);
        if (this.source != null) {
            try {
                this.source.addListener(this);
                this.source.addEndNotificationListener(this);
                this.index = this.source.getLastIndex();
            }
            catch (UnsupportedOperation unsupportedOperation) {
                this.index = 0L;
            }
        }
        if (this.mapper != null && (imageFile = (ImageMapper.ImageFile)this.mapper.getMapping(this.source, this.index)) != null) {
            this.dynamicImage = imageFile.image;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected static class ImageMapperListModel
    extends DefaultListModel {
        ImageMapperListModel() {
            this.fillFromMainList();
        }

        public void update() {
            this.clear();
            this.fillFromMainList();
        }

        protected void fillFromMainList() {
            if (JSynoptic.imageMappers != null) {
                Iterator iterator = JSynoptic.imageMappers.iterator();
                while (iterator.hasNext()) {
                    this.addElement(iterator.next());
                }
            }
        }
    }

    protected class ImagePropertiesPanel
    extends Abstract1DShape.PropertiesPanel {
        protected JLabel cmLabel;
        protected JList cmlist;
        protected JButton cmNew;
        protected JButton cmDelete;
        protected JLabel dsLabel;
        protected SourceTree dstree;
        protected ActionCheckBox cbDynamic;
        protected JLabel lstatic;
        protected JButton bChoose;
        protected JFileChooser fileChooser;
        protected JRadioButton rbFit;
        protected JRadioButton rbResize;
        protected File currentFile;

        public ImagePropertiesPanel() {
            this.setLayout(new BorderLayout());
            this.add((Component)this.createContent(), "Center");
        }

        public JComponent createContent() {
            Box box = Box.createVerticalBox();
            box.add(super.createContent(true, true));
            Box box2 = Box.createHorizontalBox();
            this.rbFit = new JRadioButton(resources.getString("ScaleImageToFitObjectSize"), ImageShape.this.autoFit);
            box2.add(this.rbFit);
            box2.add(Box.createHorizontalGlue());
            box.add(box2);
            box2 = Box.createHorizontalBox();
            this.rbResize = new JRadioButton(resources.getString("ChangeObjectSizeToFitImage"), !ImageShape.this.autoFit);
            box2.add(this.rbResize);
            box2.add(Box.createHorizontalGlue());
            box.add(box2);
            ButtonGroup buttonGroup = new ButtonGroup();
            buttonGroup.add(this.rbFit);
            buttonGroup.add(this.rbResize);
            this.currentFile = ImageShape.this.currentFile;
            box2 = Box.createHorizontalBox();
            box2.add(new JLabel(resources.getString("Image:")));
            this.lstatic = new JLabel();
            box2.add(this.lstatic);
            if (this.currentFile != null) {
                this.lstatic.setText(this.currentFile.getName());
            }
            box2.add(Box.createHorizontalGlue());
            this.bChoose = new JButton(resources.getString("Choose"));
            box2.add(this.bChoose);
            box.add(box2);
            this.bChoose.addActionListener(new ActionListener(this){
                private final /* synthetic */ ImagePropertiesPanel this$1;
                {
                    this.this$1 = imagePropertiesPanel;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    if (this.this$1.fileChooser == null) {
                        this.this$1.fileChooser = new JFileChooser();
                        this.this$1.fileChooser.setAccessory(new ImagePreview(this.this$1.fileChooser));
                    }
                    this.this$1.fileChooser.setSelectedFile(this.this$1.currentFile);
                    int n = this.this$1.fileChooser.showDialog(null, resources.getString("SelectImage"));
                    if (n == 0) {
                        this.this$1.currentFile = this.this$1.fileChooser.getSelectedFile();
                        if (this.this$1.currentFile != null) {
                            try {
                                this.this$1.lstatic.setText(this.this$1.currentFile.getName());
                                BufferedImage bufferedImage = ImageIO.read(this.this$1.currentFile);
                                if (this.this$1.rbResize.isSelected()) {
                                    this.this$1.nfWidth.setValue(bufferedImage.getWidth());
                                    this.this$1.nfHeight.setValue(bufferedImage.getHeight());
                                }
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                        }
                    }
                }
            });
            this.rbResize.addChangeListener(new ChangeListener(this){
                private final /* synthetic */ ImagePropertiesPanel this$1;
                {
                    this.this$1 = imagePropertiesPanel;
                }

                public void stateChanged(ChangeEvent changeEvent) {
                    if (this.this$1.rbResize.isSelected() && this.this$1.currentFile != null) {
                        try {
                            BufferedImage bufferedImage = ImageIO.read(this.this$1.currentFile);
                            this.this$1.nfWidth.setValue(bufferedImage.getWidth());
                            this.this$1.nfHeight.setValue(bufferedImage.getHeight());
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                }
            });
            box2 = Box.createHorizontalBox();
            this.cbDynamic = new ActionCheckBox(this, resources.getString("UseDynamicImages")){
                private final /* synthetic */ ImagePropertiesPanel this$1;
                {
                    this.this$1 = imagePropertiesPanel;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    this.this$1.cmLabel.setEnabled(this.isSelected());
                    this.this$1.dsLabel.setEnabled(this.isSelected());
                    this.this$1.cmlist.setEnabled(this.isSelected());
                    this.this$1.cmNew.setEnabled(this.isSelected());
                    this.this$1.cmDelete.setEnabled(this.isSelected() && this.this$1.cmlist.getSelectedValue() != null);
                    this.this$1.dstree.setEnabled(this.isSelected());
                }
            };
            box2.add(this.cbDynamic);
            box2.add(Box.createHorizontalGlue());
            box.add(box2);
            box2 = Box.createHorizontalBox();
            Box box3 = Box.createVerticalBox();
            this.cmLabel = new JLabel(resources.getString("ChooseAnImageMapper"));
            this.cmLabel.setAlignmentX(0.0f);
            Box box4 = Box.createHorizontalBox();
            box4.add(this.cmLabel);
            box4.add(Box.createHorizontalGlue());
            box3.add(box4);
            ImageMapperListModel imageMapperListModel = new ImageMapperListModel();
            this.cmlist = new JList(imageMapperListModel);
            this.cmlist.setSelectionMode(0);
            this.cmlist.setVisibleRowCount(5);
            JScrollPane jScrollPane = new JScrollPane(this.cmlist);
            box3.add(jScrollPane);
            Box box5 = Box.createHorizontalBox();
            this.cmNew = new JButton(resources.getString("New"));
            box5.add(this.cmNew);
            this.cmDelete = new JButton(resources.getString("Delete"));
            box5.add(this.cmDelete);
            box5.add(Box.createHorizontalGlue());
            box3.add(box5);
            box2.add(box3);
            Box box6 = Box.createVerticalBox();
            this.dsLabel = new JLabel(resources.getString("ChooseADataSource"));
            this.dsLabel.setAlignmentX(0.0f);
            Box box7 = Box.createHorizontalBox();
            box7.add(this.dsLabel);
            box7.add(Box.createHorizontalGlue());
            box6.add(box7);
            this.dstree = new SourceTree(DataSourcePool.global);
            this.dstree.setVisibleRowCount(5);
            JScrollPane jScrollPane2 = new JScrollPane(this.dstree);
            box6.add(jScrollPane2);
            box2.add(box6);
            box.add(box2);
            if (ImageShape.this.mapper == null) {
                this.cbDynamic.setSelected(false);
            } else {
                String string = DataInfo.getId(ImageShape.this.source);
                if (string != null) {
                    this.dstree.setSelectedValueById(string);
                } else {
                    this.dstree.setSelectedValue(ImageShape.this.source);
                }
                this.cmlist.setSelectedValue(ImageShape.this.mapper, true);
                this.cbDynamic.setSelected(true);
            }
            this.cbDynamic.apply();
            this.cmNew.addActionListener(new ActionListener(this, imageMapperListModel){
                private final /* synthetic */ ImageMapperListModel val$listModel;
                private final /* synthetic */ ImagePropertiesPanel this$1;
                {
                    this.this$1 = imagePropertiesPanel;
                    this.val$listModel = imageMapperListModel;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    ImageMapper imageMapper = ImageMapper.createImageMapperDialog(null);
                    if (imageMapper == null) {
                        return;
                    }
                    if (JSynoptic.imageMappers == null) {
                        JSynoptic.imageMappers = new Vector<E>();
                    }
                    if (JSynoptic.imageMappers.contains(imageMapper)) {
                        String[] stringArray = new String[]{messageWriter.print1args("ReplaceExistingImageMapperNamed?", imageMapper.toString())};
                        int n = JOptionPane.showConfirmDialog(this.this$1, stringArray, messageWriter.print0args("MapperAlreadyExists!"), 0);
                        if (n == 0) {
                            int n2 = JSynoptic.imageMappers.indexOf(imageMapper);
                            JSynoptic.imageMappers.set(n2, imageMapper);
                            this.val$listModel.update();
                            this.this$1.cmlist.setSelectedValue(imageMapper, true);
                        }
                        return;
                    }
                    JSynoptic.imageMappers.add(imageMapper);
                    this.val$listModel.update();
                    this.this$1.cmlist.setSelectedValue(imageMapper, true);
                }
            });
            this.cmDelete.addActionListener(new ActionListener(this, imageMapperListModel){
                private final /* synthetic */ ImageMapperListModel val$listModel;
                private final /* synthetic */ ImagePropertiesPanel this$1;
                {
                    this.this$1 = imagePropertiesPanel;
                    this.val$listModel = imageMapperListModel;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    E e = this.this$1.cmlist.getSelectedValue();
                    if (e == null) {
                        return;
                    }
                    if (JSynoptic.imageMappers != null) {
                        JSynoptic.imageMappers.remove(e);
                    }
                    this.val$listModel.update();
                }
            });
            this.cmDelete.setEnabled(false);
            this.cmlist.addListSelectionListener(new ListSelectionListener(this){
                private final /* synthetic */ ImagePropertiesPanel this$1;
                {
                    this.this$1 = imagePropertiesPanel;
                }

                public void valueChanged(ListSelectionEvent listSelectionEvent) {
                    this.this$1.cmDelete.setEnabled(this.this$1.cmlist.getSelectedValue() != null);
                }
            });
            this.cmlist.addMouseListener(new MouseAdapter(this){
                private final /* synthetic */ ImagePropertiesPanel this$1;
                {
                    this.this$1 = imagePropertiesPanel;
                }

                public void mouseClicked(MouseEvent mouseEvent) {
                    if (mouseEvent.getClickCount() == 2) {
                        int n = this.this$1.cmlist.locationToIndex(mouseEvent.getPoint());
                        ((ImageMapper)JSynoptic.imageMappers.get(n)).editDialog(null);
                    }
                }
            });
            return box;
        }

        protected String lineColorChooserTitle() {
            return resources.getString("ChooseTheFrameColor");
        }

        protected String lineColorLabel() {
            return resources.getString("DisplayFrame");
        }

        public void updateProperties() {
            super.updateProperties();
            ImageShape.this.autoFit = this.rbFit.isSelected();
            ImageShape.this.currentFile = this.currentFile;
            if (this.currentFile != null) {
                try {
                    ImageShape.this.image = ImageIO.read(this.currentFile);
                }
                catch (IOException iOException) {
                    ImageShape.this.image = null;
                }
            } else {
                ImageShape.this.image = null;
            }
            if (this.cbDynamic.isSelected()) {
                Object object = this.cmlist.getSelectedValue();
                ImageShape.this.mapper = (ImageMapper)object;
                if (ImageShape.this.source != null) {
                    ImageShape.this.source.removeEndNotificationListener(ImageShape.this);
                    ImageShape.this.source.removeListener(ImageShape.this);
                }
                ImageShape.this.source = null;
                object = this.dstree.getSelectedSourceOrCollection();
                if (object instanceof DataSource) {
                    ImageShape.this.source = (DataSource)object;
                }
                if (ImageShape.this.source != null && ImageShape.this.mapper != null) {
                    try {
                        ImageShape.this.index = ImageShape.this.source.getLastIndex();
                    }
                    catch (UnsupportedOperation unsupportedOperation) {
                        ImageShape.this.index = 0L;
                    }
                    ImageShape.this.source.addListener(ImageShape.this);
                    ImageShape.this.source.addEndNotificationListener(ImageShape.this);
                    ImageMapper.ImageFile imageFile = (ImageMapper.ImageFile)ImageShape.this.mapper.getMapping(ImageShape.this.source, ImageShape.this.index);
                    if (imageFile != null) {
                        ImageShape.this.dynamicImage = imageFile.image;
                    }
                }
            }
        }
    }
}

