// Graphics_error.cpp
//
// Copyright 2011-2013 Roan Trail, Inc.
//
// This file is part of Tovero.
//
// Tovero is free software; you can redistribute it and/or modify it
// under the terms of the GNU Lesser General Public License
// version 2.1 as published by the Free Software Foundation.
//
// Tovero is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// Lesser General Public License for more details.  You should have
// received a copy of the GNU Lesser General Public License along with
// Tovero. If not, see <http://www.gnu.org/licenses/>.

#include <tovero/support/error/Graphics_error.hpp>
#include <tovero/support/common.hpp>
#include <string>

using std::string;
using namespace Roan_trail::Tovero_support;

//
// Constructor/destructor/copy
//

Graphics_error::Graphics_error(const char* file,
                               const char* function,
                               int line,
                               int code,
                               const Error* base_error)
  : Error(file,
          function,
          line,
          code,
          base_error)
{
  postcondition(mf_invariant(false));
}

Graphics_error::Graphics_error(const char* file,
                               const char* function,
                               int line,
                               int code,
                               const string& diagnostic,
                               const string& file_path,
                               const Error* base_error)
  : Error(file,
          function,
          line,
          code,
          base_error)
{
  if ("" != diagnostic)
  {
    error_dictionary()[Error::diagnostic_error_key] = diagnostic;
  }

  if ("" != file_path)
  {
    error_dictionary()[Error::file_path_error_key] = file_path;
  }

  postcondition(mf_invariant(false));
}

//
// Error key
//

const string Graphics_error::database_node_name_error_key = string("database_node_name_error_key");

//
// Protected member functions
//

bool Graphics_error::mf_invariant(bool check_base_class) const
{
  bool return_value = false;

  if ((code() < Graphics_error::none) || (code() > Graphics_error::validation))
  {
    goto exit_point;
  }
  else
  {
    return_value = (!check_base_class || Error::mf_invariant(check_base_class));
  }

 exit_point:

  return return_value;
}
