// Boost_error.hpp
//
// Copyright 2011-2013 Roan Trail, Inc.
//
// This file is part of Tovero.
//
// Tovero is free software; you can redistribute it and/or modify it
// under the terms of the GNU Lesser General Public License
// version 2.1 as published by the Free Software Foundation.
//
// Tovero is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// Lesser General Public License for more details.  You should have
// received a copy of the GNU Lesser General Public License along with
// Tovero. If not, see <http://www.gnu.org/licenses/>.

#ifndef TOVERO_SUPPORT_BOOST_ERROR_HPP_
#define TOVERO_SUPPORT_BOOST_ERROR_HPP_

#include <tovero/support/error/Error.hpp>
#include <string>

namespace boost
{
  namespace system
  {
    class error_code;
  }
}

namespace Roan_trail
{
  namespace Tovero_support
  {
    class Boost_error : public Error
    {
    public:
      // constructor/destructor/copy
      Boost_error(const char* file,
                  const char* function,
                  int line,
                  const boost::system::error_code& ec,
                  const Error* base_error = 0);
      Boost_error(const char* file,
                  const char* function,
                  int line,
                  const std::string& diagnostic,
                  const Error* base_error = 0);
      virtual Boost_error* clone() const { return new Boost_error(*this); }
      // error key constants
      static const std::string program_options_error_key;
      // other
      virtual std::string error_class() const { return "Boost_error"; }
    protected:
      // invariant check
      bool mf_invariant(bool check_base_class = true) const;
    private:
      // prevent compiler from generating
      Boost_error operator=(const Boost_error& e);
    };
  }
}

#endif // TOVERO_SUPPORT_BOOST_ERROR_HPP_
