// common.hpp
//
// Copyright 2011-2013 Roan Trail, Inc.
//
// This file is part of Tovero.
//
// Tovero is free software; you can redistribute it and/or modify it
// under the terms of the GNU Lesser General Public License
// version 2.1 as published by the Free Software Foundation.
//
// Tovero is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// Lesser General Public License for more details.  You should have
// received a copy of the GNU Lesser General Public License along with
// Tovero. If not, see <http://www.gnu.org/licenses/>.

#ifndef TOVERO_SUPPORT_COMMON_HPP_
#define TOVERO_SUPPORT_COMMON_HPP_

#include <cassert>
#include <boost/cstdint.hpp>
#include <boost/static_assert.hpp>

namespace Roan_trail
{
  namespace Tovero_support
  {
#ifdef BOOST_NO_INT64_T
#error This platform is not supported, this software requires a 64 bit integer
#endif

    // typedef aliases for special numerical types
    typedef int64_t Long_int;

    // platform checks (assumptions about hardware)
    BOOST_STATIC_ASSERT((sizeof(int) >= 4) // system has sufficiently large int for our assumptions
                        && "Error, int type needs be at least 4 bytes");
    BOOST_STATIC_ASSERT((sizeof(Long_int) >= 8) // system has sufficiently large "long" int for our assumptions
                        && "Error, long integer type needs be at least 8 bytes");

    // pre/post conditions
#define precondition(cond) assert("precondition failed" && (cond))
#define postcondition(cond) assert("postcondition failed" && (cond))
  }
}

#endif // TOVERO_SUPPORT_COMMON_HPP_
