// Reference_counting_base.cpp
//
// Copyright 2012-2013 Roan Trail, Inc.
//
// This file is part of Tovero.
//
// Tovero is free software; you can redistribute it and/or modify it
// under the terms of the GNU Lesser General Public License
// version 2.1 as published by the Free Software Foundation.
//
// Tovero is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// Lesser General Public License for more details.  You should have
// received a copy of the GNU Lesser General Public License along with
// Tovero. If not, see <http://www.gnu.org/licenses/>.

#include <tovero/support/Reference_counting_base.hpp>
#include <tovero/support/common.hpp>

using namespace Roan_trail::Tovero_support;

//
// Copy
//

Reference_counting_base& Reference_counting_base::operator=(const Reference_counting_base& b)
{
  precondition(mf_invariant(false));

  if (this != &b)
  {
    m_name = b.m_name;
    // don't copy reference count, keep the current one
  }

  postcondition(mf_invariant(false));
  return *this;
}

//
// Reference/unreference
//

void Reference_counting_base::unreference_no_delete() const
{
  precondition(mf_invariant());

  if (m_reference_count)
  {
    --m_reference_count;
  }

  // call the postcondition here even though this function is const
  // because it modifies the reference count
  postcondition(mf_invariant());
}

void Reference_counting_base::unreference() const
{
  precondition(mf_invariant());

  if (m_reference_count)
  {
    --m_reference_count;
    if (!m_reference_count)
    {
      delete this;
    }
  }

  // call the postcondition here even though this function is const
  // because it modifies the reference count
  postcondition(mf_invariant());
}

//
// Protected member functions
//

//
//   Class invariant
//

bool Reference_counting_base::mf_invariant(bool check_base_class) const
{
  static_cast<void>(check_base_class); // avoid unused warning

  bool return_value = false;

  if (m_reference_count < 0)
  {
    goto exit_point;
  }

  return_value = true;
  goto exit_point;

 exit_point:
  return return_value;
}

