// Logger.hpp
//
// Copyright 2012-2013 Roan Trail, Inc.
//
// This file is part of Tovero.
//
// Tovero is free software; you can redistribute it and/or modify it
// under the terms of the GNU Lesser General Public License
// version 2.1 as published by the Free Software Foundation.
//
// Tovero is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// Lesser General Public License for more details.  You should have
// received a copy of the GNU Lesser General Public License along with
// Tovero. If not, see <http://www.gnu.org/licenses/>.

#ifndef TOVERO_SUPPORT_LOGGER_HPP_
#define TOVERO_SUPPORT_LOGGER_HPP_

#include <iomanip>
#include <iostream>

namespace Roan_trail
{
  namespace Tovero_support
  {
    class Error;
    class Error_param;

    class Logger
    {
    public:
      // typedef
      typedef enum
        {
          info = 0,
          message,
          warning,
          error
        }
        Entry_type;
      typedef enum
        {
          quiet = 0,
          normal,
          verbose
        }
        Output_level;
      // constructor/destructor
      Logger();
      // accessors
      std::ostream& output_stream() { return *m_output_stream; }
      const std::ostream& output_stream() const { return *m_output_stream; }
      Output_level output_level() const { return m_output_level; }
      // mutators
      void set_output_stream(std::ostream& output_stream) { m_output_stream = &output_stream; }
      void set_output_level(Output_level level);
      // stream operations
      Logger& operator<<(Entry_type entry);
      template <class T> friend Logger& operator<<(Logger& log, const T& o);
      friend Logger& ::Roan_trail::Tovero_support::operator<<(Logger& log, std::ostream&(*pf)(std::ostream&));
      friend Logger& ::Roan_trail::Tovero_support::operator<<(Logger& log, std::ios_base&(*pf)(std::ostream&));
      // class member functions
      static Logger& default_logger() { return m_default_logger; };
    protected:
      // invariant check
      bool mf_invariant(bool check_base_class = true) const;
    private:
      std::ostream *m_output_stream; // reference only
      Output_level m_output_level;
      Entry_type m_entry_type;
      Entry_type m_entry_threshold;
      bool m_pass_output;
      //
      static Logger m_default_logger;
      //
      bool mf_check_pass_output();
      // prevent the compiler from generating
      Logger(const Logger& manager);
      Logger& operator=(const Logger& manager);
    };

    template <class T> Logger& operator<<(Logger& log, const T& o)
    {
      if (log.m_pass_output)
      {
        *log.m_output_stream << o;
      }

      return log;
    }
  }
}

#endif // TOVERO_SUPPORT_LOGGER_HPP_
