// Triangle_face.hpp
//
// Copyright 2012-2013 Roan Trail, Inc.
//
// This file is part of Tovero.
//
// Tovero is free software; you can redistribute it and/or modify it
// under the terms of the GNU Lesser General Public License
// version 2.1 as published by the Free Software Foundation.
//
// Tovero is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// Lesser General Public License for more details.  You should have
// received a copy of the GNU Lesser General Public License along with
// Tovero. If not, see <http://www.gnu.org/licenses/>.

// Triangle face class, contains three indices into a vertex array
// to specify a triangle face

#ifndef TOVERO_MATH_TRIANGLE_FACE_HPP_
#define TOVERO_MATH_TRIANGLE_FACE_HPP_

#include <tovero/math/geometry/Point.hpp>
#include <cstddef>

namespace Roan_trail
{
  namespace Tovero_math
  {
    class Triangle_face
    {
    public:
      // enum
      //   triangle direction
      enum Triangle_direction_type
        {
          direction_none = 0,
          direction_clockwise,
          direction_counterclockwise
        };
      // constructors
      Triangle_face();
      Triangle_face(size_t index_1,
                    size_t index_2,
                    size_t index_3);
      //   Note: let compiler generate copy constructor, operator=, and destructor
      // accessors/mutators
      size_t index_1() const { return m_index_1; }
      void set_index_1(size_t index) { m_index_1 = index; }
      size_t index_2() const { return m_index_2; }
      void set_index_2(size_t index) { m_index_2 = index; }
      size_t index_3() const { return m_index_3; }
      void set_index_3(size_t index) { m_index_3 = index; }
    private:
      size_t m_index_1;
      size_t m_index_2;
      size_t m_index_3;
    };
  }
}

#endif // TOVERO_MATH_TRIANGLE_FACE_HPP_
