// Transformation.hpp
//
// Copyright 2012-2013 Roan Trail, Inc.
//
// This file is part of Tovero.
//
// Tovero is free software; you can redistribute it and/or modify it
// under the terms of the GNU Lesser General Public License
// version 2.1 as published by the Free Software Foundation.
//
// Tovero is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// Lesser General Public License for more details.  You should have
// received a copy of the GNU Lesser General Public License along with
// Tovero. If not, see <http://www.gnu.org/licenses/>.

#ifndef TOVERO_MATH_TRANSFORMATION_HPP_
#define TOVERO_MATH_TRANSFORMATION_HPP_

#include <tovero/support/Reference_counting_base.hpp>
#include <tovero/math/geometry/Distance.hpp>
#include <tovero/math/geometry/Geometric_tolerances.hpp>
#include <tovero/math/geometry/Matrix.hpp>

namespace Roan_trail
{
  namespace Tovero_math
  {
    class Transformation : public Roan_trail::Tovero_support::Reference_counting_base
    {
    public:
      // constructors/copy
      Transformation();
      explicit Transformation(const Matrix& matrix, const Distance& translation_units = Distance::meter);
      Transformation(const Transformation& transformation);
      Transformation& operator=(const Transformation& t);
      // accessors/mutators
      const Matrix& matrix() const { return *m_matrix; }
      void set_matrix(const Matrix& matrix);
      const Distance& translation_units() const { return *m_translation_units; }
      void set_translation_units(const Distance& units);
      // functions
      void set_rotation(const Unit_vector& axis,
                        const Angle& a,
                        const Geometric_tolerances& tolerances = Geometric_tolerances());
      Transformation& rotate(const Unit_vector& axis,
                             const Angle& a,
                             const Geometric_tolerances& tolerances = Geometric_tolerances());
      void set_translation(const Vector& tv);
      void set_translation(const Distance& tx,
                           const Distance& ty,
                           const Distance& tz);
      Transformation& translate(const Distance& tx,
                                const Distance& ty,
                                const Distance& tz);
      Transformation& translate(const Vector& tv);
      void set_scale(const Unitless& sx,
                     const Unitless& sy,
                     const Unitless& sz);
      Transformation& scale(const Unitless& sx,
                            const Unitless& sy,
                            const Unitless& sz);
      void set_uniform_scale(const Unitless& s);
      Transformation& scale_uniform(const Unitless& s);
    protected:
      // destructor
      virtual ~Transformation();
      // class invariant
      bool mf_invariant(bool check_base_class = true) const;
    private:
      Matrix *m_matrix;
      Distance* m_translation_units;
    };
  }
}

#endif // TOVERO_MATH_TRANSFORMATION_HPP_
