// Solid_member.cpp
//
// Copyright 2012-2013 Roan Trail, Inc.
//
// This file is part of Tovero.
//
// Tovero is free software; you can redistribute it and/or modify it
// under the terms of the GNU Lesser General Public License
// version 2.1 as published by the Free Software Foundation.
//
// Tovero is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// Lesser General Public License for more details.  You should have
// received a copy of the GNU Lesser General Public License along with
// Tovero. If not, see <http://www.gnu.org/licenses/>.

#include <tovero/math/geometry/Solid_member.hpp>
#include <tovero/math/geometry/Solid_operand.hpp>
#include <tovero/math/geometry/Solid_operator.hpp>
#include <tovero/support/common.hpp>
#include <tovero/support/Reference_counting_base.hpp>

using Roan_trail::Tovero_support::Reference_counting_base;
using namespace Roan_trail::Tovero_math;

//
// Constructor/copy
//

Solid_member::Solid_member(Solid_operand& operand, Solid_operator::Solid_operator_type op)
  : Reference_counting_base(),
    m_operand(&operand),
    m_op(op)
{
  m_operand->reference();

  postcondition(mf_invariant(false));
}

Solid_member::Solid_member(Solid& solid, Solid_operator::Solid_operator_type op)
  : Reference_counting_base(),
    m_operand(new Solid_operand(solid)),
    m_op(op)
{
  m_operand->reference();

  postcondition(mf_invariant(false));
}

Solid_member::Solid_member(const Solid_member& m)
  : Reference_counting_base(m)
{
  set_operand(*m.m_operand);
  m_op = m.m_op;

  postcondition(mf_invariant(false));
}

Solid_member& Solid_member::operator=(const Solid_member& m)
{
  precondition(mf_invariant(false));

  if (this != &m)
  {
    Reference_counting_base::operator=(m);
    set_operand(*m.m_operand);
    m_op = m.m_op;
  }

  postcondition(mf_invariant(false));
  return *this;
}

//
// Accessors/mutators
//

void Solid_member::set_operand(Solid_operand& operand)
{
  precondition(mf_invariant());

  if (m_operand != &operand)
  {
    operand.reference();
    m_operand->unreference();
    m_operand = &operand;
  }

  postcondition(mf_invariant());
}

//
// Protected member functions
//

//
//   Destructor
//

Solid_member::~Solid_member()
{
  precondition(mf_invariant(false));

  m_operand->unreference();
}

//
//   Class invariant
//

bool Solid_member::mf_invariant(bool check_base_class) const
{
  static_cast<void>(check_base_class); // avoid unused warning

  bool return_value = false;

  if (!m_operand)
  {
    goto exit_point;
  }

  return_value = (!check_base_class || Reference_counting_base::mf_invariant(check_base_class));
  goto exit_point;

 exit_point:
  return return_value;
}
