// Quantity.hpp
//
// Copyright 2012-2013 Roan Trail, Inc.
//
// This file is part of Tovero.
//
// Tovero is free software; you can redistribute it and/or modify it
// under the terms of the GNU Lesser General Public License
// version 2.1 as published by the Free Software Foundation.
//
// Tovero is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// Lesser General Public License for more details.  You should have
// received a copy of the GNU Lesser General Public License along with
// Tovero. If not, see <http://www.gnu.org/licenses/>.

// Template base class for quantities

#ifndef TOVERO_MATH_QUANTITY_HPP_
#define TOVERO_MATH_QUANTITY_HPP_

namespace Roan_trail
{
  namespace Tovero_math
  {
    class Quantity
    {
    public:
      // constructors
      Quantity() : m_value(0.0) {}
      //  Note: use compiler generated copy constructor and destructor
      // accessors
      double value() const { return m_value; }
      void set_value(double value) { m_value = value; }
      // operators
      bool operator<(const Quantity& q) const { return m_value < q.m_value; }
      bool operator>(const Quantity& q) const { return m_value > q.m_value; }
      bool operator<=(const Quantity& q) const { return m_value <= q.m_value; }
      bool operator>=(const Quantity& q) const { return m_value >= q.m_value; }
      bool operator==(const Quantity& q) const { return m_value == q.m_value; }
      bool operator!=(const Quantity& q) const { return m_value != q.m_value; }
    protected:
      explicit Quantity(double v) : m_value(v) {}
    private:
      double m_value;
    };
  }
}

#endif // TOVERO_MATH_QUANTITY_HPP_
