// Oblique_cylinder.hpp
//
// Copyright 2012-2013 Roan Trail, Inc.
//
// This file is part of Tovero.
//
// Tovero is free software; you can redistribute it and/or modify it
// under the terms of the GNU Lesser General Public License
// version 2.1 as published by the Free Software Foundation.
//
// Tovero is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// Lesser General Public License for more details.  You should have
// received a copy of the GNU Lesser General Public License along with
// Tovero. If not, see <http://www.gnu.org/licenses/>.

// Oblique circular cylinder

#ifndef TOVERO_MATH_OBLIQUE_CYLINDER_HPP_
#define TOVERO_MATH_OBLIQUE_CYLINDER_HPP_

#include <tovero/math/geometry/General_cone_base.hpp>
#include <tovero/math/geometry/Point.hpp>
#include <tovero/math/geometry/Vector.hpp>
#include <string>

namespace Roan_trail
{
  namespace Tovero_support
  {
    class Error_param;
  }

  namespace Tovero_math
  {
    class General_cone;

    class Oblique_cylinder : public General_cone_base
    {
    public:
      // constructor/copy
      //   defaults to a cylinder of radius of 1.0 with the base centered at the origin
      Oblique_cylinder(const std::string& name = "");
      Oblique_cylinder(const Point& base,
                       const Vector& height,
                       const Vector& base_r,
                       const std::string& name = "");
      virtual Solid* clone_solid() const { return new Oblique_cylinder(*this); }
      //   Note: let compiler generate default constructor and operator=
      // accessors/mutators
      const Point& base() const { return m_base; }
      void set_base(const Point& base) { m_base = base; }
      const Vector& height() const { return m_height; }
      void set_height(const Vector& height) { m_height = height; }
      const Vector& base_r() const { return m_base_r; }
      void set_base_r(const Vector& base_r) { m_base_r = base_r; }
      // predicates
      virtual bool is_valid(const Geometric_tolerances& tolerances,
                            Roan_trail::Tovero_support::Error_param& return_error) const;
      // visitor
      virtual Solid_visitor::Visit_result accept(Solid_visitor& visitor) const { return visitor.visit(*this); }
      // other
      virtual std::string solid_class() const { return "Oblique_cylinder"; }
      virtual General_cone& generalize() const;
      virtual Solid& specialize(const Geometric_tolerances& tolerances) const;
    protected:
      // destructor
      virtual ~Oblique_cylinder() {}
    private:
      // solid parameters
      Point m_base;    // base center point
      Vector m_height;
      Vector m_base_r;
    };
  }
}

#endif // TOVERO_MATH_OBLIQUE_CYLINDER_HPP_
