// Shader_visitor.hpp
//
// Copyright 2012-2013 Roan Trail, Inc.
//
// This file is part of Tovero.
//
// Tovero is free software; you can redistribute it and/or modify it
// under the terms of the GNU Lesser General Public License
// version 2.1 as published by the Free Software Foundation.
//
// Tovero is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// Lesser General Public License for more details.  You should have
// received a copy of the GNU Lesser General Public License along with
// Tovero. If not, see <http://www.gnu.org/licenses/>.

// Visitor for Shader subclasses (GOF Visitor Pattern)

#ifndef TOVERO_GRAPHICS_SHADER_VISITOR_HPP_
#define TOVERO_GRAPHICS_SHADER_VISITOR_HPP_

namespace Roan_trail
{
  namespace Tovero_graphics
  {
    class Cook_shader;
    class Light_shader;
    class Phong_shader;
    class Toon_shader;

    class Shader_visitor
    {
    public:
      enum Visit_result
        {
          abort = 0,
          success,
          // prune,
        };
      virtual Visit_result visit(const Cook_shader& shader) { return success; }
      virtual Visit_result visit(const Light_shader& shader) { return success; }
      virtual Visit_result visit(const Phong_shader& shader) { return success; }
      virtual Visit_result visit(const Toon_shader& shader) { return success; }
    };
  }
}

#endif // TOVERO_GRAPHICS_SHADER_VISITOR_HPP_
