// Shader.hpp
//
// Copyright 2012-2013 Roan Trail, Inc.
//
// This file is part of Tovero.
//
// Tovero is free software; you can redistribute it and/or modify it
// under the terms of the GNU Lesser General Public License
// version 2.1 as published by the Free Software Foundation.
//
// Tovero is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// Lesser General Public License for more details.  You should have
// received a copy of the GNU Lesser General Public License along with
// Tovero. If not, see <http://www.gnu.org/licenses/>.

#ifndef TOVERO_GRAPHICS_SHADER_HPP_
#define TOVERO_GRAPHICS_SHADER_HPP_

#include <tovero/support/Reference_counting_base.hpp>
#include <tovero/graphics/base/Shader_visitor.hpp>
#include <string>

namespace Roan_trail
{
  namespace Tovero_graphics
  {
    class Shader : public Roan_trail::Tovero_support::Reference_counting_base
    {
    public:
      // visitor
      virtual Shader_visitor::Visit_result accept(Shader_visitor& visitor) const = 0;
    protected:
      // constructor/destructor/copy
      Shader(const std::string& name = "") : Reference_counting_base(name) {}
      Shader(const Shader& shader) : Reference_counting_base(shader) {}
      inline Shader& operator=(const Shader& shader);
      virtual ~Shader() {}
    };

    //
    // Inline definitions
    //

    inline Shader& Shader::operator=(const Shader& shader)
    {
      if (this != &shader)
      {
        Reference_counting_base::operator=(shader);
      }

      return *this;
    }
  }
}

#endif // TOVERO_GRAPHICS_SHADER_HPP_
