// Phong_shader.hpp
//
// Copyright 2012-2013 Roan Trail, Inc.
//
// This file is part of Tovero.
//
// Tovero is free software; you can redistribute it and/or modify it
// under the terms of the GNU Lesser General Public License
// version 2.1 as published by the Free Software Foundation.
//
// Tovero is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// Lesser General Public License for more details.  You should have
// received a copy of the GNU Lesser General Public License along with
// Tovero. If not, see <http://www.gnu.org/licenses/>.

#ifndef TOVERO_GRAPHICS_PHONG_SHADER_HPP_
#define TOVERO_GRAPHICS_PHONG_SHADER_HPP_

#include <tovero/graphics/base/Shader.hpp>
#include <tovero/math/geometry/Unitless.hpp>
#include <string>

namespace Roan_trail
{
  namespace Tovero_graphics
  {
    class Phong_shader : public Shader
    {
    public:
      // constructors/copy
      Phong_shader(const std::string& name = "");
      Phong_shader(int shine,
                   const Roan_trail::Tovero_math::Unitless& specular,
                   const Roan_trail::Tovero_math::Unitless& diffuse,
                   const Roan_trail::Tovero_math::Unitless& transmitted,
                   const Roan_trail::Tovero_math::Unitless& reflected,
                   const Roan_trail::Tovero_math::Unitless& refractive_index,
                   const Roan_trail::Tovero_math::Unitless& extinction,
                   const std::string& name = "");
      Phong_shader(int shine,
                   const Roan_trail::Tovero_math::Unitless& specular,
                   const Roan_trail::Tovero_math::Unitless& diffuse,
                   const Roan_trail::Tovero_math::Unitless& transmitted,
                   const Roan_trail::Tovero_math::Unitless& reflected,
                   const Roan_trail::Tovero_math::Unitless& refractive_index,
                   const Roan_trail::Tovero_math::Unitless& extinction,
                   const Roan_trail::Tovero_math::Unitless& emission_red,
                   const Roan_trail::Tovero_math::Unitless& emission_green,
                   const Roan_trail::Tovero_math::Unitless& emission_blue,
                   const std::string& name = "");
      Phong_shader(const Phong_shader& shader);
      Phong_shader& operator=(const Phong_shader& shader);
      // accessors/mutators
      int shine() const { return m_shine; }
      void set_shine(int value) { m_shine = value; }
      const Roan_trail::Tovero_math::Unitless& specular() const { return m_specular; }
      void set_specular(const Roan_trail::Tovero_math::Unitless& value) { m_specular = value; }
      const Roan_trail::Tovero_math::Unitless& diffuse() const { return m_diffuse; }
      void set_diffuse(const Roan_trail::Tovero_math::Unitless& value) { m_diffuse = value; }
      const Roan_trail::Tovero_math::Unitless& transmitted() const { return m_transmitted; }
      void set_transmitted(const Roan_trail::Tovero_math::Unitless& value) { m_transmitted = value; }
      const Roan_trail::Tovero_math::Unitless& reflected() const { return m_reflected; }
      void set_reflected(const Roan_trail::Tovero_math::Unitless& value) { m_reflected = value; }
      const Roan_trail::Tovero_math::Unitless& refractive_index() const { return m_refractive_index; }
      void set_refractive_index(const Roan_trail::Tovero_math::Unitless& value) { m_refractive_index = value; }
      const Roan_trail::Tovero_math::Unitless& extinction() const { return m_extinction; }
      void set_extinction(const Roan_trail::Tovero_math::Unitless& value) { m_extinction = value; }
      const Roan_trail::Tovero_math::Unitless& emission_red() const { return m_emission_red; }
      void set_emission_red(const Roan_trail::Tovero_math::Unitless& value) { m_emission_red = value; }
      const Roan_trail::Tovero_math::Unitless& emission_green() const { return m_emission_green; }
      void set_emission_green(const Roan_trail::Tovero_math::Unitless& value) { m_emission_green = value; }
      const Roan_trail::Tovero_math::Unitless& emission_blue() const { return m_emission_blue; }
      void set_emission_blue(const Roan_trail::Tovero_math::Unitless& value) { m_emission_blue = value; }
      // shader presets
      static Phong_shader& plastic();
      static Phong_shader& mirror();
      static Phong_shader& glass();
    private:
      // shader parameters
      int m_shine;
      Roan_trail::Tovero_math::Unitless m_specular;
      Roan_trail::Tovero_math::Unitless m_diffuse;
      Roan_trail::Tovero_math::Unitless m_transmitted;
      Roan_trail::Tovero_math::Unitless m_reflected;
      Roan_trail::Tovero_math::Unitless m_refractive_index;
      // TODO: what are the units for this?
      Roan_trail::Tovero_math::Unitless m_extinction;
      Roan_trail::Tovero_math::Unitless m_emission_red;
      Roan_trail::Tovero_math::Unitless m_emission_green;
      Roan_trail::Tovero_math::Unitless m_emission_blue;
      // visitor
      virtual Shader_visitor::Visit_result accept(Shader_visitor& visitor) const { return visitor.visit(*this); }
    protected:
      virtual ~Phong_shader() {}
    };
  }
}

#endif // TOVERO_GRAPHICS_PHONG_SHADER_HPP_
