// Database.cpp
//
// Copyright 2012-213 Roan Trail, Inc.
//
// This file is part of Tovero.
//
// Tovero is free software; you can redistribute it and/or modify it
// under the terms of the GNU Lesser General Public License
// version 2.1 as published by the Free Software Foundation.
//
// Tovero is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// Lesser General Public License for more details.  You should have
// received a copy of the GNU Lesser General Public License along with
// Tovero. If not, see <http://www.gnu.org/licenses/>.

// TODO: how to avoid loops in database?

#include <tovero/graphics/base/Database.hpp>
#include <tovero/math/geometry/Geometric_tolerances.hpp>
#include <tovero/math/geometry/Solid.hpp>
#include <tovero/math/geometry/Solid_combination_base.hpp>
#include <tovero/math/geometry/Units_mapper.hpp>
#include <tovero/support/Reference_counting_list.hpp>
#include <string>

using std::string;
using Roan_trail::Tovero_support::Reference_counting_list;
using Roan_trail::Tovero_math::Geometric_tolerances;
using Roan_trail::Tovero_math::Solid;
using Roan_trail::Tovero_math::Units_mapper;

using namespace Roan_trail::Tovero_graphics;

//
// Constructor/destructor/initialization
//

Database::Database(const string& title,
                   const Geometric_tolerances& tolerances)
  : m_title(title),
    m_top_solids(new Reference_counting_list<Solid>),
    m_tolerances(tolerances),
    m_units_mapper(new Units_mapper)
{
  postcondition(mf_invariant(false));
}

Database::~Database()
{
  precondition(mf_invariant(false));

  delete m_units_mapper;
  delete m_top_solids;
}

//
// Protected member functions
//

bool Database::mf_invariant(bool check_base_class) const
{
  static_cast<void>(check_base_class); // avoid unused warning

  bool return_value = false;

  if (!m_top_solids
      || !m_units_mapper)
  {
    goto exit_point;
  }

  return_value = true;
  goto exit_point;

 exit_point:
  return return_value;
}
