// Combination_attributes.hpp
//
// Copyright 2012-2013 Roan Trail, Inc.
//
// This file is part of Tovero.
//
// Tovero is free software; you can redistribute it and/or modify it
// under the terms of the GNU Lesser General Public License
// version 2.1 as published by the Free Software Foundation.
//
// Tovero is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// Lesser General Public License for more details.  You should have
// received a copy of the GNU Lesser General Public License along with
// Tovero. If not, see <http://www.gnu.org/licenses/>.

#ifndef TOVERO_GRAPHICS_COMBINATION_ATTRIBUTES_HPP_
#define TOVERO_GRAPHICS_COMBINATION_ATTRIBUTES_HPP_

#include <tovero/support/Reference_counting_base.hpp>

namespace Roan_trail
{
  namespace Tovero_graphics
  {
    class Shader;
    class Color;

    class Combination_attributes : public Roan_trail::Tovero_support::Reference_counting_base
    {
    public:
      // constructors/copy
      Combination_attributes();
      Combination_attributes(Shader *shader,         // Note: referenced, not const
                             int material_code,
                             Color *color,           // Note: referenced, not const
                             bool is_part,
                             bool children_inherit);
      Combination_attributes(const Combination_attributes& attributes);
      Combination_attributes& operator=(const Combination_attributes& attributes);
      // accessors/mutators
      Shader* shader() const { return m_shader; } // Note: referenced, not returned as const
      void set_shader(Shader* shader);
      int material_code() const { return m_material_code; }
      void  set_material_code(int code) { m_material_code = code; }
      Color* color() const { return m_color; } // Note: referenced, not returned as const
      void set_color(Color* color);
      bool is_part() const { return m_is_part; }
      void set_is_part(bool is_part) { m_is_part = is_part; }
      bool children_inherit() const { return m_children_inherit; }
      void set_children_inherit(bool children_inherit) { m_children_inherit = children_inherit; }
    protected:
      // destructor
      virtual ~Combination_attributes();
    private:
      Shader* m_shader;
      int m_material_code;
      Color* m_color;
      bool m_is_part;
      bool m_children_inherit;
    };
  };
}

#endif // TOVERO_GRAPHICS_COMBINATION_ATTRIBUTES_HPP_
