// Combination.hpp
//
// Copyright 2012-2013 Roan Trail, Inc.
//
// This file is part of Tovero.
//
// Tovero is free software; you can redistribute it and/or modify it
// under the terms of the GNU Lesser General Public License
// version 2.1 as published by the Free Software Foundation.
//
// Tovero is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// Lesser General Public License for more details.  You should have
// received a copy of the GNU Lesser General Public License along with
// Tovero. If not, see <http://www.gnu.org/licenses/>.

#ifndef TOVERO_GRAPHICS_COMBINATION_HPP_
#define TOVERO_GRAPHICS_COMBINATION_HPP_

#include <tovero/math/geometry/Solid_combination.hpp>
#include <string>

namespace Roan_trail
{
  namespace Tovoro_math
  {
    class Solid_member;
  }

  namespace Tovero_graphics
  {
    class Combination_attributes;

    class Combination : public Tovero_math::Solid_combination
    {
    public:
      // constructor/copy
      //   Note: list members referenced, not const in list:
      Combination(Combination_attributes* attributes = 0, // Note: referenced, not const
                  const Roan_trail::Tovero_support::Reference_counting_list<Tovero_math::Solid_member>& members
                  = Roan_trail::Tovero_support::Reference_counting_list<Tovero_math::Solid_member>(),
                  const std::string& name = "");
      Combination(Combination_attributes* attributes, // Note: referenced, not const
                  const std::string& name);
      Combination(const std::string& name);
      Combination(const Combination& c);
      Combination& operator=(const Combination& c);
      virtual Solid* clone_solid() const { return new Combination(*this); }
      // accessors/mutators
      // Note: referenced, not returned as const:
      Combination_attributes* attributes() const { return m_attributes; }
      void set_attributes(Combination_attributes* attributes);
      // other
      virtual std::string solid_class() const { return "Combination"; }
    protected:
      // destructor
      virtual ~Combination();
    private:
      Combination_attributes* m_attributes;
    };
  }
}

#endif // TOVERO_GRAPHICS_COMBINATION_HPP_
