// Combination.cpp
//
// Copyright 2012-2013 Roan Trail, Inc.
//
// This file is part of Tovero.
//
// Tovero is free software; you can redistribute it and/or modify it
// under the terms of the GNU Lesser General Public License
// version 2.1 as published by the Free Software Foundation.
//
// Tovero is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// Lesser General Public License for more details.  You should have
// received a copy of the GNU Lesser General Public License along with
// Tovero. If not, see <http://www.gnu.org/licenses/>.

#include <tovero/graphics/base/Combination.hpp>
#include <tovero/graphics/base/Combination_attributes.hpp>
#include <tovero/math/geometry/Solid_combination.hpp>
#include <tovero/math/geometry/Solid_member.hpp>
#include <tovero/support/Reference_counting_list.hpp>
#include <string>

using std::string;
using Roan_trail::Tovero_support::Reference_counting_list;
using Roan_trail::Tovero_math::Solid_combination;
using Roan_trail::Tovero_math::Solid_member;
using namespace Roan_trail::Tovero_graphics;

//
// Constructor/copy
//

Combination::Combination(Combination_attributes* attributes, // referenced, not const
                         const Reference_counting_list<Solid_member>& members,
                         const string& name)
  : Solid_combination(members, name),
    m_attributes(attributes)
{
  if (m_attributes)
  {
    m_attributes->reference();
  }
}

Combination::Combination(Combination_attributes* attributes, // referenced, not const
                         const string& name)
  : Solid_combination(name),
    m_attributes(attributes)
{
  if (m_attributes)
  {
    m_attributes->reference();
  }
}

Combination::Combination(const string& name)
  : Solid_combination(name),
    m_attributes(0)
{
}

Combination::Combination(const Combination& c)
  : Solid_combination(c)
{
  set_attributes(c.m_attributes);
}

Combination& Combination::operator=(const Combination& c)
{
  if (this != &c)
  {
    Solid_combination::operator=(c);
    set_attributes(c.m_attributes);
  }

  return *this;
}

//
// Accessors/mutators
//

void Combination::set_attributes(Combination_attributes* attributes)
{
  if (m_attributes != attributes)
  {
    if (attributes)
    {
      attributes->reference();
    }
    if (m_attributes)
    {
      m_attributes->unreference();
    }
    m_attributes = attributes;
  }
}

//
// Protected member functions
//

//
//   Destructor
//

Combination::~Combination()
{
  if (m_attributes)
  {
    m_attributes->unreference();
  }
}


