<?php // -*- mode: php -*-
/*
 * Slooze PHP Web Photo Album
 * Copyright (c) 2000 Matthew Kendall
 */

// Image sorting
define(SORT_NONE,0);
define(SORT_AVGRATE,1);
define(SORT_NBCLICK_DESC,2);
define(SORT_ENTRYDATE_DESC,3);
define(SORT_FRAMEID,4);
define(SORT_ROLLID,5);
define(SORT_DATE,6);
define(SORT_DATE_DESC,7);
define(SORT_TOPICINDEX,8);

// Permissions
define(READ,'r'); 
define(WRITE,'w'); 
define(DELETE,'d'); 
define(OWNER,'o'); 

// Image quality
define(LOW,0);
define(MEDIUM,1);
define(HIGH,2);

define(NOBODY,0);
define(EVERYBODY,1);

// paper sizes in points
$papers = array(
	'a7' => array(209,298),
	'a6' => array(298,420),
	'a5' => array(420,595),
	'a4' => array(595,842),
	'a3' => array(842,1190),
	'a2' => array(1190,1684),
	'a1' => array(1684,2384),
	'a0' => array(2384,3370));

class Slooze {

  /* Redefine these parameters by deriving your own class */
  var $admin = false;
  var $canSelect = true;
  var $adminComments = true;
  var $allPathsLower = false; /* make all image paths lower-case, no matter their recorded case */
  var $showCommentIPs = false; /* put IP of commenter before comment */
  var $basePath = "./"; /* path to photos directory */
  var $picture_suffix = "-w.jpg";  /* filename suffix for pictures */
  var $thumb_suffix = "-t.jpg";  /* filename suffix for thumbnails */
  var $orig_suffix = ".jpg";  /* filename suffix for full size pictures */
  var $pictureWidth = 700; /* Size of "normal" size pictures */
  var $pictureHeight = 500; /* Size of "normal" size pictures */
  var $thumbSize = 150; /* Size of "normal" size pictures */

  var $ct;               /* container for picture metadata */
  var $uid = 0;		/* UserID of the user */
  var $anonymous;
  var $render;
  var $user;
  var $admin_email= "";
  var $homeURL = ""; /* URL of your site */
  var $output_separator;
  var $selection = array();

  var $jpegtranTested = false; // wether we have tested the availability of jpegtran
  var $haveJpegtran = false;

  var $ctClass = "MySloozeCtSql";   /* store data in RDBMS */
  
  var $needsConfirmation;

  /* public: constructor */
  function Slooze($uid,$initUser=true) {
	  $name = $this->ctClass;
	  $this->ct = new $name;
	  global $output_separator;
	  $this->output_separator = $output_separator;

	  /* Initialize user info */
	  $this->setUser($uid);
	  if ($initUser) {
		  $this->initUser();
	  }

	  global $params;
	  $this->admin = $params['admin'];

	  $this->needsConfirmation = array(
		  'deletePage'=>_('delete a page'),
		  'deleteUser'=>_('delete a user'),
		  'deleteTopic'=>_('delete a topic'),
		  'deleteRoll'=>_('delete a roll'),
		  'deleteGroup'=>_('delete a group'));
  }
  
  function setUser($newuid) {
	  global $auth;
	  if ($newuid != '' && $newuid!='nobody') {
		  $auth->auth['uid'] = $newuid;
		  $this->uid = $newuid;
		  $this->anonymous = false;
	  } else {
		  $auth->auth['uid'] = '';
		  $this->uid = 0;
		  $this->anonymous = true;
		  $this->user['Username'] = 'anonymous';
		  $this->user['Name'] = _('Anonymous');
	  }
  }

  function initUser() {
	  $user = $this->ct->getUser($this->uid);
	  $this->upload = ($user['Upload'] == 't');
	  $this->canSelect = ($user['Selection'] == 't');
	  $this->isAdmin = ($user['Admin'] == 't');
	  $this->user = $user;
	  $this->user['Upload'] = ($this->user['Upload'] == 't');
  }

  function setAdmin($admin) {
	  global $sess, $params;
	  $this->admin = $admin;
	  $params['admin'] = $admin;
  }

  /* public: construct valid inputs from GET or POST variables
   * requires track_vars = on */
  function validateInputs() {	  
	  $this->debug('memory: '.makeSizeString(memory_get_usage()));

	  $cleanvars = array();
	  
	  $vars = count($_POST) > 0 ? $_POST : array();
	  reset($vars);
	  while( list($key, $value) = each($vars) ) {
		  $this->debug("POST $value=$key");
		  if (is_array($value)) {
			  $cleanvars[$key] = $this->validateArrayInput($value);
		  } else {
			  $cleanvars[$key] = $this->validateInput($value);
		  }
	  }

	  $vars = count($_GET) > 0 ? $_GET : array();
	  reset($vars);
	  while( list($key, $value) = each($vars) ) {
		  if (! isset($cleanvars[$key])) {
			  $this->debug("GET $value=$key");
			  if (is_array($value)) {
				  $cleanvars[$key] = $this->validateArrayInput($value);
			  } else {
				  $cleanvars[$key] = $this->validateInput($value);
			  }
		  } else {
			  $this->debug("GET $value=$key SKIPPED");
		  }
	  }

	  return $cleanvars;
  }
  
  /* public: construct valid inputs from GET or POST variables
   * requires track_vars = on */
  function printInputs() {
	  echo "_GET :<br><ul>";
	  $vars = (count($_GET) > 0 ? $_GET : array() );
	  reset($vars);
	  while( list($key, $value) = each($vars) ) {
		  echo "<li>$key => $value</li>";
	  }
	  echo "</ul>";
	  echo "_POST :<br><ul>";
	  $vars = (count($_POST) > 0 ? $_POST : array() );
	  reset($vars);
	  while( list($key, $value) = each($vars) ) {
		  echo "<li>$key => $value</li>";
	  }
	  echo "</ul><br>";
  }
  
  /* private: sanitise a single variable */
  function validateInput($value) {
	  if (get_magic_quotes_gpc()) {
		  $value = stripslashes($value);
	  }
	  $value = strip_tags($value);
	  //$value = htmlspecialchars($value);
	  $value = str_replace("\n", " ", $value);
	  $value = str_replace("\r", " ", $value);
	  $value = trim($value);
	  return $value;
  }

  function validateArrayInput($array) {
    $cleanarray = array();
    reset($array);
    while( list($key,$value) =  each($array)) {
      $cleanarray[$key] = $this->validateInput($value);
    }
    return $cleanarray;
  }

  
  /* High-level function to handle database updates */ 
  
  /* private: update the appropriate database table */
  function handleAction(&$vars) {
	  if (isset($vars['action2']))
		  $action = $vars['action2'];
	  else
		  $action = $vars['action'];
	  if ($action) {
		  $this->debug("handleAction($action)");
		  
		  if (array_key_exists($action,$this->needsConfirmation)) {
			  if (isset($vars['Confirm'])) {
			  $this->log(_('Operation confirmed: ').$action);
			  } else if (isset($vars['Abort'])) {
				  $this->log(_('Operation aborted: ').$action);
				  return;
			  } else {
				  redirect(
					  $this->render->urlWithParams(
						  "confirm.php",
						  array('Message'=>$this->needsConfirmation[$action],
								'Target'=>$_SERVER['PHP_SELF'].'?'.$_SERVER['QUERY_STRING'],
								'Params'=>var_export($_POST,true)),
						  '&'));
			  }
		  }
		  
		  $file = "actions/${action}.php";
		  if (file_exists($file)) {
			  require_once($file);
			  $f = "_$action";
			  $f($this,$vars);
		  } else {
			  $this->error(sprintf(_('Cannot handle action: %s'),$action));
		  }
	  }
  }

  function findUser($users,$userID) {
	  reset($users);
	  while( list($key, $user) = each($users) ) {
		  if ($user['UserID'] == $userID) {
			  return true;
		  }
	  }
	  return false;
  }

  function addKeywordsToSelection($typeID, $value) {
	  $this->addKeywords($this->ct->getSelection($this->uid),$typeID,$value);
  }

  function getPictureFilename($picture,$relative=false) {
	  $filename = ($relative ? "" : $this->basePath) . 
		   $picture['RollID'] . "/" . $picture['FrameID'];
      if ($this->allPathsLower) 
		  $filename = strtolower($filename);
	  
	  $filename .= $this->picture_suffix;
	  return $filename; 
  }

  function getOrigFilename($picture,$relative=false) {
	  $filename = ($relative ? "" : $this->basePath) . 
		   $picture['RollID'] . "/" . $picture['FrameID'];
      if ($this->allPathsLower) 
		  $filename = strtolower($filename);
	  
	  $filename .= $this->orig_suffix;
	  return $filename; 
  }

  function getThumbFilename($picture,$relative=false) {
	  $filename = ($relative ? "" : $this->basePath) . 
		   $picture['RollID'] . "/" . $picture['FrameID'];
      if ($this->allPathsLower)
		  $filename = strtolower($filename);
	  
	  $filename .= $this->thumb_suffix;
	  return $filename; 
  }

  function getBestFilename($picture,$quality=HIGH) {
	  $filename = '';
	  if ($quality>=HIGH) {
		  $filename = $this->getOrigFilename($picture);
		  if (file_exists($filename))
			  return $filename;
	  }
	  if ($quality>=MEDIUM) {
		  $filename = $this->getPictureFilename($picture);
		  if (file_exists($filename))
			  return $filename;
	  }
	  return $this->getThumbFilename($picture);
  }

  /**
   * Ensures that a directory exists
   */
  function checkDirectory($dirname) {
	  if (!is_dir($dirname)) {
		  exec("mkdir -p \"$dirname\" -m 775",$dummy,$status);
		  if ($status) {
			  $this->error(sprintf(_('Failed to create directory \'%s\'.'),$dirname));
			  return false;
		  }
	  }
	  return true;
  }

  /* Returns pictures whose image file are missing */
  function getMissingPictures() {
	  $pictures = $this->ct->getPictures('PictureID,RollID,FrameID');
	  $result = array();
	  reset($pictures);
	  while(list($key,$picture) = each($pictures)) {
		  if (!file_exists($this->getPictureFilename($picture))) {
			  $result[] = $picture;
		  }
	  }
	  return $result;
  }

  function fullSelfURL() {
	  return "http://".$_SERVER['SERVER_NAME'].$_SERVER['PHP_SELF'];
  }

  function getRollLink($rollID) {
	  return "<a href=\"{$_SERVER['PHP_SELF']}?RollID=$rollID\">$rollID</a>";
  }

  function getTopicLink($text,$topicID) {
	  return "<a href=\"{$_SERVER['PHP_SELF']}?TopicID=$topicID\">$text</a>";
  }

  function getPictureLink($text,$pictureID,$rollID) {
	  return "<a href=\"{$_SERVER['PHP_SELF']}?PictureID=$pictureID&amp;RollID=$rollID\">$text</a>";
  }

  function error($text) {
	  $this->render->error($text);
  }

  function warn($text) {
	  $this->render->warn($text);
  }

  function show($text) {
	  $this->render->show($text);
  }

  function log($text) {
	  if ($this->render)
		  $this->render->log($text);
	  else
		  echo "$text<br>";
  }

  function debug($text) {
	  $this->render->debug($text);
  }

  function setRender(&$render) {
	  $this->render = &$render;
	  $this->ct->setRender($render);
  }
} /* end of class Slooze */

/* gettext initialization */
function lang_init() {
	global $charset;
	$languages = array("fr.*" => array ("LANG"=>"fr_FR", 
										"LC_ALL" => "fr_FR",
										"charset"=>"iso-8859-1"),
					   "en.*" => array ("LANG"=>"en", 
										"LC_ALL" => "en_US",
										"charset"=>"iso-8859-1"),
					   "de.*" => array ("LANG"=>"de", 
										"LC_ALL" => "de_DE",
										"charset"=>"iso-8859-1"),
					   "pl" => array ("LANG"=>"pl_PL", 
									  "LC_ALL"=>"polish",
									  "charset"=>"iso-8859-2"));
	$acceptLanguage = explode(",",$_SERVER['HTTP_ACCEPT_LANGUAGE']);
	$acceptedLanguage = array();
	reset($acceptLanguage);
	while (list($key,$lang)=each($acceptLanguage)) {
		if (eregi("([-a-z]+) *; *q=([0-9.]*)",$lang,$regs)) {
			$acceptedLanguage[$regs[1]]=$regs[2];
		} else if (eregi("([-a-z]+)",$lang,$regs)) {
			$acceptedLanguage[$regs[1]]="1.0";
		}
	}
	arsort($acceptedLanguage,SORT_NUMERIC);
	reset($acceptedLanguage);
	while (list($lang,$qs)=each($acceptedLanguage)) {
		reset($languages);
		while (list($regexp,$langdef)=each($languages)) {
			if (ereg($regexp,$lang)) {
				//putenv ("LANG=".$langdef["LANG"]);
				//putenv ("LC_MESSAGES=".$langdef["LANG"]);
				$charset = $langdef["charset"];
				header("Content-Type: text/html; charset=".$langdef["charset"]);
				if (! setlocale(LC_ALL,$langdef["LC_ALL"]) && $langdef['LANG']!="en") {
					echo _('setlocale error')."\n";
					echo "LC_ALL=".$langdef["LC_ALL"]."<br>\n";
					echo "LANG=".getenv("LANG");
					/*
					$this->error(_('setlocale error'));
					$this->error("LC_ALL=".$langdef["LC_ALL"]);
					$this->error("LANG=".getenv("LANG"));
					*/
				} else {
					/*
					$this->debug(
						_("Locale set: ").$langdef["LC_ALL"].
						", LANG=".getenv("LANG"));
					$this->debug(sprintf(_('Selected language: %s'),$lang));
					*/
					break 2;
				}
			}
		}
	}
	$domaindir=dirname($_SERVER['SCRIPT_FILENAME'])."/locale";
	bindtextdomain ("tof", $domaindir);
	textdomain ("tof");
}

function makeSize($size) {
	$exp = 0;
	$unit = 1;
	while($size>$unit*1024) {
		$unit *= 1024;
		$exp += 1;
	}
	return array(round($size/$unit,2),$exp);
}

function makeSizeString($size) {
	if ($size==0)
		return '0 '._('byte');
	else if ($size < pow(2,10)) 
		return $size.' '._('bytes');
	else if ($size < pow(2,20)) 
		return round($size / pow(2,10), 2).' '._('Kb');
	else if ($size < pow(2,30)) 
		return round($size / pow(2,20), 2).' '._('Mb');
	else if ($size > pow(2,30)) 
		return round($size / pow(2,30), 2).' '._('Gb');
	else if ($size > pow(2,40)) 
		return round($size / pow(2,40), 2).' '._('Tb');
}

function redirect($url,$die=true) {
	if (!headers_sent()) {
		ob_end_clean();
		header("Location: " . $url);
	}
	printf('<HTML>');
	printf('<META http-equiv="Refresh" content="0;url=%s">', $url);
	printf('<BODY onload="try {self.location.href=\'%s\' } catch(e) {}"><a href="%s">Redirect </a></BODY>', $url, $url);
	printf('</HTML>');
	if ($die)
		die();
}
?>
