// <!-- Begin
show = true;
function getKey(keyStroke) {
   eventChooser = keyStroke.which;
   which = String.fromCharCode(eventChooser).toLowerCase();
   top = document.getElementById("mytop").style;
   main = document.getElementById("main").style;
   var nav;
   if (document.getElementById("nav"))
      nav = document.getElementById("nav").style;
   if (which == 't') {
      if (!show) {
         top.display = "block";
         main.top = savedTop+"px";
         if (nav)
            nav.top = parseInt(savedTop) + 10 + "px";
      } else {
         top.display = "none";
         re = new RegExp("(.*)px");
         savedTop = re.exec(main.top)[1];
         if (nav) {
            if (nav.top != "") {
               match2 = re.exec(nav.top);
               navTop = match2[1];
               nav.top = navTop - savedTop + "px";
            } else {
               nav.top = "0px";
            }
         }
         main.top = "0";
      }
      show = !show;
   }
}
//document.onkeypress = getKey;

count = 0;

function getElt(id) {
   return document.getElementById(id);
}

/** Hide an element */
function undisplayElt(id) {
   getElt(id).style.display = 'none';
}

/** Hide an element */
function hideElt(id) {
   getElt(id).style.visibility = 'hidden';
}

/** Show an element */
function showElt(id) {
   getElt(id).style.visibility = 'visible';
}

function getWidth(id) { 
   return parseInt(getElt(id).offsetWidth);
}

function getHeight(id) { 
   return parseInt(getElt(id).offsetHeight);
}

/** Toggle the visibility of an element */
function toggleVisibility(id) {
   visibility = getElt(id).style.visibility;
   if (visibility == 'hidden') {
      showElt(id);	
      return true;
   } else {
      hideElt(id);
      return false;
   }
}

function toggleTree(topicID) {
   var elt = getElt('T'+topicID);
   if (!elt)
	return;
   var img = getElt('F'+topicID);
   var display = elt.style.display;
   if (display == 'none' || display == '') {
      elt.style.display = 'list-item';
      img.setAttribute('src','expanded_folder.png');
      return true;
   } else {
      elt.style.display = 'none';
      img.setAttribute('src','closed_folder.png');
      return false;
   }
}

function addClass(elt,cl) {
	var classes = elt.getAttribute('class');
	if (classes==null || classes=='null') {
	} else {
		match = new RegExp("(.*) *"+cl+" *(.*)").exec(classes);
		if (!match) {
			elt.setAttribute('class',classes+' '+cl);
		}
	}
}

function removeClass(elt,cl) {
	match = new RegExp("(.*) *"+cl+" *(.*)").exec(elt.getAttribute('class'));
	if (match) {
		elt.setAttribute('class',match[1]+(match[2]!=''?' '+match[2]:''));
	}
}

function isA(elt,cl) {
	return new RegExp(cl).test(elt.getAttribute('class'));
}

/** Show or hide the top bar */
function showHide() {
   main = getElt("main");
   if (toggleVisibility("header")) {
      main.style.top = (getHeight("mytop")-2)+"px";
   } else {
      main.style.top = (getHeight("userinfo")-1)+"px";
   }
}

function clearElt(id) {
   getElt(id).innerHTML = "";
}

/**
 * Returns the first descendant element node with a given tag name, and a
 * given value for an attribute.
 */
function getDescendantWithAttributeValue(elt, tagName, attributeName, attributeValue) {
   var elts = elt.getElementsByTagName(tagName);
   for (var i=0; i<elts.length; i++) {
      if (elts[i].getAttribute(attributeName) == attributeValue) {
         return elts[i];
      }
   }
   return null;
}

function getDescendantsWithAttributeValue(elt, tagName, attributeName, attributeValue) {
   var elts = elt.getElementsByTagName(tagName);
   var descendants = new Array();
   for (var i=0; i<elts.length; i++) {
      if (elts[i].getAttribute(attributeName) == attributeValue) {
         descendants.push(elts[i]);
      }
   }
   return descendants;
}

function getDescendantByClass(elt, tagName, className) {
	return getDescendantWithAttributeValue(elt,tagName,"class",className);
}

function getDescendantsByClass(elt, tagName, className) {
	return getDescendantsWithAttributeValue(elt,tagName,"class",className);
}

/**
 * Selects a topic as parentTopicID and sets the focus on #topicDesc
 */
function addTopic(topicID) {
   var topicSelector = getElt('parentTopicID');
   var options = topicSelector.getElementsByTagName('option');
   for (var i=0; i<options.length; i++) {
      if (options.item(i).getAttribute('value') == topicID) {
         topicSelector.selectedIndex = i;
         break;
      }
   }
   getElt('topicDesc').focus();
}

function getLink(relName) {
   var links = document.getElementsByTagName('link');
   for (var i=0; i<links.length; i++) {
      var link = links.item(i);
      if (link.getAttribute('rel')==relName)
         return link.getAttribute('href');
   }
   return '';
}

var diaporama = false;
document.onkeydown = handleNavigKeys;
function handleNavigKeys(e) {
   if (e.target.tagName == 'TEXTAREA' || e.target.tagName == 'INPUT') {
      return;
   }
   eventChooser = e.which;
   which = String.fromCharCode(eventChooser).toLowerCase();
   code = e.keyCode;
   newURL = '';
   mod = e.shiftKey || diaporama;
   if (mod && (which=='n' || which==' ')) {
      newURL = getLink('next');
   } else if (mod && (code==8 || which=='p'|| which=='b')) {
      newURL = getLink('prev');
   } else if (mod && (which=='h')) {
      newURL = getLink('home');
   } else if (mod && (which=='u')) {
      newURL = getLink('up');
   } else if (mod && (which=='f')) {
      newURL = getLink('first');
   } else if (mod && (which=='l')) {
      newURL = getLink('last');
   } else if (code==27 || (mod && which=='z')) {
      newURL = getLink('normalView');
   }

   if (newURL!='') {
      window.location = newURL;
      return false;
   }
}

function gotoLink(relName) {
   var url = '';
   url = getLink(relName);
   if (url!='') {
      window.location = url;
   }
}

function click(id) {
   document.getElementById(id).click();
}

function clickCB(event) {
    //alert('clickCB '+event);
    var input = event.target.getElementsByTagName('input')[0];
    if (input)
        input.click();
}

/**
 * Install selectPiture handlers on thumb nails
 */
function installCBEvents() {
    var thumbsDiv = getDescendantsWithAttributeValue(document,'div','class','thumb');
    var re = new RegExp('picture.php\\?PictureID=(.*)&Size=thumb','i');
    for (var i=0; i<thumbsDiv.length; i++) {
		var img = thumbsDiv[i].getElementsByTagName('img')[0];
		//var pic = getDescendantWithAttributeValue(thumbsDiv[i],'input','type','checkbox');
		var src = img.getAttribute('src');
		var match = re.exec(src);
		var pictureID;
		if (match) {
	    	pictureID = match[1];
            	img.parentNode.setAttribute('id','pic'+pictureID);
	    	var cb = getDescendantWithAttributeValue(thumbsDiv[i],'input','type','checkbox');
	    	//alert('onClick '+i+": "+cb.getAttribute('type'));
            if (cb) {
	        	cb.setAttribute('onClick','selectPicture('+pictureID+',false)');
	        	cb.setAttribute('id','cb'+pictureID);
            }
			var desc = getDescendantWithAttributeValue(thumbsDiv[i],'div','class','desc');
			if (desc) {
               	desc.parentNode.setAttribute('ondblclick','selectPicture('+pictureID+',true)');
			}
		}
    }
}

function installLabelEvents() {
    var form = document.getElementById('formUpdatePicture');
    if (form) {
	var labels = form.getElementsByTagName('label');
    	for (var i=0; i<labels.length; i++) {
	    var cb = labels[i].getElementsByTagName('input')[0];
	    cb.setAttribute('onchange','togglePictureTopic(event)');
            //labels[i].setAttribute('onClick','togglePictureTopic(event,'+i+')');
	}
    }
}

function togglePictureTopic(event) {
    //alert('Click '+event.target.tagName);
    var cb;
    if (event.target.tagName=='LABEL')
		cb = event.target.getElementsByTagName('input')[0];
    else if (event.target.tagName=='SPAN')
		cb = event.target.parentNode.getElementsByTagName('input')[0];
    else
		cb = event.target;
    var pictureID = cb.form.elements.namedItem('PictureID').value;
    var topicID = cb.value;
    //alert('PictureID='+pictureID+', TopicID='+topicID);
    var action = cb.checked?'addPictureToTopic':'removePictureFromTopic';
    remoteCall("rpc.php?action="+action+"&PictureID="+pictureID+"&TopicID="+topicID+"&context="+context);
}

function installEvents() {
    installLabelEvents();
}

function getFrameDoc(frame) {
    if (frame.contentDocument) {
	// For NS6
		return frame.contentDocument; 
    } else if (frame.contentWindow) {
	// For IE5.5 and IE6
		return frame.contentWindow.document;
    } else if (frame.document) { 
	// For IE5
		return frame.document;
    } else {
		return true;
    }
}

function selectPicture(pictureID,toggleCB) {
    var pic = document.getElementById("pic"+pictureID);
    var cb = document.getElementById("cb"+pictureID);
    var iframe = document.getElementById("RSIFrame");
    if (pic.getAttribute("class").match("selected")) {
        //alert("unselected "+pictureID+"!!!");
		pic.setAttribute("class","pic");
		if (toggleCB && cb) 
			cb.checked = false;
		getFrameDoc(iframe).location.replace(
				"rpc.php?action=removeFromSelection&Ids="+pictureID);
	} else {
		//alert("select "+pictureID+"!!!");
		pic.setAttribute("class","pic selected");
		if (toggleCB && cb) 
			cb.checked = true;
		getFrameDoc(iframe).location.replace(
				"rpc.php?action=addToSelection&Ids="+pictureID);
    }
    return false;
}

function remoteCall(url) {
    var tmp = document.getElementById("myIFrame");
    if (tmp) {
        tmp.parentNode.removeChild(tmp);
    }
    tmp = document.createElement("iframe");
    tmp.setAttribute("id","myIFrame");
/*
    tmp.style.border="0px";
    tmp.style.width="0px";
    tmp.style.height="0px";
*/
    var iframe = document.body.appendChild(tmp);
    var doc;
    if (iframe.contentDocument) {
        // For NS6
        doc = iframe.contentDocument; 
    } else if (iframe.contentWindow) {
        // For IE5.5 and IE6
        doc = iframe.contentWindow.document;
    } else if (iframe.document) {
        // For IE5
        doc = iframe.document;
    } else {
        return true;
    }
    doc.location.replace(url);
    return false;
}
// Local Variables:
// tab-width: 4
// End: -->
