<?php
/* Show a list of users */
function showUsers(&$render,$users) {
	if (count($users)>0) {
		$render->show('<h2>'.sprintf(_('%d users'),count($users)).'</h2>');
		$render->show('<ul>');
		foreach($users as $user) {
			$name = $user['Name'];
			if ($render->admin) 
				$name = '<a href="'.
					$render->selfURL("UserID=".$user['UserID']).'">'.
					$name.' ('.$user['Username'].')</a>';
			$render->show('<li>' . $name . '</li>');
		}
		$render->show("</ul>");
	} else {
		$render->show("<h2>"._('No user in this group')."</h2>");
	}
}

function renderUsers(&$render) {
	require_once("render/form_elements.php");
	require_once("render/navbar.php");

	$render->setView(array('Users'=>'t'));	  
	$users = $render->ct->getUsers();
	$render->setBareTitle(_('Users'));
	$render->show('<div class="normal">');

	$render->show('<div id="formAddUser" class="forms">');
	$render->show('<h2>'._('Add a user').'</h2>');
	showFormAddUser($render);
	$render->show("</div>");

	$render->show('<div class="forms">');
	$render->show('<h2>'._('Recalculate disk usage').'</h2>');
	$render->show('<p>'.
				_('Scan all pictures and compute disk usage for each user.').
				'</p>');
	showFormElementStart($render);
	showFormElementAction($render,'updateDiskUsage');
	showFormElementEnd($render,_('Recalculate'));
	$render->show("</div>");	  

	if ($render->isAdmin) {
		$render->show('<div class="forms">');
		$render->show('<h2>'._('Act as another user').'</h2>');
		showFormElementStart($render);
		showFormElementAuthor($render,$render->uid,_('User:'));
		showFormElementAction($render,'changeUser');
		showFormElementEnd($render,_('Change user'));	  
		$render->show("</div>");
	}

	showUsers($render,$users);
	  
	$render->show("</div>");

	showNavBar($render);
}

/* private: show a form to add a user */
function showFormAddUser(&$render) {
	require_once("render/form_elements.php");
	require_once("render/user.php");
	showFormElementStart($render);
	$render->show('<p>');
	showFormElementText($render,_("Login"),"Username");
	showFormElementUserName($render);
	showFormElementUserEmail($render);
	showFormElementPassword($render,_('Password'),"Password");
	showFormBooleanField($render,"AllowUpload",_("Allow image upload"),false);
	showFormBooleanField($render,"Isadmin",_("Administrator"),false);
	showFormBooleanField($render,"NotifyUser",_("Send a mail to the new user to tell him his login and password"),true);
	showFormElementAction($render,"addUser");
	$render->show('</p>');
	showFormElementEnd($render,_("Add user"));
}
?>