


  function renderMissingFiles() {
	  $pictures = $render->slooze->getMissingPictures();
	  $render->setTitle(_("Missing files"));
	  $render->topTitle .= " [".count($pictures)."]";
	  $render->show('<div class="normal">');
	  $render->show("<ul>");
	  reset($pictures);
	  while( list($key,$picture) = each($pictures)) {
		  $render->show("<li>".$render->slooze->getPictureFilename($picture)."</li>");
	  }
	  $render->show("</ul>");
	  $render->show("</div>");
  }

  /* private: show a single topic title */
  function showTopic(&$render,$topic, $showSummary = true) {
	  if (is_array($topic)) {
		  $render->show('<h2 class="header">'.$topic['Description'] . '</h2>');
		  // if we've got a Summary, show it
		  if ($showSummary)
			  showTopicSummary($render,$topic);
	  }
  }

  /* private: show a list of all the topics in $topics */
  function showTopics($topics) {
	  if (is_array($topics) && count($topics) > 0 ) {
		  $render->show('<ul'.(count($topics)>5?' class="floatLeft"':'').'>');
		  foreach($topics as $topic) {
			  $count = $render->ct->countPicturesInTopic(
				  $topic['TopicID'],
				  $render->uid);
			  if ($render->showEmptyTopics || $count>0) {
				  $render->show(
					  "<li>".
					  "<a href=\"".
					  $render->selfURL("TopicID=".rawurlencode($topic['TopicID'])).
					  "\">".
					  $topic['Description']." [".$count."]</a>".
					  "</li>");
			  }
		  }
		  $render->show("</ul>");
	  }
  }

  /* private: show a list of users */
  function showKeywordTypes( $types ) {
	  $render->show("<h2>"._("Keyword Types")."</h2>");
	  $render->show("<ul>");
	  foreach($types as $type) {
		  $render->show("<li>" . $type['Libelle_fr'] . "</li>");
	  }
	  $render->show("</ul>");
  }

  function showGroup($groupID) {
	  $group = $render->ct->getGroup($groupID);
	  $render->show('<h2>'._('Group').' $groupID  : '.$group['Name'].'</h2>');
  }

  function showFormElementTypeID($typeID = '') {
	  if ($groupID != '') {
		  $render->show("<input type=\"hidden\" name=\"typeID\" value=\"$typeID\">");
	  }
	  else {
		  $render->show(_('Type name:').'<br>');
		  $render->show('<input type="text" name="typeName" ><br>');
	  }
  }

  function showFormElementPickUser() {
	  $allUsers = $render->ct->getUsers();
	  $render->show("<select name=\"userID\">");
	  reset($allUsers);
	  while (list($key, $user) = each($allUsers)) {
		  $render->show("<option value=\"" . $user['UserID'] . "\">" . 
					  $user['Name'] . "</option>");
	  }
	  $render->show("</select><br>");
  }

  /* private: show CommentID form element */
  function showFormElementCommentID($commentID) {
	  $render->show("<input type=\"hidden\" name=\"CommentID\"");
	  $render->show("value=\"" . $commentID . "\" >");
  }

?>