<?php
/**
 * Show a list of thumb images
 */
function showThumbs(
	&$render,
	$pictures, $start, $nbTotPictures, 
	$upLink="", $upTitle="",
	$captionAttribute='Description' ) 
{
	if (is_array($pictures)) {
		require_once("render/form_elements.php");
		require_once("render/navbar.php");
		$actualSize = $render->slooze->thumbSize * $render->thumbScale
			 + (($render->thumbScale>0.5) ? 2*4 : 2*3);
		$borderSize = ($render->thumbScale>0.5) ? 2 : 1;
		$marginRight = 10 * $render->thumbScale;
		$render->style .=
			 "DIV.thumb {\n".
			 "  width: ${actualSize}px;\n".
			 "  margin-right: ${marginRight}px;\n}\n".
			 "DIV.thumb .pic {\n".
			 "  width: ${actualSize}px;\n".
			 "  height: ${actualSize}px;\n}\n".
			 "DIV.thumb .pic IMG {\n".
			 "  border-width: ${borderSize}px;\n".
			 "}\n";
		showFormElementStart($render);
		$count = $render->nbThumbsPerPage;
		$links = array();
		if ($render->displayMode=='diaporama') {
			$links[] = array('URL'=>$render->links['normalView'],
							 'Title'=>_('Back to normal display mode'),
							 'Img'=>'NormalView.png');
		}

		$render->links['home'] = $render->selfURL();
		$links[] = array('URL'=>$render->links['home'],
						 'Title'=>_('Home').' (S-h)',
						 'Img'=>'Home.png');

		// First and previous links
		$first = array('Title'=>_('First').' (S-f)',
					   'Img'=>'First.png');
		$prev = array('Title'=>_('Previous').' (S-p)',
					  'Img'=>'Back.png');
		if ($start>0) {
			$render->links['prev'] = $render->selectURL("Start=".max($start-$count,0));
			$render->links['first'] = $render->selectURL("Start=0");
			$first['URL'] = $render->links['first'];
			$prev['URL'] = $render->links['prev'];
		}
		$links[] = $first;
		$links[] = $prev;
		  
		// Up link
		$up = array('Title'=>_('Up').' (S-u)',
					'Img'=>'Up.png');
		if ($upLink!='') {
			$render->links['up'] = $render->selfURL($upLink);
			$up['URL'] = $render->links['up'];
		}
		$links[] = $up;

		// Next and last links
		$last = array('Title'=>_('Last').' (S-l)',
					  'Img'=>'Last.png');
		$next = array('Title'=>_('Next').' (S-n)',
					  'Img'=>'Forward.png');
		if ($start+$count<$nbTotPictures) {
			$render->links['next'] = 
				 $render->selectURL("Start=".($start+$count));
			if ($count!=0)
				$render->links['last'] = 
					$render->selectURL("Start=".
									   (int)(($nbTotPictures-1)/$count)*$count);
			$next['URL'] = $render->links['next'];
			$last['URL'] = $render->links['last'];
		}
		$links[] = $next;
		$links[] = $last;

		showNavBar($render,$links);

		$render->getUserSelection();
		$render->show('<div class="thumbs">');
		$moveInTopic = 
			 $render->ct->sortMethod==SORT_TOPICINDEX 
			 && $render->hasTopicPerm($render->currentTopicID,WRITE);
		for ($i=0; $i< count($pictures);$i++) {
			showThumb(
				$render,
				$pictures[$i],
				$start+$i,
				$captionAttribute,
				$moveInTopic);
		}
		$render->show('<br style="clear: both"/>');
		$render->show('</div>');// thumbs

		if (!$render->anonymous && count($pictures)>0 && 
		     $render->canSelect && 
		     $render->showThumbCB) 
		{
			showFormElementAction($render,'updateSelection');
			showFormElementEnd($render,_('Update selection'), "", $render->nbThumbsPerPage+1);
		} else {
			showFormElementEnd($render);
		}
		if (!$render->anonymous && $render->canSelect &&
		    $render->currentTopicID!=nil && 
		    count($pictures)>0) 
		{
			require_once("render/form_topicid.php");
			showFormElementStart($render);
			showFormElementTopicID($render,$render->currentTopicID);
			showFormElementAction($render,'selectAllInTopic');
			showFormBooleanField($render,'Recurse',_('Recursive'),false);
			showFormElementEnd($render,_('Select all pictures in current album'));
		}
		$render->showJavaScript('installCBEvents();');
	}
}

/** Show thumbnail for a single picture */
function showThumb(
	&$render,
	$picture, 
	$position,
	$captionAttribute='Description', 
	$moveInTopic = false) 
{
	require_once("render/tooltip.php");
	require_once("render/format_date.php");

	if (is_array($picture) && count($picture) > 0) {
		$fileName = $render->slooze->getThumbFilename($picture);
		if (file_exists($fileName)) {
			$selected = array_key_exists($picture['PictureID'], $render->userSelection);
			// The float way
			$render->show('<div class="thumb">');
			if ($moveInTopic!=false) {
				$render->show('<div class="move">',false);
				//$render->show('|< << < > >> >|');
				if ($position>0)
					$render->showLink(
						$render,
						'<','moveUp',_('move up'),
						array('_PictureID'=>$picture['PictureID'],'_TopicID'=>$moveInTopic));
				if ($position<($render->count-1))
					$render->showLink(
						$render,
						'>','moveDown',_('move down'),
						array('_PictureID'=>$picture['PictureID'],'_TopicID'=>$moveInTopic));
				$render->show('</div>');//move
			}
			$tooltip = getToolTip($render,$picture);
			$render->show("<a href=\"" . $render->selectURL(
				"PictureID=" . $picture['PictureID'] . 
				$render->output_separator."Position=$position")."\" $tooltip>".
						'<div class="pic'.($selected?' selected':'').'">');
			showThumbImg($render,$picture,$picture['Description']);

			$render->show('</div></a>');//pic
			if ($render->showThumbTitle) {
				$render->show('<div class="desc">');
				if (!$render->anonymous && $render->canSelect && $render->showThumbCB) {
					if ($selected) 
						$checked = " checked";
					$tabindex = ($position % $render->nbThumbsPerPage) + 1;
					$render->show(
						'<input name="selection[]" type="checkbox" '.
						'value="'.$picture['PictureID']."\" tabindex=\"$tabindex\"$checked>".
						'<input name="displayedPictures[]" type="hidden" '.
						'value="'.$picture['PictureID']."\"$checked> ");
				}
				$render->show($picture[$captionAttribute]."</div>");//desc
			}
			if ($render->showThumbDate)
				$render->show(
					'<div class ="date">'.formatDate($picture['Date'])."</div>");
			$render->show("</div>");//thumb

		} else {
			$render->error(
				"<a href=\"" .
				$render->selectURL("PictureID=".$picture['PictureID'].
								 $render->output_separator."Position=$position").
				"\">".sprintf(_('File not found : %s'),$fileName)."</a>");
		}
	}
}

function showThumbImg(
	&$render,
	$picture, 
	$alt) 
{
	$scale = $render->thumbScale;

	$fileName = $render->slooze->getThumbFilename($picture);
	if (file_exists($fileName)) {
		/* make img tag with size and caption plus a link to the fullsize picture */
		$size = GetImageSize($fileName);
		$height = $size[1];
		$margin = 2;
		if ($scale>0.5) {
			$border = 2;
		} else {
			$border = 1;
		}
		$top = round(($render->slooze->thumbSize - $height)/2);
		
		$url = $render->urlWithParams(
			"picture.php",
			array('PictureID'=>$picture['PictureID'],
				  'Size'=>'thumb'));
	} else {
		$size[0] = $render->slooze->thumbSize;
		$size[1] = $render->slooze->thumbSize;
		$top = 0;
	}

	$render->show(
		sprintf(
			"<img src=\"%s\" width=\"%d\" height=\"%d\"".
			" alt=\"%s\" style=\"margin-top: %dpx\">",
			$url,
			round($size[0]*$scale),
			round($size[1]*$scale),
			$alt,
			$top*$scale+$margin));
}
?>