<?php
require_once("render/thumb.php");

/** Render a page body for a given search */
function renderSearch(&$render,$search, $start) {
	require_once("render/nav.php");
	require_once("render/form_search.php");
	require_once("render/header.php");
	$render->setSelection(array('Search'=>$search));
	$render->setView(array('Search'=>$search,
						 'Start'=>$start));
	$render->setTitle(_("Search Results")." : ".$search);
	list($count,$pictures) = 
		$render->ct->getPicturesInSearch(
			$search,$render->uid,
			$start,$render->nbThumbsPerPage);
	$render->topTitle .= " ".countString($render,$start,$count);
	$render->show('<div class="normal">');
	showNav($render);
	showThumbs($render,$pictures,$start,$count);
	showFormSearch($render);
	$render->show("</div>");
}

function renderMultipleKeywordSearch(&$render,$values,$matchAll,$start=0) {
	require_once("render/header.php");
	require_once("render/nav.php");
	require_once("render/form_search.php");
	$render->setSelection(array('Keywords'=>join(" ",$values),
								'MatchAll'=>($matchAll?"true":"false")));
	$render->setView(array('Keywords'=>join(" ",$values),
						   'MatchAll'=>($matchAll?"true":"false"),
						   'Start'=>$start));
	list($count,$pictures) = 
		$render->ct->getMultipleKeywordSearch(
			$values,$matchAll,$render->uid,
			$start,$render->nbThumbsPerPage);
	$render->setTitle(_("Keyword search")." : ".join(",",$values));
	$render->topTitle .= " ".countString($render,$start,$count);
	$render->show('<div class="normal">');
	showThumbs($render,$pictures,$start,$count);
	showFormMultipleKeywordSearch($render);
	$render->show("</div>");
}

function renderPictureInMultipleKeywordSearch(
	&$render,
	$pictureID,$keywords,$matchAll,$position) 
{
	require_once("render/nav.php");
	require_once("render/picture.php");
	$render->setSelection(array('Keywords'=>join(" ",$keywords),
								'MatchAll'=>$matchAll?"true":"false"));
	$render->setView(array('Keywords'=>join(" ",$keywords),
						   'MatchAll'=>$matchAll?"true":"false",
						   'PictureID'=>$pictureID,
						   'Position'=>$position));
	if ($pictures = $render->ct->getPictureInMultipleKeywordSearch(
		$pictureID, $keywords, $matchAll,
		$position, $render->uid)) 
	{
		_renderPicture(
			$render,
			$pictures['current'], 
			$pictures['prev'], 
			$pictures['next'], 
			$position,
			$pictures['last']);
	}
}

function renderKeywordSort(&$render,$typeID) {
	require_once("render/navbar.php");
	$render->setView(array('KeywordSort'=>'t',
						 'TypeID'=>$typeID));
	$render->setBareTitle(_("Sort by keyword"));
	$render->showMode = true;
	$render->showNbThumbs = true;
	if ($typeID != 0) {
		$keywords = $render->ct->getKeywordValues($typeID,$render->uid);
	} else {
		$keywords = $render->ct->getKeywordValues('',$render->uid);
	}
	$render->show('<div class="normal">');
	$render->show("<ul>");
	foreach($keywords as $keyword) {
		$render->show(
			"<li><a href=\""
			.$render->selectURL(
				"TypeID=$typeID".$render->output_separator."Keyword=" .
				rawurlencode($keyword['Value'])) 
			."\">" . $keyword['Value'] ." (".$keyword['count'].")</a>");
	}	
	$render->show("</ul>");
	$render->show("</div>");
	showNavBar($render);
}

function renderKeywordSearch(&$render,$typeID,$value,$start=0) {
	require_once("render/thumb.php");
	require_once("render/header.php");
	$render->setSelection(array('Keyword'=>$value,
							  'TypeID'=>$typeID));
	$render->setView(array('Keyword'=>$value,
						 'TypeID'=>$typeID,
						 'Start'=>$start));
	list($count,$pictures) = 
		$render->ct->getKeywordSearch(
			$typeID,$value,$render->uid,
			$start,$render->nbThumbsPerPage);
	$render->setTitle(_("Keyword search")." : ".$value);
	$render->topTitle .= " ".countString($render,$start,$count);
	$render->show('<div class="normal">');
	showThumbs($render,$pictures,$start,$count);
	$render->show("</div>");
}

function renderPictureInKeywordSearch(&$render,$pictureID,$keyword,$typeID,$position) {
	require_once("render/picture.php");
	$render->setSelection(array('Keyword'=>$keyword,
							  'TypeID'=>$typeID));
	$render->setView(array('Keyword'=>$keyword,
						 'TypeID'=>$typeID,
						 'PictureID'=>$pictureID,
						 'Position'=>$position));
	if ($pictures = $render->ct->getPictureInKeywordSearch($pictureID,$keyword,
	    $typeID,$position,$render->uid)) {
		_renderPicture(
			$render,
			$pictures['current'], 
			$pictures['prev'], 
			$pictures['next'], 
			$position,
			$pictures['last']);
	}
}

function renderPictureInSearch(&$render, $pictureID, $search, $position) {
	require("render/picture.php");
	$render->setSelection(array('Search'=>$search));
	$render->setView(array('Search'=>$search,
						 'PictureID'=>$pictureID,
						 'Position'=>$position));
	if ($pictures = $render->ct->getPictureInSearch($pictureID, $search, $position, $render->uid)) {
		_renderPicture(
			$render,
			$pictures['current'], 
			$pictures['prev'], 
			$pictures['next'], 
			$position,
			$pictures['last']);
	}
}
?>