<?php
/* Show the rolls of the current user */
function renderRolls(&$render) {
	require_once("render/form_roll.php");
	require_once("render/navbar.php");
	$render->setView(array('MyRolls'=>''),true);
	$render->setNoDisplayPrefs();
	$render->setTitle(_("My rolls"));
	$render->show('<div class="normal">');
	$render->show('<div class="forms">');
	showFormAddRoll($render);
	$render->show("</div>");
	showRolls($render);
	$render->show("</div>");
	showNavBar($render);
}

/* private: show a list of all rolls */
function showRolls(&$render) {
	$render->show('<ul class="rolls">');
	$rolls = $render->ct->getRolls($render->uid);
	reset($rolls);
	while( list($key, $roll) = each($rolls)) {
		$render->show(
			"<li>" .
			"<a href=\"" . $render->selfURL("RollID=" . $roll['RollID']). "\">" .
			$roll['RollID'] . "</a>" .
			"</li>");
	}
	$render->show('</ul>');
}
?>