<?php
function showNavBar(&$render,$links='') {
	$render->show('<div id="nav">');
	if (!is_array($links)) {
		$render->show('<span>',false);
		showNavImg($render,$render->selfURL(),_('Home').' (S-h)','Home.png');
		$render->show('</span>',false);
	} else{
		foreach($links as $link) {
			$render->show('<span>',false);
			showNavImg($render,$link['URL'],$link['Title'],$link['Img']);
			$render->show('</span>',false);  
		}
	}
	$render->show('</div>');
}

function showNavImg(&$render,$url,$title,$img) {
	if ($url)
		$render->show("<a href=\"$url\">");
	$render->show("<img class=\"nofloat".($url?'':" disabled")."\" src=\"$img\" ".
				"alt=\"$title\" title=\"$title\">");
	if ($url)
		$render->show("</a>");
}

function showPrevNext(&$render,$prev,$next,$position,$last=-1) {
	$links = array();
	if ($render->displayMode=='diaporama') {
		$links[] = array('URL'=>$render->links['normalView'],
						 'Title'=>_('Back to normal display mode'),
						 'Img'=>'NormalView.png');
	}
	$render->links['home'] = $render->selfURL();
	$links[] = array('URL'=>$render->links['home'],
					 'Title'=>_('Home').' (S-h)',
					 'Img'=>'Home.png');

	$firstLink = array('Title'=>_('First').' (S-f)',
					   'Img'=>'First.png');
	if ($position>0) {
		$render->links['first'] = $render->selectURL("Position=0");
		$firstLink['URL'] = $render->links['first'];
	} 
	$links[] = $firstLink;

	$prevLink = array('Title'=>_('Previous').' (S-p)',
					  'Img'=>'Back.png');
	if ($prev) {
		$render->links['prev'] = 
			 $render->selectURL(
				 "PictureID=".$prev['PictureID'].
				 $render->output_separator."Position=".($position-1));
		$prevLink['URL'] = $render->links['prev'];
	}
	$links[] = $prevLink;
	  
	$upLink = array('Title'=>_('Up').' (S-u)',
					'Img'=>'Up.png');
	if ($position!='') {
		$render->links['up'] = 
			 $render->selectURL(
				 "Start=".(int)($position / $render->nbThumbsPerPage)*$render->nbThumbsPerPage);
		$upLink['URL'] = $render->links['up'];
	}
	$links[] = $upLink;

	$nextLink = array('Title'=>_('Next').' (S-n)',
					  'Img'=>'Forward.png');
	if ($next) {
		$render->links['next'] = 
			 $render->selectURL(
				 "PictureID=".$next['PictureID'].
				 $render->output_separator."Position=".($position+1));
		$nextLink['URL'] = $render->links['next'];
	}
	$links[] = $nextLink;

	$lastLink = array('Title'=>_('Last').' (S-l)',
					  'Img'=>'Last.png');
	if ($last>$position) {
		$render->links['last'] = $render->selectURL("Position=$last");
		$lastLink['URL'] = $render->links['last'];
	}
	$links[] = $lastLink;

	showNavBar($render,$links);
}
?>