<?php
/* private: show the groups of the current user */
function renderGroups(&$render) {
	require_once("render/form_group.php");
	require_once("render/navbar.php");
	$render->setView(array('MyGroups'=>""),true);
	$render->htmlTitle = _("My groups");
	$render->setBareTitle(_("My groups"));
	$render->show('<div class="normal">');
	$render->show('<div class="forms">');
	showFormAddGroup($render);
	$render->show('</div><br>');
	$groups = $render->ct->getGroups($render->uid);
	showGroups($render,$groups);
	showNavBar($render);
	$render->show('</div>');
}

/* private: show a list of all the groups in $groups */
function showGroups(&$render,$groups) {
	$render->show('<ul>');
	foreach($groups as $group) {
		$render->show("<li>" .
					"<a href=\"" . $render->selfURL(
						"GroupID=" . $group['GroupID']). "\">" .
					$group['Name'] . "</a> " .
					sprintf(ngettext("(%d user)",
									 "(%d users)",
									 $group['count']),
							$group['count']).
					"</li>");
	}
	$render->show("</ul>");
}

/* private: render a page body for a given group */
function renderGroup(&$render,$groupID) {
	require_once("render/form_group.php");
	require_once("render/users.php");
	require_once("render/navbar.php");
	$render->setView(array('GroupID'=>$groupID));
	if ($groupID) {
		$group = $render->ct->getGroup($groupID);
		if (is_array($group)) {
			$render->setBareTitle(_("Group")." $groupID  : ".$group['Name']);
			$render->show('<div class="normal">');
			$users = $render->ct->getUsersInGroup($groupID);
			if ($render->admin) {
				$render->show('<div class="forms">');
				showFormUpdateGroup($render,$groupID,$users);
				showFormDeleteGroup($render,$groupID);
				$render->show("</div>");
			}
			showUsers($render,$users);
		} else {
			$render->error(
				sprintf(_('Group ID not found : %s'),$groupID));
		}
		$render->show("</div>");
	} else {
		$render->error(_("No group ID provided"));
	}
	showNavBar($render);
}

?>