<?php
require_once("render/form_elements.php");

function showFormAddToFrontPage(&$render,$picture,$topics) {
	$render->show('<h2>'._('Add picture to front page of an album').'</h2>');
	showFormElementStartRPC($render);
	showFormElementPictureID($render,$picture['PictureID'],'_PictureID');
	showFormElementTopics($render,$topics,'_TopicID');
	showFormElementAction($render,'addToFrontPage');
	showFormElementEnd($render,_('Add to front page'));
}
  
/* private: show a form to update a picture */
function showFormUpdatePicture(&$render,$picture,$topics) {
	if ($picture) {
		require_once("render/form_elements.php");
		require_once("render/form_topic.php");
		require_once("render/form_group.php");
		require_once("render/upload.php");

		$render->show('<h2>'._('Update picture').'</h2>');
		showFormElementStart($render,false,'post','','formUpdatePicture');
		showFormElementPictureID($render,$picture['PictureID']);
		showFormElementTopicTree($render,_('Parent topic'),$topics,'');
		if ($render->uid == $picture['Owner']) {
			showFormElementGroupSelector($render,$render->ct->getGroupsForPicture($picture['PictureID']));
		}
		showFormElementDescriptionTextArea($render,$picture['Description']);
		if ($render->uid == $picture['Owner']) {
			showFormElementAuthor($render,$picture['Owner'],_('Owner:'));
		}
		showFormElementAction($render,'updatePicture');
		showFormElementEnd($render,_('Update'));

		$render->show('<h2>'._('Rotate').'</h2>');
		showFormElementStart($render);
		showFormElementPictureID($render,$picture['PictureID']);
		showFormElementHidden($render,'rotate','90');
		showFormElementAction($render,'rotate');
		$render->show('<img src="rotate_cw.png">');
		showFormElementEnd($render,_('Rotate right'));

		showFormElementStart($render);
		showFormElementPictureID($render,$picture['PictureID']);
		showFormElementHidden($render,'rotate','270');
		showFormElementAction($render,'rotate');
		$render->show('<img src="rotate_ccw.png">');
		showFormElementEnd($render,_('Rotate left'));

		$render->show('<h2>'._('Rebuild thumbnail').'</h2>');
		showFormElementStartRPC($render);
		showFormElementPictureID($render,$picture['PictureID']);
		showFormElementAction($render,'rebuildThumb');
		showFormElementEnd($render,_('Rebuild thumbnail'));

		$render->show('<h2>'._('Change picture').'</h2>');
		showFormElementStartUpload($render,$tof->uploadImageLimit);
		$render->show(_('New picture: '));
		showFormElementFile($render,"file","image/jpeg");
		showFormElementPictureID($render,$picture['PictureID']);
		showFormElementAction($render,'changePicture');
		showFormElementEnd($render,_('Update picture'));
	}
}

function showFormAddKeyword(&$render,$picture) {
	if ($picture) {
		require_once("render/form_keyword.php");
		$render->show('<div id="formKeywords">');
		$render->show('<h2>'._("Add keyword").'</h2>');
		$render->show('<p>'._("You can separate multiple values with a comma").'</p>');
		showFormElementStartRPC($render);
		showFormElementPictureID($render,$picture['PictureID']);
		showFormElementTypeSelector($render);
		showFormElementKeywordvalue($render);
		$topics = $render->ct->getTopicsOfPicture($picture['PictureID'],$render->uid);
		if ($topics[0]) {
			$keywords = $render->ct->getTopicKeywords($topics[0]['TopicID'],1);
			foreach($keywords as $keyword) {
				showFormElementCheckBox($render,
					"Keyword[]",false,$keyword['Value']." (".$keyword['count'].")<br>",$keyword['Value']);
			}
		}
		$render->keywordScript = $picture['PictureID'];
		showFormElementAction($render,"addKeyword");
		showFormElementEnd($render,_("Add keyword"));
		$render->show('</div>');
	}
}

/** show a form to delete a picture */
function showFormDeletePicture(&$render,$picture) {
	if ($picture) {
		$render->show('<h2>'._('Delete picture').'</h2>');
		$tmp = $render->view;
		$render->view = $render->selection;
		showFormElementStart($render);
		showFormElementPictureID($render,$picture['PictureID']);
		showFormBooleanField($render,'DeleteFiles',_('Delete files'),false);
		showFormElementAction($render,'deletePicture');
		showFormElementEnd($render,_('Delete'));
		$render->view = $tmp;
	}
}

/* private: show a form to add a comment */
function showFormAddComment(&$render,$pictureID) {
	$render->show('<div id="formComment">');
	$render->show('<h2>'._('Add comment').'</h2>');
	showFormElementStart($render);
	showFormElementPictureID($render,$pictureID);
	showFormElementComment($render);
	showFormElementAction($render,'addComment');
	showFormElementEnd($render,_('Add'));
	$render->show('</div>');
}

/* private: show a form to delete a comment */
function showFormDeleteComment(&$render,$commentID) {
	//  $render->show('<h2>'._('Delete comment').'</h2>');
	showFormElementStart($render);
	showFormElementCommentID($render,$commentID);
	showFormElementAction($render,'deleteComment');
	showFormElementEnd($render,_('Delete'));
}

function showFormRatePicture(&$render,$pictureID) {
	$render->show('<div id="formRate">');
	$render->show("<h2>"._("Rate this picture")."</h2>");
	showFormElementStart($render);
	showFormElementPictureID($render,$pictureID);
	showFormElementRate($render,$render->ct->getRate($pictureID,$render->uid));
	showFormElementAction($render,"addRate");
	showFormElementEnd($render,_("Rate"));
	$render->show("</div>");
}

function showFormSimilarPictures(&$render,$pictureID) {
	$render->show('<h2>'._('Find similar pictures').'</h2>');
	showFormElementStart($render,true,'get');
	showFormElementHidden($render,'SimilarPictures',$pictureID);
	showFormElementEnd($render,_('Find'));
}

/** Show FrameID form element */
function showFormElementPictureID(&$render,$pictureID = "", $name="PictureID") {
	if ($pictureID != "") {
		$render->show("<input type=\"hidden\" name=\"$name\" value=\"$pictureID\">");
	}
	else {
		$render->show(_("PictureID:")."<br><input type=\"text\" name=\"$name\"><br>");
	}
} 

function showFormElementRate(&$render,$note) {
	$render->show('<select name="Rating">');
	if ($note=='') {
		$render->show('<option selected>--</option>');
		for ($i=10;$i>=0;$i--) {
			$render->show("<option>$i</option>");
		}
	} else {
		for ($i=10;$i>=0;$i--) {
			if ($i == $note) {
				$render->show("<option selected>$i</option>");
			} else {
				$render->show("<option>$i</option>");
			}
		}
	}
	$render->show('</select>');
}

/** Show Comment form element */
function showFormElementComment(&$render,$comment = ""){
	$render->show(_('Comment:').'<br>');
	$render->show('<textarea rows="3" cols="40" name="Comment">' .
				  $comment . '</textarea><br>');
}
  
?>