/*
  Copyright (C) 2004 Laurent Martelli <laurent@aopsys.com>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU Lesser General Public License as
  published by the Free Software Foundation; either version 2 of the
  License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
  USA */

import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.Type1Font.Metrics;
import com.lowagie.text.pdf.Type1Font;
import java.util.Iterator;

/**
 * Utility to extract character widths
 *
 * Usage: java FontWidths <font_file>
 */
public class FontWidths {
    public static void main(String args[]) throws Exception {
        String filename = args[0];
        Type1Font font = new Type1Font(filename,BaseFont.WINANSI,false,null,null);
        /*
        Iterator it = font.getCharMetrics().iterator();
        while (it.hasNext()) {
            Metrics metrics = (Metrics)it.next();
            System.out.println(metrics.name+" "+metrics.width);
        }
        */
        
        String[] names = font.getDifferences();
        int[] widths = font.getWidths();
        for(int i=0; i<256; i++) {
            //System.out.println(i+" "+names[i]+" "+widths[i]);
            System.out.print(widths[i]);
            if (i<255)
                System.out.print(",");
            if ((i+1)%16==0 && i!=0)
                System.out.println("");    
        }
        System.out.println("");    
    }
}
