<?php
function _updateDiskUsage(&$tof,$vars) {
	if (isset($vars['UserID']))
		updateDiskUsage($tof,$vars['UserID']);
	else
		updateDiskUsage($tof);
}

function updateDiskUsage(&$tof,$userID = false) {
	require_once("actions/disk_usage.php");
	if ($userID === false) {
		// compute for all users
		echo "updateDiskUsage<br>";
		$pictures = $tof->ct->getPictures('Owner,PictureID,RollID,FrameID');
		$diskUsages = array();
		$total = 0;
		$tof->log(count($pictures)." pictures");
		foreach($pictures as $picture) {
			$owner = $picture['Owner'];
			$du = getPictureDiskUsage($tof,$picture);
			$total += $du;
			$tof->log($picture['PictureID']."($owner) -> $du");
			if (array_key_exists($owner,$diskUsages)) {
				$diskUsages[$owner]['DiskUsage'] += $du ;
			} else {
				$diskUsages[$owner] = 
					 array('UserID' => $owner,
						   'DiskUsage' => $du);
			}
		}
		$tof->log("Total = ".makeSizeString($total));
		$tof->ct->updateUsers($diskUsages);
	} else {
		// compute for a single user
		$user = $tof->ct->getUser($userID);
		$tof->log(
			sprintf(_('Previous disk usage: %s'),
					makeSizeString($user['DiskUsage'])));
		$diskUsage = getDiskUsage($tof,$userID);
		$tof->log(
			sprintf(_('New disk usage: %s'),
					makeSizeString($diskUsage)));
		$tof->ct->updateUser($userID,array('DiskUsage' => $diskUsage));
		if ($tof->uid == $userID) {
			$tof->setUser($userID);
		}
	}
}

?>