<?php
function _exportSelection(&$tof,$vars) {
	exportSelection(
		$tof,
		$vars['ExportThumb']=='true',
		$vars['ExportNormal']=='true',
		$vars['ExportFullSize']=='true');
}

/**
 * Outputs a tar file containing the selected pictures
 *
 * @param thumb if true, include thumbnails of picture in tar file
 * @param normal if true, include normal size picture in tar file
 * @param fullsize if true, include fullsize picture in tar file
 */
function _exportSelection(&$tof,$thumb,$normal,$fullsize) {
	if (!chdir($tof->basePath)) {
		$tof->error(
			sprintf(_("Failed to change current directory to %s"),
					$tof->basePath));
		return;
	}

	$tmp = tempnam ("/tmp", "tof_selection");
	$ftmp = fopen($tmp, "w");
	$selection = $tof->ct->getSelection($tof->uid);
	foreach($selection as $pictureID) {
		$picture = $tof->ct->getPicture($pictureID,$tof->uid);
		if ($picture) {
			if ($thumb) {
				$filename = $tof->getThumbFilename($picture,true);
				if (file_exists($filename))
					fwrite($ftmp,$filename."\n");
			}
			if ($normal) {
				$filename = $tof->getPictureFilename($picture,true);
				if (file_exists($filename))
					fwrite($ftmp,$filename."\n");
			}
			if ($fullsize) {
				$filename = $tof->getOrigFilename($picture,true);
				if (file_exists($filename))
					fwrite($ftmp,$filename."\n");
			}
		} else {
			$tof->warn(
				sprintf(_('Omitted picture #%s: access denied'),
						$pictureID));
		}
	}
	fclose($ftmp);

	$descriptors = 
		 array(
			 0 => array("pipe","r"), // stdin is a pipe that the child will read from
			 1 => array("pipe","w"), // stdout is a pipe that the child will write to
			 2 => array("pipe","r"));// stderr is a pipe that the child will read from
	  
	$process = proc_open(
		"tar cf - --files-from $tmp", 
		$descriptors, 
		$pipes);

	if (is_resource($process)) {
		fclose($pipes[0]);

		header("Content-Type: application/x-tar");
		header("Cache-Control: private");
		header("Pragma: ");

		while(!feof($pipes[1])) {
			echo fgets($pipes[1], 1024*8);
		}
		fclose($pipes[1]);
		fclose($pipes[2]);
		unlink($tmp);
		exit;
	} else {
		$tof->error(_('tar process failed'));
	}
}
?>