/* Copyright (C) 2009 Papavasileiou Dimitris                             
 *                                                                      
 * This program is free software: you can redistribute it and/or modify 
 * it under the terms of the GNU General Public License as published by 
 * the Free Software Foundation, either version 3 of the License, or    
 * (at your option) any later version.                                  
 *                                                                      
 * This program is distributed in the hope that it will be useful,      
 * but WITHOUT ANY WARRANTY; without even the implied warranty of       
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        
 * GNU General Public License for more details.                         
 *                                                                      
 * You should have received a copy of the GNU General Public License    
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <lua.h>
#include <lauxlib.h>
#include <GL/gl.h>
#include <time.h>
#include "vortex.h"

Vortex *vortices;

@implementation Vortex

+(double) evaluateAt: (double *)r
{
    id vortex;
    double scale;
    
    for (vortex = vortices, scale = 1;
	 vortex;
	 scale += [vortex evaluateAt: r],
	 vortex = [vortex next]);

    return scale;
}

-(Vortex *) init
{
    char *list[] = {"scale"};

    self = [super init];
    [self add: sizeof (list) / sizeof (char *) Properties: list];

    self->next = NULL;
    self->previous = NULL;
    
    self->scale = 0;
    
    return self;
}
    
-(id) next
{
    return (id)self->next;
}

-(double) evaluateAt: (double *)r
{
    double d[3], m_2;

    d[0] = [self translation][0] - r[0];
    d[1] = [self translation][1] - r[1];
    d[2] = [self translation][2] - r[2];
    
    m_2 = d[0] * d[0] + d[1] * d[1] + d[2] * d[2];
    m_2 = m_2 < 1 ? 1 : m_2;

    /* printf ("%f, %f, %f\n", */
    /* 	    [self translation][0], */
    /* 	    [self translation][1], */
    /* 	    [self translation][2]); */
    /* printf ("%f\n", m_2); */

    return self->scale / sqrt(m_2);
}

-(void) toggle
{
    [super toggle];

    if ([self linked]) {
	self->next = vortices;
	self->previous = NULL;

	if (vortices) {
	    vortices->previous = self;
	}
	
	vortices = self;
    } else {
	if (self->previous) {
	    self->previous->next = self->next;
	} else {
	    vortices = self->next;
	}

	if (self->next) {
	    self->next->previous = self->previous;
	}

	self->previous = NULL;
	self->next = NULL;
    }
}

-(void) get
{
    const char *k;

    k = lua_tostring (_L, 2);

    if (!xstrcmp(k, "scale")) {
	lua_pushnumber (_L, self->scale);
    } else {
	[super get];
    }
}

-(void) set
{    
    const char *k;

    k = lua_tostring (_L, 2);

    if (!xstrcmp(k, "scale")) {
	self->scale = lua_tonumber (_L, -1);
    } else {
	[super set];
    }
}

@end

