/* Copyright (C) 2009 Papavasileiou Dimitris                             
 *                                                                      
 * This program is free software: you can redistribute it and/or modify 
 * it under the terms of the GNU General Public License as published by 
 * the Free Software Foundation, either version 3 of the License, or    
 * (at your option) any later version.                                  
 *                                                                      
 * This program is distributed in the hope that it will be useful,      
 * but WITHOUT ANY WARRANTY; without even the implied warranty of       
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        
 * GNU General Public License for more details.                         
 *                                                                      
 * You should have received a copy of the GNU General Public License    
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "haze.h"

@implementation Haze

-(Haze *)init
{
    char *list[] = {"color", "linear", "quadratic"};

    [super init];
    [self add: sizeof (list) / sizeof (char *) Properties: list];

    self->density[0] = 0;
    self->density[1] = 0;

    self->color[0] = 1;
    self->color[1] = 1;
    self->color[2] = 1;

    return self;
}

-(void) setupFogState
{
    float fog[4] = {self->color[0],
		    self->color[1],
		    self->color[2],
		    1};

    if (self->density[0]) {
	glFogf (GL_FOG_MODE, GL_EXP);
	glFogf (GL_FOG_DENSITY, self->density[0]);
    } else {
	glFogf (GL_FOG_MODE, GL_EXP2);
	glFogf (GL_FOG_DENSITY, self->density[1]);
    }
    
    glFogfv (GL_FOG_COLOR, fog);		    
}

-(void) get
{
    const char *k;
    int i;

    k = lua_tostring (_L, 2);

    if (!xstrcmp(k, "linear")) {
	lua_pushnumber (_L, self->density[0]);
    } else if (!xstrcmp(k, "quadratic")) {
	lua_pushnumber (_L, self->density[1]);
    } else if (!xstrcmp(k, "color")) {
	lua_newtable (_L);
        
        for(i = 0; i < 3; i += 1) {
            lua_pushnumber (_L, self->color[i]);
            lua_rawseti (_L, -2, i + 1);
        }
    } else {
	[super get];
    }
}

-(void) set
{    
    const char *k;
    int i;

    k = lua_tostring (_L, 2);

    if (!xstrcmp(k, "linear")) {
	self->density[0] = lua_tonumber (_L, 3);
	self->density[1] = 0;
    } else if (!xstrcmp(k, "quadratic")) {
	self->density[0] = 0;
	self->density[1] = lua_tonumber (_L, 3);
    } else if (!xstrcmp(k, "color")) {
        if(lua_istable (_L, 3)) {
            for(i = 0 ; i < 3 ; i += 1) {
                lua_rawgeti (_L, 3, i + 1);
                self->color[i] = lua_tonumber (_L, -1);
                
                lua_pop (_L, 1);
            }
        }
    } else {
	[super set];
    }
}

@end
