/* Copyright (C) 2009 Papavasileiou Dimitris                             
 *                                                                      
 * This program is free software: you can redistribute it and/or modify 
 * it under the terms of the GNU General Public License as published by 
 * the Free Software Foundation, either version 3 of the License, or    
 * (at your option) any later version.                                  
 *                                                                      
 * This program is distributed in the hope that it will be useful,      
 * but WITHOUT ANY WARRANTY; without even the implied warranty of       
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        
 * GNU General Public License for more details.                         
 *                                                                      
 * You should have received a copy of the GNU General Public License    
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <lua.h>
#include <lauxlib.h>
#include <GL/gl.h>
#include <time.h>
#include "halo.h"

@implementation Halo

-(Halo *) init
{
    char *list[] = {"color", "opacity", "width"};

    [super init];
    [self add: sizeof (list) / sizeof (char *) Properties: list];

    self->color[0] = 0;
    self->color[1] = 0;
    self->color[2] = 0;
    self->color[3] = 1;

    self->width = 1;
    
    return self;
}
    
-(void) get
{
    const char *k;
    int i;

    k = lua_tostring (_L, 2);

    if (!xstrcmp(k, "color")) {
        lua_newtable (_L);
        
        for(i = 0; i < 3; i += 1) {
            lua_pushnumber (_L, self->color[i]);
            lua_rawseti (_L, -2, i + 1);
        }
    } else if (!xstrcmp(k, "width")) {
	lua_pushnumber (_L, self->width);
    } else if (!xstrcmp(k, "opacity")) {
	lua_pushnumber (_L, self->color[3]);
    } else {
	[super get];
    }
}

-(void) set
{    
    const char *k;
    int i;

    k = lua_tostring (_L, 2);

    if (!xstrcmp(k, "color")) {
        if(lua_istable (_L, 3)) {
            for(i = 0 ; i < 3 ; i += 1) {
                lua_rawgeti (_L, 3, i + 1);
                self->color[i] = lua_tonumber (_L, -1);
                
                lua_pop (_L, 1);
            }
        }
    } else if (!xstrcmp(k, "opacity")) {
	self->color[3] = lua_tonumber (_L, 3);
    } else if (!xstrcmp(k, "width")) {
	self->width = lua_tonumber (_L, -1);
    } else {
	[super set];
    }
}

-(void) traversePass: (int)pass
{
    if (pass == 2) {    
	glDepthMask(GL_FALSE);

	glCullFace (GL_FRONT);
	glColorMask (GL_FALSE, GL_FALSE, GL_FALSE, GL_FALSE);

	[super traversePass: 1];

	glColorMask (GL_TRUE, GL_TRUE, GL_TRUE, GL_TRUE);
	glUseProgramObjectARB (0);

	glEnable (GL_LINE_SMOOTH);
	glEnable (GL_POLYGON_OFFSET_LINE);
	glEnable (GL_BLEND);

	glPolygonOffset (1, 1);
	glPolygonMode (GL_FRONT_AND_BACK, GL_LINE);
	glBlendFunc (GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);    
    
	glLineWidth (self->width);
	glColor4fv (self->color);

	[super traversePass: 1];

	glCullFace (GL_BACK);
	glPolygonMode (GL_FRONT_AND_BACK, GL_FILL);

	glDisable (GL_BLEND);
	glDisable (GL_POLYGON_OFFSET_LINE);
	glDisable (GL_LINE_SMOOTH);
	glDepthMask(GL_TRUE);
    }
}

@end

