/* Copyright (C) 2009 Papavasileiou Dimitris                             
 *                                                                      
 * This program is free software: you can redistribute it and/or modify 
 * it under the terms of the GNU General Public License as published by 
 * the Free Software Foundation, either version 3 of the License, or    
 * (at your option) any later version.                                  
 *                                                                      
 * This program is distributed in the hope that it will be useful,      
 * but WITHOUT ANY WARRANTY; without even the implied warranty of       
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        
 * GNU General Public License for more details.                         
 *                                                                      
 * You should have received a copy of the GNU General Public License    
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef _FABRIC_H_
#define _FABRIC_H_

#include <lua.h>
#include <ode/ode.h>
#include "transform.h"

@interface Fabric: Transform {
    dBodyID body;
    
    double *areas, *velocity, *internal, *external;
    double *stretchLengths, *shearLengths, *bendLengths;
    double density, mobility, drag, stiffness[3], damping[3];

    float *vertices, *rest, *uv, *normals;
    unsigned int *indices;

    int *nodes, *stretchSprings, *shearSprings, *bendSprings;
    int size[6], reset, firststep, granularity;
}


-(Fabric *) initWithVertices: (float *)floats
               uvcoordinates: (float *) morefloats
		     indices: (unsigned int *)ints
	      stretchSprings: (int *)stretchNodes
	        shearSprings: (int *)shearNodes
		 bendSprings: (int *)bendNodes
		    andNodes: (int *)knots
		      ofSize: (int[6]) n;

-(void) freeBuffers;
-(int) vertices;
-(int) indices;

@end

#endif
