/* Copyright (C) 2009 Papavasileiou Dimitris                             
 *                                                                      
 * This program is free software: you can redistribute it and/or modify 
 * it under the terms of the GNU General Public License as published by 
 * the Free Software Foundation, either version 3 of the License, or    
 * (at your option) any later version.                                  
 *                                                                      
 * This program is distributed in the hope that it will be useful,      
 * but WITHOUT ANY WARRANTY; without even the implied warranty of       
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        
 * GNU General Public License for more details.                         
 *                                                                      
 * You should have received a copy of the GNU General Public License    
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <stdio.h>
#include <string.h>

#include <lua.h>
#include <lauxlib.h>

#define GETNORMALIZED(__type, __c)					\
    {									\
	__type *array;							\
									\
	if (lua_isnumber (L, 2)) {					\
	    array = (__type *)lua_tostring (L, lua_upvalueindex(1));	\
	    lua_pushnumber (L, array [lua_tointeger (L, 2) - 1] / (__c)); \
	}								\
									\
	return 1;							\
    }

#define SETNORMALIZED(__type, __c)				\
    {								\
	__type *array;					\
	int i, len;						\
								\
	if (lua_isnumber (L, 2)) {					  \
	    array = (__type *)lua_tostring (L, lua_upvalueindex(1));    \
	    len = lua_strlen (L, lua_upvalueindex(1)) / sizeof(__type); \
									\
	    if (lua_tonumber (L, 2) > len) {                          \
		for (i = 0 ; i < len ; i += 1) {		\
		    lua_pushnumber (L, (double)(array[i]) / (__c));	\
		    lua_rawseti (L, 1, i + 1);			\
		}							\
									\
		lua_pushnil (L);					\
		lua_setmetatable (L, 1);				\
									\
		lua_rawset (L, 1);					\
	    } else {							\
		array [lua_tointeger (L, 2) - 1] =			\
		    (__type)(lua_tonumber (L, 3) * (__c));		\
	    }								\
	} else {							\
	    lua_rawset (L, 1);						\
	}								\
									\
	return 1;							\
    }

#define GETTABLE(__type)						\
    {									\
	__type *array;						\
									\
	if (lua_isnumber (L, 2)) {					\
	    array = (__type *)lua_tostring (L, lua_upvalueindex(1));	\
	    lua_pushnumber (L, array [lua_tointeger (L, 2) - 1]);	\
	}								\
									\
	return 1;							\
    }

#define SETTABLE(__type)					\
    {								\
	__type *array;					\
	int i, len;						\
								\
	if (lua_isnumber (L, 2)) {					\
	    array = (__type *)lua_tostring (L, lua_upvalueindex(1));    \
	    len = lua_strlen (L, lua_upvalueindex(1)) / sizeof(__type); \
									\
	    if (lua_tonumber (L, 2) > len) {                          \
		for (i = 0 ; i < len ; i += 1) {		\
		    lua_pushnumber (L, array[i]);			\
		    lua_rawseti (L, 1, i + 1);			\
		}							\
									\
		lua_pushnil (L);					\
		lua_setmetatable (L, 1);				\
									\
		lua_rawset (L, 1);					\
	    } else {							\
		array [lua_tointeger (L, 2) - 1] =			\
		    (__type)(lua_tonumber (L, 3));			\
	    }								\
	} else {							\
	    lua_rawset (L, 1);						\
	}								\
									\
	return 1;							\
    }

#define CONSTRUCT(__type, __index, __newindex)				\
    {									\
	int i = lua_gettop (L);						\
									\
	lua_newtable (L);						\
									\
        lua_newtable (L);						\
	lua_pushstring(L, #__type);					\
	lua_pushvalue (L, i);						\
	lua_settable(L, -3);						\
	lua_pushstring(L, "__tostring");				\
	lua_pushvalue (L, i);						\
        lua_pushcclosure(L, (lua_CFunction)array_tostring, 1);		\
        lua_settable(L, -3);						\
	lua_pushstring(L, "__len");					\
	lua_pushinteger (L, lua_strlen (L, i) / sizeof(__type));	\
	lua_pushcclosure(L, (lua_CFunction)array_len, 1);		\
	lua_settable(L, -3);						\
	lua_pushstring(L, "__index");					\
	lua_pushvalue (L, i);						\
	lua_pushcclosure(L, (lua_CFunction)__index, 1);			\
	lua_settable(L, -3);						\
	lua_pushstring(L, "__newindex");				\
	lua_pushvalue (L, i);						\
	lua_pushcclosure(L, (lua_CFunction)__newindex, 1);		\
	lua_settable(L, -3);						\
        lua_setmetatable(L, -2);                           		\
    }
					     
static int array_len(lua_State *L)
{
    lua_pushvalue (L, lua_upvalueindex (1));
   
    return 1;
}

static int array_tostring(lua_State *L)
{
    lua_pushvalue (L, lua_upvalueindex (1));
   
    return 1;
}

static int byte_index (lua_State *L) GETNORMALIZED(char, CHAR_MAX);
static int byte_newindex (lua_State *L) SETNORMALIZED(char, CHAR_MAX);
static int ubyte_index (lua_State *L) GETNORMALIZED(unsigned char, UCHAR_MAX);
static int ubyte_newindex (lua_State *L) SETNORMALIZED(unsigned char, UCHAR_MAX);
static int char_index (lua_State *L) GETTABLE(char);
static int char_newindex (lua_State *L) SETTABLE(char);
static int uchar_index (lua_State *L) GETTABLE(unsigned char);
static int uchar_newindex (lua_State *L) SETTABLE(unsigned char);
static int short_index (lua_State *L) GETTABLE(short);
static int short_newindex (lua_State *L) SETTABLE(short);
static int ushort_index (lua_State *L) GETTABLE(unsigned short);
static int ushort_newindex (lua_State *L) SETTABLE(unsigned short);
static int int_index (lua_State *L) GETTABLE(int);
static int int_newindex (lua_State *L) SETTABLE(int);
static int uint_index (lua_State *L) GETTABLE(unsigned int);
static int uint_newindex (lua_State *L) SETTABLE(unsigned int);
static int float_index (lua_State *L) GETTABLE(float);
static int float_newindex (lua_State *L) SETTABLE(float);
static int double_index (lua_State *L) GETTABLE(double);
static int double_newindex (lua_State *L) SETTABLE(double);

void luaX_pushunsignedbytes (lua_State *L) CONSTRUCT (unsigned char,
						      ubyte_index,
						      ubyte_newindex);

void luaX_pushbytes (lua_State *L) CONSTRUCT (char,
					      byte_index,
					      byte_newindex);

void luaX_pushunsignedchars (lua_State *L) CONSTRUCT (unsigned char,
						      uchar_index,
						      uchar_newindex);

void luaX_pushchars (lua_State *L) CONSTRUCT (char,
					      char_index,
					      char_newindex);

void luaX_pushunsignedshorts (lua_State *L) CONSTRUCT (unsigned short,
						       ushort_index,
						       ushort_newindex);

void luaX_pushshorts (lua_State *L) CONSTRUCT (short,
					       short_index,
					       short_newindex);

void luaX_pushunsignedints (lua_State *L) CONSTRUCT (unsigned int,
						     uint_index,
						     uint_newindex);

void luaX_pushints (lua_State *L) CONSTRUCT (int,
					     int_index,
					     int_newindex);

void luaX_pushfloats (lua_State *L) CONSTRUCT (float,
					       float_index,
					       float_newindex);

void luaX_pushdoubles (lua_State *L) CONSTRUCT (double,
						double_index,
						double_newindex);

int luaX_objlen (lua_State *L, int i)
{
    if (lua_istable (L, i) && lua_getmetatable (L, i)) {
	lua_getfield (L, -1, "__len");
	
	if (lua_isfunction(L, -1)) {
	    lua_pushvalue (L, i);
	    luaX_call (L, 1, 1);

	    i = lua_tointeger (L, -1);

	    lua_pop (L, 2);
	} else {
	    /* Pop the metamethod and metatable and
	       call objlen directly. */
	    
	    lua_pop (L, 2);
	    i = lua_objlen (L, i);
	}
    } else {
	i = lua_objlen (L, i);
    }
    
    return  i;
}

void luaX_call (lua_State *L, int nargs, int nresults)
{
    int traceback;

    /* Calls from Lua to C which are nested inside other
       calls to C get a new stack so first check if the
       traceback function is available. */
    
    lua_getglobal (_L, "debug");
    lua_getfield (_L, -1, "traceback");

    traceback = lua_equal (_L, -1, 1);

    lua_pop (_L, 2);

    if (lua_pcall (L, nargs, nresults, traceback)) {
	lua_error (L);
    }
}

int xstrcmp (const char *a, const char *b)
{
    if (a == NULL) {
	return -1;
    } else if (b == NULL) {
	return 1;
    } else {
	return strcmp (a, b);
    }
}
