/* Copyright (C) 2009 Papavasileiou Dimitris                             
 *                                                                      
 * This program is free software: you can redistribute it and/or modify 
 * it under the terms of the GNU General Public License as published by 
 * the Free Software Foundation, either version 3 of the License, or    
 * (at your option) any later version.                                  
 *                                                                      
 * This program is distributed in the hope that it will be useful,      
 * but WITHOUT ANY WARRANTY; without even the implied warranty of       
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        
 * GNU General Public License for more details.                         
 *                                                                      
 * You should have received a copy of the GNU General Public License    
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <ode/ode.h>
#include <lua.h>
#include <lualib.h>
#include <lauxlib.h>

#include "box.h"

@implementation Box

-(Box *) init
{
    char *list[] = {"size"};

    self->geom = dCreateBox (NULL, 1, 1, 1);
    dGeomSetData (self->geom, self);
    
    self->size[0] = 1;
    self->size[1] = 1;
    self->size[2] = 1;

    self = [super init];
    [self add: sizeof (list) / sizeof (char *) Properties: list];

    return self;
}

-(void) get
{
    const char *k;
    int i;
    
    k = lua_tostring (_L, -1);

    if (!xstrcmp(k, "size")) {
        lua_newtable (_L);
        
        for(i = 0; i < 3; i += 1) {
            lua_pushnumber (_L, self->size[i]);
            lua_rawseti (_L, -2, i + 1);
        }
    } else {
	[super get];
    }
}

-(void) set
{
    const char *k;
    int i;

    k = lua_tostring (_L, -2);

    if (!xstrcmp(k, "size")) {
        if(lua_istable (_L, 3)) {
            for(i = 0 ; i < 3 ; i += 1) {
                lua_rawgeti (_L, 3, i + 1);
                self->size[i] = lua_tonumber (_L, -1);
                
                lua_pop (_L, 1);
            }
        }

	dGeomBoxSetLengths ([self geom],
			    self->size[0],
			    self->size[1],
			    self->size[2]);
    } else {
	[super set];
    }
}

-(void) traversePass: (int)pass
{
    dReal *l;

    if (pass == 1 && self->debug) {
	glUseProgramObjectARB(0);

	l = self->size;

	glMatrixMode (GL_MODELVIEW);
	glPushMatrix();
	glMultMatrixd ([self matrix]);

	glPolygonMode (GL_FRONT_AND_BACK, GL_LINE);
	glEnable (GL_DEPTH_TEST);

	glColor3f (1, 0, 0);
	glLineWidth (1);

	glBegin (GL_QUAD_STRIP);
	
	glVertex3f(-0.5 * l[0], -0.5 * l[1], -0.5 * l[2]);
	glVertex3f(-0.5 * l[0], -0.5 * l[1], 0.5 * l[2]);
	glVertex3f(-0.5 * l[0], 0.5 * l[1], -0.5 * l[2]);
	glVertex3f(-0.5 * l[0], 0.5 * l[1], 0.5 * l[2]);

	glVertex3f(0.5 * l[0], 0.5 * l[1], -0.5 * l[2]);
	glVertex3f(0.5 * l[0], 0.5 * l[1], 0.5 * l[2]);
 
	glVertex3f(0.5 * l[0], -0.5 * l[1], -0.5 * l[2]);
	glVertex3f(0.5 * l[0], -0.5 * l[1], 0.5 * l[2]);
       
	glVertex3f(-0.5 * l[0], -0.5 * l[1], -0.5 * l[2]);
	glVertex3f(-0.5 * l[0], -0.5 * l[1], 0.5 * l[2]);

	glEnd();

	glDisable (GL_DEPTH_TEST);
	glPolygonMode (GL_FRONT_AND_BACK, GL_FILL);

	glPopMatrix();
    }
    
    [super traversePass: pass];
}

@end
