/* Copyright (C) 2009 Papavasileiou Dimitris                             
 *                                                                      
 * This program is free software: you can redistribute it and/or modify 
 * it under the terms of the GNU General Public License as published by 
 * the Free Software Foundation, either version 3 of the License, or    
 * (at your option) any later version.                                  
 *                                                                      
 * This program is distributed in the hope that it will be useful,      
 * but WITHOUT ANY WARRANTY; without even the implied warranty of       
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        
 * GNU General Public License for more details.                         
 *                                                                      
 * You should have received a copy of the GNU General Public License    
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <stdlib.h>
#include <ctype.h>
#include <lua.h>
#include <lauxlib.h>
#include <AL/al.h>

#include "sample.h"
#include "loop.h"

static char *decapitalize (char *s)
{
    s[0] = tolower(s[0]);

    return s;
}

static int generic_tostring(lua_State *L)
{
    id object;

    object = *(id *)lua_touserdata (L, 1);
    lua_pushstring (L, [object name]);
   
    return 1;
}

static int generic_index(lua_State *L)
{
    id object;

    object = *(id *)lua_touserdata(L, 1);
    
    [object get];
    
    return 1;
}

static int generic_newindex(lua_State *L)
{
    id object;

    object = *(id *)lua_touserdata(L, 1);
    
    [object set];

    return 0;
}

static int generic_gc(lua_State *L)
{
    id object;

    object = *(id *)lua_touserdata(L, 1);

    [object free];

    return 0;
}

static int sample_len(lua_State *L)
{
    id object;

    object = *(id *)lua_touserdata(L, 1);

    lua_newtable(L);
    
    lua_pushnumber(L, [object length]);
    lua_rawseti(L, -2, 1);

    lua_pushnumber(L, [object frequency]);
    lua_rawseti(L, -2, 2);

    return 1;
}

static int sample_call (lua_State *L)
{
    id object, copy;

    object = *(id *)lua_touserdata(L, 1);
    copy = [[object copy] init];
    
    /* Create the userdata... */
	
    *(id *)lua_newuserdata(L, sizeof(id)) = copy;
    
    lua_newtable (L);
    lua_pushstring(L, "__len");
    lua_pushcfunction(L, sample_len);
    lua_settable(L, -3);
    lua_pushstring(L, "__index");
    lua_pushcfunction(L, generic_index);
    lua_settable(L, -3);
    lua_pushstring(L, "__newindex");
    lua_pushcfunction(L, generic_newindex);
    lua_settable(L, -3);
    lua_pushstring(L, "__tostring");
    lua_pushcfunction(L, generic_tostring);
    lua_settable(L, -3);
    lua_pushstring(L, "__gc");
    lua_pushcfunction(L, generic_gc);
    lua_settable(L, -3);
    lua_pushstring(L, "__reference");
    lua_pushvalue(L, 1);
    lua_settable(L, -3);
    lua_setmetatable(L, -2);
    
    /* ...and initialize it. */

    if(lua_istable(L, 2)) {
	lua_pushnil(L);
	
	while(lua_next(L, 2)) {
	    lua_pushvalue(L, -2);
	    lua_insert(L, -2);
	    lua_settable(L, 3);
	}
    }

    lua_pushstring (L, "userdata");
    lua_gettable (L, LUA_REGISTRYINDEX);
    lua_pushlightuserdata (L, copy);
    lua_pushvalue (L, 3);
    lua_settable (L, -3);
    lua_pop(L, 1);

    return 1;
}

static int sample_gc(lua_State *L)
{
    id object;

    object = *(id *)lua_touserdata(L, 1);

    [object freeBuffers];

    return 0;
}

int constructsample(lua_State *L)
{
    Class class;
    id object;
    ALshort *samples;
    int i, size, frequency;

    lua_pushvalue (L, lua_upvalueindex (1));
    class = (Class)lua_touserdata(L, -1);
    lua_pop(L, 1);
    
    luaL_checktype(L, 1, LUA_TTABLE);

    lua_pushstring(L, "size");
    lua_gettable(L, 1);
    
    size = lua_tonumber(L, -1);

    lua_pop(L, 1);

    lua_pushstring(L, "frequency");
    lua_gettable(L, 1);

    frequency = lua_tonumber(L, -1);

    lua_pop(L, 1);

    lua_pushstring(L, "samples");
    lua_gettable(L, 1);
     
    if (!lua_getmetatable (L, -1)) {
	lua_newtable(L);
    }

    lua_getfield (L, -1, "short");
    
    if (lua_isstring (L, -1)) {
	samples = (short *)malloc(lua_strlen (L, -1));
	memcpy(samples, lua_tostring (L, -1), lua_strlen (L, -1));

	lua_pop (L, 2);
    } else {
	lua_pop (L, 2);
   
	samples = (ALshort *)malloc(size * sizeof(ALshort));

	for(i = 0 ; i < size ; i += 1) {
	    lua_pushinteger (L, i + 1);
	    lua_gettable (L, -2);

	    samples[i] = (ALshort)(lua_tonumber(L, -1));
	
	    lua_pop(L, 1);
	}
    }

    lua_pop(L, 1);

    /* Create and initialize the sample userdata. */

    object = [[class alloc] initWithSamples: samples
	                             ofSize: size
	                        atFrequency: frequency];
    
    *(id *)lua_newuserdata(L, sizeof(id)) = object;

    lua_newtable(L);
    lua_pushstring(L, "__tostring");
    lua_pushcfunction(L, generic_tostring);
    lua_settable(L, -3);
    lua_pushstring(L, "__call");
    lua_pushcfunction(L, sample_call);
    lua_settable(L, -3);
    lua_pushstring(L, "__gc");
    lua_pushcfunction(L, sample_gc);
    lua_settable(L, -3);
    lua_setmetatable(L, -2);

    free (samples);
    
    return 1;
}

int luaopen_accoustics (lua_State *L)
{
    int i;

    Class nodes[] = {
	[Sample class], [Loop class]
    };	

    lua_newtable (L);    
    
    for (i = 0 ; i < sizeof(nodes) / sizeof(nodes[0]) ; i += 1) {
	lua_pushlightuserdata (L, nodes[i]);
	lua_pushcclosure (L, constructsample, 1);
	lua_setfield(L, -2, decapitalize(strdupa([nodes[i] name])));
    }

    lua_setglobal (L, "sources");

    return 0;
}
