-- Copyright (C) 2009 Papavasileiou Dimitris                             
--                                                                      
-- This program is free software: you can redistribute it and/or modify 
-- it under the terms of the GNU General Public License as published by 
-- the Free Software Foundation, either version 3 of the License, or    
-- (at your option) any later version.                                  
--                                                                      
-- This program is distributed in the hope that it will be useful,      
-- but WITHOUT ANY WARRANTY; without even the implied warranty of       
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        
-- GNU General Public License for more details.                         
--                                                                      
-- You should have received a copy of the GNU General Public License    
-- along with this program.  If not, see <http://www.gnu.org/licenses/>.

require "network"
require "resources"
require "derived"
require "aviation"
require "nature"
require "widgets"
require "shapes"
require "shading"
require "transforms"
require "frames"
require "moremath"
require "moremeshes"
require "particulate"
require "units"
require "toon"

graphics.close = function ()
		    common.iterate = false
		 end

dynamics.collision = function (a, b)
			return 0.1, 0.1, 1
		     end

-- These values are fixed.

graphics.title = "Aviation"
graphics.window = {800, 600}
graphics.hide = false
graphics.canvas = {0.07, 0.07, 0.075}

derived.gee = units.meters(-9.81)
derived.range = units.meters{0.1, 100000}
derived.field = 47

dynamics.collision = {}

-- Air pressure wrt to height in sl/ft^2

aviation.pressure = {
   units.feet (0.0000e+00), units.slugspersquarefeet (6.5774e+01), 
   units.feet (3.6089e+03), units.slugspersquarefeet (5.7637e+01), 
   units.feet (7.2178e+03), units.slugspersquarefeet (5.0335e+01), 
   units.feet (1.0827e+04), units.slugspersquarefeet (4.3801e+01), 
   units.feet (1.4436e+04), units.slugspersquarefeet (3.7971e+01), 
   units.feet (1.8045e+04), units.slugspersquarefeet (3.2786e+01), 
   units.feet (2.1654e+04), units.slugspersquarefeet (2.8190e+01), 
   units.feet (2.5262e+04), units.slugspersquarefeet (2.4130e+01), 
   units.feet (2.8871e+04), units.slugspersquarefeet (2.0557e+01), 
   units.feet (3.2480e+04), units.slugspersquarefeet (1.7425e+01)
}

-- Air density wrt to height in sl/ft^3

aviation.density = {
   units.feet (0.0000e+00), units.slugspercubicfeet (2.3769e-03), 
   units.feet (3.6089e+03), units.slugspercubicfeet (2.1358e-03), 
   units.feet (7.2178e+03), units.slugspercubicfeet (1.9140e-03), 
   units.feet (1.0827e+04), units.slugspercubicfeet (1.7101e-03), 
   units.feet (1.4436e+04), units.slugspercubicfeet (1.5234e-03), 
   units.feet (1.8045e+04), units.slugspercubicfeet (1.3526e-03), 
   units.feet (2.1654e+04), units.slugspercubicfeet (1.1969e-03), 
   units.feet (2.5262e+04), units.slugspercubicfeet (1.0553e-03), 
   units.feet (2.8871e+04), units.slugspercubicfeet (9.2687e-04), 
   units.feet (3.2480e+04), units.slugspercubicfeet (8.1076e-04)
}

graph.sky = nature.atmosphere {
   size = {512, 128},

   sun = {math.pi, math.pi / 3},
   turbidity = 4,
   
   --    frames.timer {
   --       period = 0.5,

   --       tick = function (self, tick, delta, elapsed)
   -- -- 		print (2 + tick * 0.1)
   -- 		self.parent.sun = {math.pi, math.pi / (2 + tick * 0.1)}
   -- 	     end
   --    },

   sunlight = shading.light {
      position = math.rotate({0, 0, 1e3}, {1, 0, 0}, 0),
      
      orientation = transforms.euler (
	 180,
	 90 - math.deg(4 * math.pi / 3),
	 math.deg(math.pi / 2.4)
      ),
      
      intensity = {1, 1, 0.8},   
      size = {0, 0},
   },

   skylight = shading.ambient {
      orientation = transforms.euler (0, 180, 0),
      intensity = resources.clamped "scripts/imagery/light/horizon.lua"
   },

   system = bodies.system {
--       plane = resources.airplane "scripts/c172.lua",
      
      observer = resources.dofile "scripts/mouselook.lua" {
	 azimuth = 187,
	 elevation = 100,
	 latitude = -26,
	 longitude = -266,
	 height = 477
      },

      foo = shading.lambert {
	 position = {0, 0, 480},

	 diffuse = {1, 0, 0},
	 mesh = meshes.static(meshes.sphere(5, 16, 16)){}
      },
      
      particles = shading.sprites {
--	 texture = resources.periodic "scripts/imagery/smoke.lua",

	 smoke = particulate.fluid {
	    position = {0, 0, 480},

	    size = 256,
	    hashes = 1033,

	    scale = 50,
	    clustering = 64,
	    diffusion = 3e-3,
	    density = 100e-2,
	    support = 20,
	    stiffness = 10,
	    viscosity = 2e-3,

	    lifespan = frames.timer {
	       period = 0.3,

	       tick = function (self, tick, delta, elapsed)
			 self.parent.size = self.parent.size - 1
		      end
	    },

	    emitter = frames.timer {
	       period = 0.02,

	       link = function (self)
			 for i = 1, self.parent.size do
			    self.parent[i] = {math.random () * 1e9,
					      math.random () * 1e9,
					      math.random () * 1e9,
					      
					      0, 0, 0}
			 end
		      end,

	       tick = function (self, tick, delta, elapsed)
			 local V, theta, phi, x, y
			 local particle

			 for i = 1, 50 * delta do
			    x = 5 * (math.random () - 0.5)
			    y = 5 * (math.random () - 0.5)

			    V = 10
			    theta = 1.5 * (math.random () - 0.5)
			    phi = 1.5 * (math.random () - 0.5)

			    particle = {
			       x, y, 0,
			       
			       V * math.sin(theta) * math.cos(phi),
			       V * math.sin(phi),
			       V * math.cos(theta) * math.cos(phi)
			    }

			    self.parent[(tick + i) % self.parent.size] = particle
			 end
		      end
	    },
	 },
      },

      earth = resources.elevation "scripts/america/america.lua" {
	 position = units.meters{-12.5 * 4096, -15 * 4096, 85},

	 target = 15000
      }
   }
}

-- aircraft.chessna = graph.sky.system.plane

-- graph.events = frames.event {
--    buttonpress = function(self, button, x, y)
--       local x_0, y_0 = x, y

--       if button == 1 then
-- 	 self.motion = function (self, button, x, y)
-- 	    local w = graphics.window

-- 	    aircraft.chessna.ailerons = math.clamp(-(x - x_0) / w[1],
-- 						   units.degrees (-15),
-- 						   units.degrees (20))

-- 	    aircraft.chessna.elevators = math.clamp(-(y - y_0) / w[2],
-- 						    units.degrees (-23),
-- 						    units.degrees (28))
-- 		       end
--       elseif button == 2 then
-- 	 self.motion = function (self, button, x, y)
-- 	    local w = graphics.window
			  
-- 	    aircraft.chessna.rudder = math.clamp((x - x_0) / w[1],
-- 						 units.degrees (-16),
-- 						 units.degrees (16))
-- 	 end
--       elseif button == 4 then
-- 	 aircraft.chessna.engine.throttle = aircraft.chessna.engine.throttle + 0.1
--       elseif button == 5 then
-- 	 aircraft.chessna.engine.throttle = aircraft.chessna.engine.throttle - 0.1
--       end
--    end,
   
--    keypress = function(self, key)
-- 		 if key == 'q' then
-- 		    common.iterate = false
-- 		 elseif key == 'p' then
-- 		    dynamics.timescale = 0
-- 		 end
-- 	      end,
   
--    buttonrelease = function(self, button)
--       self.motion = nil
		      
--       aircraft.chessna.ailerons = 0
--       aircraft.chessna.elevators = 0
--       aircraft.chessna.rudder = 0
--    end
-- }

local n_0 = 0

graph.framerate = frames.timer {
   period = 1,
   tick = function (self, tick, delta, elapsed)
	     print ("Framerate: " .. tostring ((graphics.frames - n_0) / delta))
	     n_0 = graphics.frames
	  end
}

   fw190 = {
      bent = resources.polyhedron "scripts/polyhedra/fw190/bent.lua",
      nose = resources.polyhedron "scripts/polyhedra/fw190/nose.lua",
      tail = resources.polyhedron "scripts/polyhedra/fw190/tail.lua",
      leftwing = resources.polyhedron "scripts/polyhedra/fw190/leftwing.lua",
      rightwing = resources.polyhedron "scripts/polyhedra/fw190/rightwing.lua",
   },

   fw190 = resources.clamped "scripts/imagery/fw190.lua",

   fw190 = {
      bent = resources.static "scripts/meshes/fw190/bent.lua",
      nose = resources.static "scripts/meshes/fw190/nose.lua",
      tail = resources.static "scripts/meshes/fw190/tail.lua",
      leftwing = resources.static "scripts/meshes/fw190/leftwing.lua",
      rightwing = resources.static "scripts/meshes/fw190/rightwing.lua",

      propeller = resources.static "scripts/meshes/fw190/propeller.lua",
      fuselage = resources.static "scripts/meshes/fw190/fuselage.lua",
      canopy = resources.static "scripts/meshes/fw190/canopy.lua",
      cockpit = resources.static "scripts/meshes/fw190/cockpit.lua",
      panel = resources.static "scripts/meshes/fw190/panel.lua",
      leftaileron = resources.static "scripts/meshes/fw190/leftaileron.lua",
      rightaileron = resources.static "scripts/meshes/fw190/rightaileron.lua",
      leftelevator = resources.static "scripts/meshes/fw190/leftelevator.lua",
      rightelevator = resources.static "scripts/meshes/fw190/rightelevator.lua",
      rudder = resources.static "scripts/meshes/fw190/rudder.lua",
      engine = resources.static "scripts/meshes/fw190/engine.lua",
   },

resources.polyhedra = {
   edge = {
      nose = resources.polyhedron "scripts/edge/polyhedra/nose.lua",
      tail = resources.polyhedron "scripts/edge/polyhedra/tail.lua",
      leftwing = resources.polyhedron "scripts/edge/polyhedra/leftwing.lua",
      rightwing = resources.polyhedron "scripts/edge/polyhedra/rightwing.lua",
   }
}
      nose = resources.static "scripts/edge/meshes/nose.lua",
      tail = resources.static "scripts/edge/meshes/tail.lua",
      leftwing = resources.static "scripts/edge/meshes/leftwing.lua",
      rightwing = resources.static "scripts/edge/meshes/rightwing.lua",

   fw190 = resources.airplane "scripts/fw190.lua",

   -- C172 specs

   position = units.meters{1000, 100, 1800},

   orientation = transforms.euler (0, 0, 0),
   velocity = units.knots{150, 0, 0},

   mass = {units.pounds (2405),
	   {0, 0, 0},
	   units.slugsquarefeet {948,  0, 0,
				 0, 1346, 0,
				 0, 0, 1967}},

   isairplane = true,

   -- Aerodynamic specs.

   area = units.squarefeet (174),
   span = units.feet (35.8),
   chord = units.feet (4.9),

   drag = {
      attack = {
	    -3.14159, 0.15000,
	    -2.93215, 0.20000,
	    -2.61799, 0.40000,
	    -2.09439, 0.65000,
	    -1.57079, 1.00000,
	    -1.04719, 0.65000,
	    -0.52359, 0.40000,
	    -0.26179, 0.08000,
	    -0.10471, 0.03500,
	    -0.08726, 0.03300,
	    -0.06981, 0.03100,
	    -0.05235, 0.03000,
	    -0.03490, 0.03000,
	    -0.01745, 0.03100,
	 0.00000, 0.03300,
	 0.01745, 0.03500,
	 0.03491, 0.03800,
	 0.05236, 0.04200,
	 0.06981, 0.04600,
	 0.08727, 0.05100,
	 0.10472, 0.05600,
	 0.13963, 0.06900,
	 0.15708, 0.07600,
	 0.17453, 0.08400,
	 0.19199, 0.09300,
	 0.20944, 0.10200,
	 0.22689, 0.11200,
	 0.24435, 0.11500,
	 0.26180, 0.12000,
	 0.27925, 0.13000,
	 0.29671, 0.13800,
	 0.31416, 0.14500,
	 0.33161, 0.15000,
	 0.34907, 0.16500,
	 0.36652, 0.17500,
	 0.38397, 0.35000,
	 0.52360, 0.65000,
	 1.04720, 1.00000,
	 1.57080, 0.65000,
	 2.09439, 0.40000,
	 2.61799, 0.20000,
	 3.05433, 0.15000,
	 3.14159, 0.15000
      },
   },
   
   sideforce = {
      sideslip = {
	    -math.pi, -math.pi * -0.31,
	 math.pi,  math.pi * -0.31
      },

      roll = {
	    -math.pi, -math.pi * -0.037,
	 math.pi,  math.pi * -0.037
      },

      yaw = {
	    -math.pi, -math.pi * 0.21,
	 math.pi,  math.pi * 0.21
      },

      rudder = {
	    -math.pi, -math.pi * 0.187,
	 math.pi,  math.pi * 0.187
      }
   },
   
   lift = {
      attack = {
	    -2.93215, 0.30000,
	    -2.61799, 0.15000,
	    -2.09439, 0.10000,
	    -1.57079, 0.00000,
	    -0.06981, -0.15300,
	    -0.05235, -0.07600,
	    -0.03490, 0.00100,
	    -0.01745, 0.07800,
	 0.00000, 0.15500,
	 0.01745, 0.23200,
	 0.03491, 0.30900,
	 0.05236, 0.38600,
	 0.06981, 0.46300,
	 0.08727, 0.54000,
	 0.10472, 0.61700,
	 0.12217, 0.69400,
	 0.13963, 0.77100,
	 0.15708, 0.84800,
	 0.17453, 0.92500,
	 0.19199, 1.00200,
	 0.20944, 1.07900,
	 0.22689, 1.15600,
	 0.24435, 1.23300,
	 0.26180, 1.28000,
	 0.27925, 1.30000,
	 0.29671, 1.30000,
	 0.31416, 1.23000,
	 0.33161, 0.90000,
	 0.34907, 0.60000,
	 0.36652, 0.57500,
	 0.38397, 0.55000,
	 0.52360, 0.30000,
	 1.04720, 0.20000,
	 1.57080, 0.00000,
	 2.09439, -0.10000,
	 2.61799, -0.15000,
	 3.05433, -0.30000,
	 3.14159, -0.10000
      },
      
      pitch = {
	    -math.pi, -math.pi * 3.9,
	 math.pi,  math.pi * 3.9
      },

      elevators = {
	    -math.pi, -math.pi * 0.43,
	 math.pi,  math.pi * 0.43
      }
   },
   
   roll = {
      sideslip = {
	    -math.pi, -math.pi * -0.089,
	 math.pi,  math.pi * -0.089
      },
      
      roll = {
	    -math.pi, -math.pi * -0.47,
	 math.pi,  math.pi * -0.47
      },

      yaw = {
	    -math.pi, -math.pi * 0.096,
	 math.pi,  math.pi * 0.096
      },
      
      ailerons = {
	    -math.pi, -math.pi * -0.178,
	 math.pi,  math.pi * -0.178
      },
      
      rudder = {
	    -math.pi, -math.pi * 0.0147,
	 math.pi,  math.pi * 0.0147
      },
   },
   
   pitch = {
      attack = {
	    -3.14159, 0.00000,
	    -2.79253, 0.37000,
	    -2.44346, 0.59000,
	    -2.09439, 0.73000,
	    -1.74533, 0.79000,
	    -1.57080, 0.80000,
	    -1.39626, 0.78630,
	    -1.04720, 0.72469,
	    -0.69813, 0.60145,
	    -0.34907, 0.38920,
	    -0.17453, 0.11533,
	    -0.08727, 0.03767,
	 0.00000, -0.04000,
	 0.08727, -0.11767,
	 0.17453, -0.19533,
	 0.26148, -0.27300,
	 0.27925, -0.29000,
	 0.29671, -0.31500,
	 0.33161, -0.37500,
	 0.34907, -0.40500,
	 0.36652, -0.42000,
	 0.38397, -0.42000,
	 0.41888, -0.39000,
	 0.47124, -0.31500,
	 0.52360, -0.21500,
	 0.61086, -0.01000,
	 0.62832, 0.01500,
	 0.68068, 0.06500,
	 0.71558, 0.08500,
	 0.78540, 0.06000,
	 0.85521, 0.00500,
	 0.95993, -0.15000,
	 1.22173, -0.59500,
	 1.30900, -0.72000,
	 1.39626, -0.81500,
	 1.48353, -0.87500,
	 1.57080, -0.90000,
	 1.74533, -0.89000,
	 2.09439, -0.80000,
	 2.44346, -0.64000,
	 2.79253, -0.36000,
	 3.14159, 0.00000
      },

      attackrate = {
	    -math.pi, -math.pi * -5.2,
	 math.pi,  math.pi * -5.2
      },

      pitch = {
	    -math.pi, -math.pi * -12.4,
	 math.pi,  math.pi * -12.4
      },
      
      elevators = {
	    -math.pi, -math.pi * -1.28,
	 math.pi,  math.pi * -1.28
      },
   },

   yaw = {
      sideslip = {
	    -math.pi, -math.pi * 0.065,
	 math.pi,  math.pi * 0.065
      },	 
      
      roll = {
	    -math.pi, -math.pi * -0.03,
	 math.pi,  math.pi * -0.03
      },

      yaw = {
	    -math.pi, -math.pi * -0.099,
	 math.pi,  math.pi * -0.099
      },
      
      ailerons = {
	    -math.pi, -math.pi * -0.053,
	 math.pi,  math.pi * -0.053
      },
      
      rudder = {
	    -math.pi, -math.pi * -0.0657,
	 math.pi,  math.pi * -0.0657
      }
   },

   -- The engine.

   engine = propulsion.piston {
      orientation = transforms.euler (0, 90, 0),

      diameter = units.feet (6.25),
      inertia = units.slugsquarefeet(1.67),
      throttle = 1.0,
      ratio = 1.3,

      --        traverse = function (self)
      -- 		     print (self.speed)
      -- 		  end,

      brakepower = {
	 units.rotationsperminute(0)      , units.metrichorsepower(0), 
	 units.rotationsperminute(401.07) , units.metrichorsepower(0), 
	 units.rotationsperminute(1002.68), units.metrichorsepower(120), 
	 units.rotationsperminute(2005.35), units.metrichorsepower(234), 
	 units.rotationsperminute(2750.20), units.metrichorsepower(274), 
	 units.rotationsperminute(2998.48), units.metrichorsepower(240), 
	 units.rotationsperminute(3504.59), units.metrichorsepower(0)
      },
      
      thrust = {0.0,   0.068,
		0.1,   0.068,
		0.2,   0.067,
		0.3,   0.066,
		0.4,   0.064,
		0.5,   0.061,
		0.6,   0.057,
		0.7,   0.050,
		0.8,   0.040,
		0.9,   0.029,
		1.0,   0.019,
		1.1,   0.008,
		1.2,   -0.001,
		1.3,   -0.008,
		1.4,   -0.019,
		1.5,   -0.029,
		1.6,   -0.040,
		1.7,   -0.050,
		1.8,   -0.057,
		1.9,   -0.061,
		2.0,   -0.064,
		2.1,   -0.066,
		2.2,   -0.067,
		2.3,   -0.068,
		5.0,   -0.068,
		10.0,   -0.068},

      power = {0.0,   0.0580,
	       0.1,   0.0620,
	       0.2,   0.0600,
	       0.3,   0.0580,
	       0.4,   0.0520,
	       0.5,   0.0450,
	       0.6,   0.0421,
	       0.7,   0.0389,
	       0.8,   0.0346,
	       0.9,   0.0280,
	       1.0,   0.0202,
	       1.1,   0.0111,
	       1.2,   0.0075,
	       1.3,   0.0111,
	       1.4,   0.0202,
	       1.5,   0.0280,
	       1.6,   0.0346,
	       1.7,   0.0389,
	       1.8,   0.0421,
	       1.9,   0.0436,
	       2.0,   0.0445,
	       2.1,   0.0445,
	       2.2,   0.0442,
	       2.3,   0.0431,
	       2.4,   0.0424,
	       5.0,   0.0413,
	       10.0,  0.0413}
   },
